/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.HashSet;
import java.util.Set;

public final class FunctionAdapters {
    public static <T extends SoyPrintDirective> ImmutableMap<String, T> buildSpecificSoyDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet, Class<T> specificSoyDirectiveType) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet seenDirectiveNames = Sets.newHashSetWithExpectedSize((int)soyDirectivesSet.size());
        for (SoyPrintDirective directive : soyDirectivesSet) {
            if (!specificSoyDirectiveType.isAssignableFrom(directive.getClass())) continue;
            String directiveName = directive.getName();
            if (seenDirectiveNames.contains(directiveName)) {
                throw new IllegalStateException("Found two implementations of " + specificSoyDirectiveType.getSimpleName() + " with the same directive name '" + directiveName + "'.");
            }
            seenDirectiveNames.add(directiveName);
            mapBuilder.put((Object)directiveName, specificSoyDirectiveType.cast(directive));
        }
        return mapBuilder.build();
    }
}

