/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;

final class ReportSyntaxVersionErrorsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind DOUBLE_AMPERSAND_DOUBLE_PIPE_OR_BANG_IN_EXPR = SoyErrorKind.of("{0}: bad expression: ''{1}'', possibly due to using &&/||/! instead of and/or/not operators.");
    private static final SoyErrorKind DOUBLE_QUOTED_STRING = SoyErrorKind.of("{0}: bad expression: ''{1}'', possibly due to using double quotes instead of single quotes for string literal.");
    private static final SoyErrorKind GENERIC_NOT_PARSABLE_AS_V2_EXPR = SoyErrorKind.of("{0}: bad expression: ''{1}''.");
    private static final SoyErrorKind SYNTAX_VERSION_OUT_OF_BOUNDS = SoyErrorKind.of("{0}: {1}");
    private final SyntaxVersion requiredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final String errorPreamble;

    ReportSyntaxVersionErrorsVisitor(SyntaxVersion requiredSyntaxVersion, boolean isDeclared, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.requiredSyntaxVersion = requiredSyntaxVersion;
        this.errorPreamble = requiredSyntaxVersion == SyntaxVersion.V1_0 ? "incorrect v1 syntax" : (isDeclared ? "declared" : "inferred") + " syntax version " + (Object)((Object)requiredSyntaxVersion) + " not satisfied";
    }

    @Override
    public Void exec(SoyNode node) {
        this.visitSoyNode(node);
        return null;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (!node.couldHaveSyntaxVersionAtLeast(this.requiredSyntaxVersion)) {
            SyntaxVersionUpperBound syntaxVersionBound = node.getSyntaxVersionUpperBound();
            Preconditions.checkNotNull((Object)syntaxVersionBound);
            this.errorReporter.report(node.getSourceLocation(), SYNTAX_VERSION_OUT_OF_BOUNDS, this.errorPreamble, syntaxVersionBound.reasonStr);
        }
        if (node instanceof SoyNode.ExprHolderNode) {
            for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                if (exprUnion.getExpr() != null || this.requiredSyntaxVersion.num < SyntaxVersion.V2_0.num) continue;
                String exprText = exprUnion.getExprText();
                if (ReportSyntaxVersionErrorsVisitor.possiblyContainsDoubleQuotedString(exprText)) {
                    this.errorReporter.report(node.getSourceLocation(), DOUBLE_QUOTED_STRING, this.errorPreamble, exprText);
                    continue;
                }
                if (exprText.contains("&&") || exprText.contains("||") || exprText.contains("!")) {
                    this.errorReporter.report(node.getSourceLocation(), DOUBLE_AMPERSAND_DOUBLE_PIPE_OR_BANG_IN_EXPR, this.errorPreamble, exprText);
                    continue;
                }
                this.errorReporter.report(node.getSourceLocation(), GENERIC_NOT_PARSABLE_AS_V2_EXPR, this.errorPreamble, exprText);
            }
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private static boolean possiblyContainsDoubleQuotedString(String exprText) {
        int numSingleQuotes = 0;
        int numDoubleQuotes = 0;
        block4: for (int i = 0; i < exprText.length(); ++i) {
            switch (exprText.charAt(i)) {
                case '\'': {
                    ++numSingleQuotes;
                    continue block4;
                }
                case '\"': {
                    ++numDoubleQuotes;
                }
            }
        }
        return numDoubleQuotes >= 2 && numSingleQuotes <= 1;
    }
}

