/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.AssertStrictAutoescapingVisitor;
import com.google.template.soy.passes.CheckCallingParamTypesVisitor;
import com.google.template.soy.passes.CheckCallsVisitor;
import com.google.template.soy.passes.CheckDelegatesVisitor;
import com.google.template.soy.passes.CheckFunctionCallsVisitor;
import com.google.template.soy.passes.CheckTemplateParamsVisitor;
import com.google.template.soy.passes.CheckTemplateVisibility;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.InferRequiredSyntaxVersionVisitor;
import com.google.template.soy.passes.ReportSyntaxVersionErrorsVisitor;
import com.google.template.soy.passes.ResolveExpressionTypesVisitor;
import com.google.template.soy.passes.ResolveFunctionsVisitor;
import com.google.template.soy.passes.ResolveNamesVisitor;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesVisitor;
import com.google.template.soy.passes.RewriteGenderMsgsVisitor;
import com.google.template.soy.passes.RewriteRemaindersVisitor;
import com.google.template.soy.passes.SetFullCalleeNamesVisitor;
import com.google.template.soy.passes.StrictDepsVisitor;
import com.google.template.soy.passes.SubstituteGlobalsVisitor;
import com.google.template.soy.passes.VerifyPhnameAttrOnlyOnPlaceholdersVisitor;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Map;

public final class PassManager {
    private final ImmutableList<CompilerFilePass> singleFilePasses;
    private final ImmutableList<CompilerFileSetPass> fileSetPasses;
    private final SoyTypeRegistry registry;
    private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
    private final ErrorReporter errorReporter;
    private final SyntaxVersion declaredSyntaxVersion;
    private final SoyGeneralOptions options;
    private final boolean allowUnknownGlobals;
    private final boolean allowUnknownFunctions;

    private PassManager(Builder builder) {
        this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)builder.registry);
        this.soyFunctionMap = (ImmutableMap)Preconditions.checkNotNull((Object)builder.soyFunctionMap);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)builder.errorReporter);
        this.declaredSyntaxVersion = (SyntaxVersion)((Object)Preconditions.checkNotNull((Object)((Object)builder.declaredSyntaxVersion)));
        this.options = (SoyGeneralOptions)Preconditions.checkNotNull((Object)builder.opts);
        this.allowUnknownGlobals = builder.allowUnknownGlobals;
        this.allowUnknownFunctions = builder.allowUnknownFunctions;
        ImmutableList.Builder singleFilePassesBuilder = ImmutableList.builder().add((Object)new RewriteGendersPass()).add((Object)new RewriteRemaindersPass()).add((Object)new SetFullCalleeNamesPass()).add((Object)new ResolveNamesPass()).add((Object)new ResolveFunctionsPass()).add((Object)new ResolveExpressionTypesPass()).add((Object)new ResolvePackageRelativeCssNamesPass()).add((Object)new VerifyPhnameAttrOnlyOnPlaceholdersPass()).add((Object)new SubstituteGlobalsVisitorPass()).add((Object)new CheckSyntaxVersionPass());
        if (!this.allowUnknownFunctions) {
            singleFilePassesBuilder.add((Object)new CheckFunctionCallsPass());
        }
        if (this.options.isStrictAutoescapingRequired()) {
            singleFilePassesBuilder.add((Object)new EnforceStrictAutoescapingPass());
        }
        this.singleFilePasses = singleFilePassesBuilder.build();
        ImmutableList.Builder fileSetPassBuilder = ImmutableList.builder().add((Object)new CheckTemplateParamsPass()).add((Object)new CheckCallsPass()).add((Object)new CheckVisibilityPass()).add((Object)new CheckDelegatesPass());
        if (this.options.allowExternalCalls() == Boolean.FALSE) {
            fileSetPassBuilder.add((Object)new StrictDepsPass());
        }
        this.fileSetPasses = fileSetPassBuilder.build();
    }

    public void runSingleFilePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.singleFilePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    public void runWholeFilesetPasses(TemplateRegistry registry, SoyFileSetNode soyTree) {
        for (CompilerFileSetPass pass : this.fileSetPasses) {
            pass.run(soyTree, registry);
        }
    }

    private final class StrictDepsPass
    extends CompilerFileSetPass {
        private StrictDepsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new StrictDepsVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckVisibilityPass
    extends CompilerFileSetPass {
        private CheckVisibilityPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateVisibility(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckDelegatesPass
    extends CompilerFileSetPass {
        private CheckDelegatesPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckDelegatesVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckCallsPass
    extends CompilerFileSetPass {
        private CheckCallsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckCallsVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
            new CheckCallingParamTypesVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckTemplateParamsPass
    extends CompilerFileSetPass {
        private CheckTemplateParamsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateParamsVisitor(registry, PassManager.this.declaredSyntaxVersion, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class EnforceStrictAutoescapingPass
    extends CompilerFilePass {
        final AssertStrictAutoescapingVisitor visitor;

        private EnforceStrictAutoescapingPass() {
            this.visitor = new AssertStrictAutoescapingVisitor(PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            this.visitor.exec(file);
        }
    }

    private final class SubstituteGlobalsVisitorPass
    extends CompilerFilePass {
        SubstituteGlobalsVisitor substituteGlobalsVisitor;

        private SubstituteGlobalsVisitorPass() {
            this.substituteGlobalsVisitor = new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)PassManager.this.options.getCompileTimeGlobals(), PassManager.this.registry, !PassManager.this.allowUnknownGlobals, PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            this.substituteGlobalsVisitor.exec(file);
        }
    }

    private final class VerifyPhnameAttrOnlyOnPlaceholdersPass
    extends CompilerFilePass {
        private VerifyPhnameAttrOnlyOnPlaceholdersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new VerifyPhnameAttrOnlyOnPlaceholdersVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolvePackageRelativeCssNamesPass
    extends CompilerFilePass {
        private ResolvePackageRelativeCssNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolvePackageRelativeCssNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveExpressionTypesPass
    extends CompilerFilePass {
        private ResolveExpressionTypesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveExpressionTypesVisitor(PassManager.this.registry, PassManager.this.declaredSyntaxVersion, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveNamesPass
    extends CompilerFilePass {
        private ResolveNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveFunctionsPass
    extends CompilerFilePass {
        private ResolveFunctionsPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            SoytreeUtils.execOnAllV2Exprs(file, new ResolveFunctionsVisitor((ImmutableMap<String, ? extends SoyFunction>)PassManager.this.soyFunctionMap));
        }
    }

    private final class SetFullCalleeNamesPass
    extends CompilerFilePass {
        private SetFullCalleeNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new SetFullCalleeNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class RewriteRemaindersPass
    extends CompilerFilePass {
        private RewriteRemaindersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new RewriteRemaindersVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class RewriteGendersPass
    extends CompilerFilePass {
        private RewriteGendersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new RewriteGenderMsgsVisitor(nodeIdGen, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class CheckSyntaxVersionPass
    extends CompilerFilePass {
        final ReportSyntaxVersionErrorsVisitor reportDeclaredVersionErrors;
        final InferRequiredSyntaxVersionVisitor inferenceVisitor;

        private CheckSyntaxVersionPass() {
            this.reportDeclaredVersionErrors = new ReportSyntaxVersionErrorsVisitor(PassManager.this.declaredSyntaxVersion, true, PassManager.this.errorReporter);
            this.inferenceVisitor = new InferRequiredSyntaxVersionVisitor();
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            ErrorReporter.Checkpoint checkpoint = PassManager.this.errorReporter.checkpoint();
            this.reportDeclaredVersionErrors.exec(file);
            if (!PassManager.this.errorReporter.errorsSince(checkpoint)) {
                SyntaxVersion inferredSyntaxVersion = this.inferenceVisitor.exec(file);
                if (inferredSyntaxVersion.num > ((PassManager)PassManager.this).declaredSyntaxVersion.num) {
                    new ReportSyntaxVersionErrorsVisitor(inferredSyntaxVersion, false, PassManager.this.errorReporter).exec(file);
                }
            }
        }
    }

    private final class CheckFunctionCallsPass
    extends CompilerFilePass {
        final CheckFunctionCallsVisitor functionCallsVisitor;

        private CheckFunctionCallsPass() {
            this.functionCallsVisitor = new CheckFunctionCallsVisitor(PassManager.this.declaredSyntaxVersion, PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            this.functionCallsVisitor.exec(file);
        }
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
        private ErrorReporter errorReporter;
        private SyntaxVersion declaredSyntaxVersion;
        private SoyGeneralOptions opts;
        private boolean allowUnknownGlobals;
        private boolean allowUnknownFunctions;

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setSoyFunctionMap(ImmutableMap<String, ? extends SoyFunction> functionMap) {
            this.soyFunctionMap = (ImmutableMap)Preconditions.checkNotNull(functionMap);
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)registry);
            return this;
        }

        public Builder setDeclaredSyntaxVersion(SyntaxVersion declaredSyntaxVersion) {
            this.declaredSyntaxVersion = (SyntaxVersion)((Object)Preconditions.checkNotNull((Object)((Object)declaredSyntaxVersion)));
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions opts) {
            this.opts = opts;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder allowUnknownFunctions() {
            this.allowUnknownFunctions = true;
            return this;
        }

        public PassManager build() {
            return new PassManager(this);
        }
    }
}

