/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class GenCallCodeUtils {
    private final Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    @Inject
    protected GenCallCodeUtils(Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap, JsExprTranslator jsExprTranslator, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsExprTranslator = jsExprTranslator;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.soyJsSrcDirectivesMap = soyJsSrcDirectivesMap;
    }

    public JsExpr genCallExpr(CallNode callNode, Deque<Map<String, JsExpr>> localVarTranslations, TemplateAliases templateAliases, ErrorReporter errorReporter) {
        String calleeExprText;
        JsExpr objToPass = this.genObjToPass(callNode, localVarTranslations, templateAliases, errorReporter);
        if (callNode instanceof CallBasicNode) {
            calleeExprText = templateAliases.get(((CallBasicNode)callNode).getCalleeName());
        } else {
            String variantJsExprText;
            CallDelegateNode callDelegateNode = (CallDelegateNode)callNode;
            String calleeIdExprText = "soy.$$getDelTemplateId('" + callDelegateNode.getDelCalleeName() + "')";
            ExprRootNode variantSoyExpr = callDelegateNode.getDelCalleeVariantExpr();
            if (variantSoyExpr == null) {
                variantJsExprText = "''";
            } else {
                JsExpr variantJsExpr = this.jsExprTranslator.translateToJsExpr(variantSoyExpr, variantSoyExpr.toSourceString(), localVarTranslations, errorReporter);
                variantJsExprText = variantJsExpr.getText();
            }
            calleeExprText = "soy.$$getDelegateFn(" + calleeIdExprText + ", " + variantJsExprText + ", " + (callDelegateNode.allowsEmptyDefault() ? "true" : "false") + ")";
        }
        String callExprText = calleeExprText + "(" + objToPass.getText() + ", null, opt_ijData)";
        JsExpr result = new JsExpr(callExprText, Integer.MAX_VALUE);
        for (String directiveName : callNode.getEscapingDirectiveNames()) {
            SoyJsSrcPrintDirective directive = this.soyJsSrcDirectivesMap.get(directiveName);
            Preconditions.checkNotNull((Object)directive, (String)"Contextual autoescaping produced a bogus directive: %s", (Object[])new Object[]{directiveName});
            result = directive.applyForJsSrc(result, (List<JsExpr>)ImmutableList.of());
        }
        return result;
    }

    public JsExpr genObjToPass(CallNode callNode, Deque<Map<String, JsExpr>> localVarTranslations, TemplateAliases templateAliases, ErrorReporter errorReporter) {
        JsExpr dataToPass = callNode.dataAttribute().isPassingAllData() ? new JsExpr("opt_data", Integer.MAX_VALUE) : (callNode.dataAttribute().isPassingData() ? this.jsExprTranslator.translateToJsExpr(callNode.dataAttribute().dataExpr(), localVarTranslations, errorReporter) : new JsExpr("null", Integer.MAX_VALUE));
        if (callNode.numChildren() == 0) {
            return dataToPass;
        }
        StringBuilder paramsObjSb = new StringBuilder();
        paramsObjSb.append('{');
        boolean isFirst = true;
        for (CallParamNode child : callNode.getChildren()) {
            JsExpr valueJsExpr;
            if (isFirst) {
                isFirst = false;
            } else {
                paramsObjSb.append(", ");
            }
            String key = child.getKey();
            paramsObjSb.append(key).append(": ");
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                valueJsExpr = this.jsExprTranslator.translateToJsExpr(cpvn.getValueExprUnion(), localVarTranslations, errorReporter);
                paramsObjSb.append(valueJsExpr.getText());
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                valueJsExpr = JsExprUtils.concatJsExprsForceString(this.genJsExprsVisitorFactory.create(localVarTranslations, templateAliases, errorReporter).exec(cpcn));
            } else {
                String paramExpr = "param" + cpcn.getId();
                valueJsExpr = new JsExpr(paramExpr, Integer.MAX_VALUE);
            }
            valueJsExpr = this.maybeWrapContent(cpcn, valueJsExpr);
            paramsObjSb.append(valueJsExpr.getText());
        }
        paramsObjSb.append('}');
        if (callNode.dataAttribute().isPassingData()) {
            return new JsExpr("soy.$$augmentMap(" + dataToPass.getText() + ", " + paramsObjSb + ")", Integer.MAX_VALUE);
        }
        return new JsExpr(paramsObjSb.toString(), Integer.MAX_VALUE);
    }

    protected JsExpr maybeWrapContent(CallParamContentNode node, JsExpr valueJsExpr) {
        return JsExprUtils.maybeWrapAsSanitizedContentForInternalBlocks(node.getContentKind(), valueJsExpr);
    }
}

