/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.AugmentedParamStore;
import com.google.template.soy.data.internal.BasicParamStore;
import com.google.template.soy.jbcsrc.AutoValue_ConstructorRef;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.TypeInfo;
import com.google.template.soy.jbcsrc.api.AdvisingStringBuilder;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

abstract class ConstructorRef {
    static final ConstructorRef ARRAY_LIST_SIZE = ConstructorRef.create(ArrayList.class, Integer.TYPE);
    static final ConstructorRef LINKED_HASH_MAP_SIZE = ConstructorRef.create(LinkedHashMap.class, Integer.TYPE);
    static final ConstructorRef AUGMENTED_PARAM_STORE = ConstructorRef.create(AugmentedParamStore.class, SoyRecord.class, Integer.TYPE);
    static final ConstructorRef BASIC_PARAM_STORE = ConstructorRef.create(BasicParamStore.class, Integer.TYPE);
    static final ConstructorRef ADVISING_STRING_BUILDER = ConstructorRef.create(AdvisingStringBuilder.class, new Class[0]);

    ConstructorRef() {
    }

    static ConstructorRef create(TypeInfo type, Method init) {
        Preconditions.checkArgument((init.getName().equals("<init>") && init.getReturnType().equals((Object)Type.VOID_TYPE) ? 1 : 0) != 0, (String)"'%s' is not a valid constructor", (Object[])new Object[]{init});
        return new AutoValue_ConstructorRef(type, init, (ImmutableList<Type>)ImmutableList.copyOf((Object[])init.getArgumentTypes()));
    }

    static ConstructorRef create(TypeInfo type, Iterable<Type> argTypes) {
        return ConstructorRef.create(type, new Method("<init>", Type.VOID_TYPE, (Type[])Iterables.toArray(argTypes, Type.class)));
    }

    static ConstructorRef create(Class<?> clazz, Class<?> ... argTypes) {
        Constructor<?> c;
        TypeInfo type = TypeInfo.create(clazz);
        try {
            c = clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        Type constructorType = Type.getType(c);
        return new AutoValue_ConstructorRef(type, Method.getMethod(c), (ImmutableList<Type>)ImmutableList.copyOf((Object[])constructorType.getArgumentTypes()));
    }

    abstract TypeInfo instanceClass();

    abstract Method method();

    abstract ImmutableList<Type> argTypes();

    Expression construct(Expression ... args) {
        return this.construct(Arrays.asList(args));
    }

    Expression construct(final Iterable<? extends Expression> args) {
        Expression.checkTypes(this.argTypes(), args);
        return new Expression(this.instanceClass().type(), Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

            @Override
            void doGen(CodeBuilder mv) {
                mv.newInstance(ConstructorRef.this.instanceClass().type());
                mv.dup();
                for (Expression arg : args) {
                    arg.gen(mv);
                }
                mv.invokeConstructor(ConstructorRef.this.instanceClass().type(), ConstructorRef.this.method());
            }
        };
    }
}

