/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.html.passes.HtmlTransformVisitor;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomOutputOptimizers;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;

public class IncrementalDomSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SimplifyVisitor simplifyVisitor;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenIncrementalDomCodeVisitor> genIncrementalDomCodeVisitorProvider;

    @Inject
    public IncrementalDomSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SimplifyVisitor simplifyVisitor, Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider, Provider<GenIncrementalDomCodeVisitor> genIncrementalDomCodeVisitorProvider) {
        this.apiCallScope = apiCallScope;
        this.simplifyVisitor = simplifyVisitor;
        this.optimizeBidiCodeGenVisitorProvider = optimizeBidiCodeGenVisitorProvider;
        this.genIncrementalDomCodeVisitorProvider = genIncrementalDomCodeVisitorProvider;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry registry, SoyJsSrcOptions jsSrcOptions, ErrorReporter errorReporter) throws SoySyntaxException {
        Preconditions.checkState((!jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir() || jsSrcOptions.shouldProvideRequireSoyNamespaces() || jsSrcOptions.shouldProvideRequireJsFunctions() || jsSrcOptions.shouldGenerateGoogModules() ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without one of shouldProvideRequireSoyNamespaces, shouldProvideRequireJsFunctions or shouldGenerateGoogModules.");
        try (GuiceSimpleScope.WithScope withScope = this.apiCallScope.enter();){
            this.apiCallScope.seed(SoyJsSrcOptions.class, jsSrcOptions);
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(jsSrcOptions.getBidiGlobalDir(), jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, null, bidiGlobalDir);
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyTree);
            this.simplifyVisitor.simplify(soyTree, registry);
            new HtmlTransformVisitor(errorReporter).exec(soyTree);
            IncrementalDomOutputOptimizers.collapseOpenTags(soyTree);
            IncrementalDomOutputOptimizers.collapseElements(soyTree);
            List<String> list = ((GenIncrementalDomCodeVisitor)this.genIncrementalDomCodeVisitorProvider.get()).gen(soyTree, registry, errorReporter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, String outputPathFormat, ErrorReporter errorReporter) throws SoySyntaxException, IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, templateRegistry, jsSrcOptions, errorReporter);
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != jsFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), jsFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, "", (ImmutableList<SoyFileNode>)srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);){
                boolean isFirst = true;
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
        }
    }
}

