/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.html.passes;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.html.HtmlAttributeNode;
import com.google.template.soy.html.HtmlCloseTagNode;
import com.google.template.soy.html.HtmlOpenTagEndNode;
import com.google.template.soy.html.HtmlOpenTagStartNode;
import com.google.template.soy.html.HtmlPrintNode;
import com.google.template.soy.html.HtmlState;
import com.google.template.soy.html.HtmlTextNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class HtmlTransformVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind ENDING_STATE_MISMATCH = SoyErrorKind.of("Ending context of the content within a Soy tag must match the starting context. Transition was from {0} to {1}");
    private static final SoyErrorKind EXPECTED_ATTRIBUTE_VALUE = SoyErrorKind.of("Expected to find a quoted attribute value, but found \"{0}\".");
    private static final SoyErrorKind SOY_TAG_BEFORE_ATTR_VALUE = SoyErrorKind.of("Soy statements are not allowed before an attribute value. They should be moved inside a quotation mark.");
    private static final SoyErrorKind MISSING_TAG_NAME = SoyErrorKind.of("Found a tag with an empty tag name.");
    private static final SoyErrorKind NON_STRICT_FILE = SoyErrorKind.of("The incremental HTML Soy backend requires strict autoescape mode");
    private static final SoyErrorKind NON_STRICT_TEMPLATE = SoyErrorKind.of("The incremental HTML Soy backend requires strict autoescape mode for all templates.");
    private static final SoyErrorKind UNKNOWN_CONTENT_KIND = SoyErrorKind.of("The incremental HTML Soy backend requires all let statements and parameters with content to have a content kind");
    private HtmlState currentState = HtmlState.PCDATA;
    private String currentTag = "";
    private final StringBuilder currentText = new StringBuilder();
    private String currentAttributeName = "";
    private List<SoyNode.StandaloneNode> currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
    private IdGenerator idGen = null;
    private final ListMultimap<RawTextNode, SoyNode.StandaloneNode> transformMapping = ArrayListMultimap.create();
    private final Set<RawTextNode> visitedRawTextNodes = new HashSet<RawTextNode>();
    private boolean suppressExpectedAttributeValueError = false;
    private final ErrorReporter errorReporter;

    public HtmlTransformVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode node) {
        super.exec(node);
        this.applyTransforms();
        return null;
    }

    private void applyTransforms() {
        for (RawTextNode node : this.visitedRawTextNodes) {
            SoyNode.BlockNode parent = node.getParent();
            parent.addChildren(parent.getChildIndex(node), this.transformMapping.get((Object)node));
            parent.removeChild(node);
        }
    }

    private HtmlState getState() {
        return this.currentState;
    }

    private void setState(HtmlState state) {
        this.currentState = state;
    }

    private SourceLocation deriveSourceLocation(RawTextNode node) {
        return node.getSourceLocation();
    }

    private void createTextNode(RawTextNode node) {
        String currentString = this.consumeText();
        if (currentString.length() > 0) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.transformMapping.put((Object)node, (Object)new HtmlTextNode(this.idGen.genId(), currentString, sl));
        }
    }

    private void createAttributeValueNode(RawTextNode node) {
        String currentString = this.consumeText();
        if (currentString.length() > 0) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.currentAttributeValues.add(new RawTextNode(this.idGen.genId(), currentString, sl));
        }
    }

    private void createAttribute(RawTextNode node) {
        SourceLocation sl = this.deriveSourceLocation(node);
        HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(this.idGen.genId(), this.currentAttributeName, sl);
        htmlAttributeNode.addChildren(this.currentAttributeValues);
        this.transformMapping.put((Object)node, (Object)htmlAttributeNode);
        this.currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
    }

    private void handleHtmlPcData(RawTextNode node, char c) {
        if (c == '<') {
            this.createTextNode(node);
            this.setState(HtmlState.TAG_NAME);
        } else {
            this.currentText.append(c);
        }
    }

    private String consumeText() {
        String token = this.currentText.toString();
        this.currentText.setLength(0);
        return token;
    }

    private void handleHtmlTagName(RawTextNode node, char c) {
        if (CharMatcher.WHITESPACE.matches(c) || c == '>') {
            SourceLocation sl;
            this.currentTag = this.consumeText();
            if (this.currentTag.length() <= 0) {
                sl = this.deriveSourceLocation(node);
                this.errorReporter.report(sl, MISSING_TAG_NAME, new Object[0]);
            }
            if (!this.currentTag.startsWith("/")) {
                sl = this.deriveSourceLocation(node);
                this.transformMapping.put((Object)node, (Object)new HtmlOpenTagStartNode(this.idGen.genId(), this.currentTag, sl));
            }
            if (c == '>') {
                this.handleHtmlTag(node, c);
            } else {
                this.currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
                this.setState(HtmlState.TAG);
            }
        } else {
            this.currentText.append(c);
        }
    }

    private void handleHtmlTag(RawTextNode node, char c) {
        if (c == '>') {
            SourceLocation sl = this.deriveSourceLocation(node);
            if (this.currentTag.startsWith("/")) {
                this.transformMapping.put((Object)node, (Object)new HtmlCloseTagNode(this.idGen.genId(), this.currentTag.substring(1), sl));
            } else {
                this.transformMapping.put((Object)node, (Object)new HtmlOpenTagEndNode(this.idGen.genId(), this.currentTag, sl));
            }
            this.setState(HtmlState.PCDATA);
        } else if (!CharMatcher.WHITESPACE.matches(c)) {
            this.setState(HtmlState.ATTRIBUTE_NAME);
            this.currentText.append(c);
        }
    }

    private void handleHtmlAttributeName(RawTextNode node, char c) {
        if (c == '=') {
            this.currentAttributeName = this.consumeText();
            this.setState(HtmlState.BEFORE_ATTRIBUTE_VALUE);
            this.suppressExpectedAttributeValueError = false;
        } else if (c == '>') {
            this.currentAttributeName = this.consumeText();
            this.createAttribute(node);
            this.handleHtmlTag(node, c);
        } else if (CharMatcher.WHITESPACE.matches(c)) {
            this.currentAttributeName = this.consumeText();
            this.createAttribute(node);
            this.setState(HtmlState.TAG);
        } else {
            this.currentText.append(c);
        }
    }

    private void handleHtmlBeforeAttributeValue(RawTextNode node, char c) {
        if (c == '\"') {
            this.setState(HtmlState.ATTR_VALUE);
        } else if (!this.suppressExpectedAttributeValueError) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.errorReporter.report(sl, EXPECTED_ATTRIBUTE_VALUE, Character.valueOf(c));
            this.suppressExpectedAttributeValueError = true;
        }
        if (c == '>') {
            this.handleHtmlTag(node, c);
        } else if (CharMatcher.WHITESPACE.matches(c)) {
            this.setState(HtmlState.TAG);
        }
    }

    private void handleHtmlNormalAttrValue(RawTextNode node, char c) {
        if (c == '\"') {
            this.createAttributeValueNode(node);
            this.createAttribute(node);
            this.setState(HtmlState.TAG);
        } else {
            this.currentText.append(c);
        }
    }

    private void consumeCharacter(RawTextNode node, char c) {
        switch (this.getState()) {
            case PCDATA: {
                this.handleHtmlPcData(node, c);
                break;
            }
            case TAG_NAME: {
                this.handleHtmlTagName(node, c);
                break;
            }
            case TAG: {
                this.handleHtmlTag(node, c);
                break;
            }
            case ATTRIBUTE_NAME: {
                this.handleHtmlAttributeName(node, c);
                break;
            }
            case BEFORE_ATTRIBUTE_VALUE: {
                this.handleHtmlBeforeAttributeValue(node, c);
                break;
            }
            case ATTR_VALUE: {
                this.handleHtmlNormalAttrValue(node, c);
                break;
            }
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String content = node.getRawText();
        this.visitedRawTextNodes.add(node);
        for (int i = 0; i < content.length(); ++i) {
            this.consumeCharacter(node, content.charAt(i));
        }
        switch (this.getState()) {
            case TAG_NAME: {
                this.consumeCharacter(node, ' ');
                break;
            }
            case PCDATA: {
                this.createTextNode(node);
                break;
            }
            case ATTRIBUTE_NAME: {
                this.consumeCharacter(node, ' ');
                break;
            }
            case ATTR_VALUE: {
                this.createAttributeValueNode(node);
                break;
            }
        }
    }

    private void checkForValidSoyNodeLocation(SoyNode node) {
        switch (this.getState()) {
            case BEFORE_ATTRIBUTE_VALUE: {
                this.errorReporter.report(node.getSourceLocation(), SOY_TAG_BEFORE_ATTR_VALUE, new Object[0]);
                break;
            }
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.checkForValidSoyNodeLocation(node);
        switch (this.getState()) {
            case ATTR_VALUE: {
                this.currentAttributeValues.add(node);
                node.getParent().removeChild(node);
                break;
            }
            case TAG: {
                HtmlPrintNode htmlPrintNode = new HtmlPrintNode(this.idGen.genId(), node, HtmlPrintNode.Context.HTML_TAG, node.getSourceLocation());
                node.getParent().replaceChild(node, htmlPrintNode);
                break;
            }
            case PCDATA: {
                HtmlPrintNode htmlPrintNode = new HtmlPrintNode(this.idGen.genId(), node, HtmlPrintNode.Context.HTML_PCDATA, node.getSourceLocation());
                node.getParent().replaceChild(node, htmlPrintNode);
                break;
            }
        }
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node) {
        this.checkForValidSoyNodeLocation(node);
        if (node.getContentKind() == null) {
            this.errorReporter.report(node.getSourceLocation(), UNKNOWN_CONTENT_KIND, new Object[0]);
        } else if (node.getContentKind() == SanitizedContent.ContentKind.HTML) {
            this.visitSoyNode(node, true);
        } else if (node.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
            HtmlState startState = this.getState();
            this.setState(HtmlState.TAG);
            this.visitChildrenAllowingConcurrentModification(node);
            this.setState(startState);
        }
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitLetParamContentNode(node);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitLetParamContentNode(node);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getDefaultAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), NON_STRICT_FILE, new Object[0]);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.idGen = node.getNodeIdGenerator();
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        switch (node.getContentKind()) {
            case HTML: {
                this.currentState = HtmlState.PCDATA;
                break;
            }
            case ATTRIBUTES: {
                this.currentState = HtmlState.TAG;
                break;
            }
            default: {
                return;
            }
        }
        if (node.getAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), NON_STRICT_TEMPLATE, new Object[0]);
        }
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.checkForValidSoyNodeLocation(node);
        this.visitSoyNode(node);
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitSwitchCaseNode(SwitchCaseNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitLoopNode(SoyNode.LoopNode node) {
        this.visitSoyNode(node, true);
    }

    private void visitSoyNode(SoyNode node, boolean enforceState) {
        switch (this.getState()) {
            case BEFORE_ATTRIBUTE_VALUE: {
                this.errorReporter.report(node.getSourceLocation(), SOY_TAG_BEFORE_ATTR_VALUE, new Object[0]);
                break;
            }
            case ATTR_VALUE: {
                if (!(node instanceof SoyNode.StandaloneNode)) break;
                SoyNode.StandaloneNode standaloneNode = (SoyNode.StandaloneNode)node;
                standaloneNode.getParent().removeChild(standaloneNode);
                this.currentAttributeValues.add(standaloneNode);
                break;
            }
            case PCDATA: 
            case TAG: {
                if (!(node instanceof SoyNode.ParentSoyNode)) break;
                HtmlState startState = this.getState();
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
                HtmlState endState = this.getState();
                if (enforceState && startState != endState) {
                    this.errorReporter.report(node.getSourceLocation(), ENDING_STATE_MISMATCH, new Object[]{startState, endState});
                }
                this.consumeText();
                break;
            }
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.visitSoyNode(node, false);
    }
}

