/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import java.io.IOException;

public abstract class RenderableThunk {
    private String content;

    public final void render(Appendable appendable) throws IOException {
        if (this.content == null) {
            TeeAppendable teeAppendable = new TeeAppendable(appendable);
            this.doRender(teeAppendable);
            this.content = teeAppendable.buffer.toString();
        } else {
            appendable.append(this.content);
        }
    }

    protected abstract void doRender(Appendable var1) throws IOException;

    public final String renderAsString() {
        if (this.content != null) {
            return this.content;
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.render(sb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private static final class TeeAppendable
    implements Appendable {
        final StringBuilder buffer = new StringBuilder();
        final Appendable delegate;

        TeeAppendable(Appendable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            this.delegate.append(csq);
            this.buffer.append(csq);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            this.delegate.append(csq, start, end);
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public Appendable append(char c) throws IOException {
            this.delegate.append(c);
            this.buffer.append(c);
            return this;
        }
    }
}

