/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.AutoValue_SoyFileSetParser_ParseResult;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;

public final class SoyFileSetParser {
    private final SoyTypeRegistry typeRegistry;
    @Nullable
    private final SoyAstCache cache;
    private final ImmutableMap<String, ? extends SoyFileSupplier> soyFileSuppliers;
    @Nullable
    private final PassManager passManager;
    private final ErrorReporter errorReporter;

    public SoyFileSetParser(SoyTypeRegistry typeRegistry, @Nullable SoyAstCache astCache, ImmutableMap<String, ? extends SoyFileSupplier> soyFileSuppliers, @Nullable PassManager passManager, ErrorReporter errorReporter) {
        Preconditions.checkArgument((astCache == null || passManager != null ? 1 : 0) != 0, (Object)"AST caching is only allowed when all parsing and checking passes are enabled, to avoid caching inconsistent versions");
        this.typeRegistry = typeRegistry;
        this.cache = astCache;
        this.soyFileSuppliers = soyFileSuppliers;
        this.errorReporter = errorReporter;
        this.passManager = passManager;
    }

    public ParseResult parse() {
        try {
            return this.parseWithVersions();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parseWithVersions() throws IOException {
        Preconditions.checkState((this.cache == null || this.passManager != null ? 1 : 0) != 0, (Object)"AST caching is only allowed when all parsing and checking passes are enabled, to avoid caching inconsistent versions");
        IdGenerator nodeIdGen = this.cache != null ? this.cache.getNodeIdGenerator() : new IncrementingIdGenerator();
        SoyFileSetNode soyTree = new SoyFileSetNode(nodeIdGen.genId(), nodeIdGen);
        boolean filesWereSkipped = false;
        for (SoyFileSupplier fileSupplier : this.soyFileSuppliers.values()) {
            SoyFileNode node;
            SoyAstCache.VersionedFile cachedFile;
            SoyFileSupplier.Version version = fileSupplier.getVersion();
            SoyAstCache.VersionedFile versionedFile = cachedFile = this.cache != null ? this.cache.get(fileSupplier.getFilePath(), version) : null;
            if (cachedFile == null) {
                IdGenerator idGenerator = nodeIdGen;
                synchronized (idGenerator) {
                    node = this.parseSoyFileHelper(fileSupplier, nodeIdGen, this.typeRegistry);
                    if (node == null) {
                        filesWereSkipped = true;
                        continue;
                    }
                    if (this.passManager != null) {
                        this.passManager.runSingleFilePasses(node, nodeIdGen);
                    }
                }
                if (this.cache != null) {
                    this.cache.put(fileSupplier.getFilePath(), SoyAstCache.VersionedFile.of(node, version));
                }
            } else {
                node = cachedFile.file();
            }
            soyTree.addChild(node);
        }
        TemplateRegistry registry = new TemplateRegistry(soyTree, this.errorReporter);
        if (!filesWereSkipped && this.passManager != null) {
            this.passManager.runWholeFilesetPasses(registry, soyTree);
        }
        return ParseResult.create(soyTree, registry);
    }

    private SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen, SoyTypeRegistry typeRegistry) throws IOException {
        try (Reader soyFileReader = soyFileSupplier.open();){
            SoyFileNode soyFileNode = new SoyFileParser(typeRegistry, nodeIdGen, soyFileReader, soyFileSupplier.getSoyFileKind(), soyFileSupplier.getFilePath(), this.errorReporter).parseSoyFile();
            return soyFileNode;
        }
    }

    public static abstract class ParseResult {
        static ParseResult create(SoyFileSetNode soyTree, TemplateRegistry registry) {
            return new AutoValue_SoyFileSetParser_ParseResult(soyTree, registry);
        }

        public abstract SoyFileSetNode fileSet();

        public abstract TemplateRegistry registry();
    }
}

