/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.template.soy.types.ast.AutoValue_UnionTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import java.util.stream.Stream;

@AutoValue
public abstract class UnionTypeNode
extends TypeNode {
    public static UnionTypeNode create(Iterable<TypeNode> candidates) {
        ImmutableList candidateList = (ImmutableList)Streams.stream(candidates).flatMap(tn -> tn instanceof UnionTypeNode ? ((UnionTypeNode)tn).candidates().stream() : Stream.of(tn)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((candidateList.size() > 1 ? 1 : 0) != 0);
        return new AutoValue_UnionTypeNode(((TypeNode)candidateList.get(0)).sourceLocation().extend(((TypeNode)Iterables.getLast((Iterable)candidateList)).sourceLocation()), (ImmutableList<TypeNode>)candidateList);
    }

    UnionTypeNode() {
    }

    public abstract ImmutableList<TypeNode> candidates();

    @Override
    public final String toString() {
        return Joiner.on((String)"|").join(this.candidates());
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public UnionTypeNode copy() {
        ImmutableList.Builder newCandidates = ImmutableList.builder();
        for (TypeNode candidate : this.candidates()) {
            newCandidates.add((Object)candidate.copy());
        }
        UnionTypeNode copy = UnionTypeNode.create((Iterable<TypeNode>)newCandidates.build());
        copy.copyResolvedTypeFrom(this);
        return copy;
    }

    @Override
    public Stream<TypeNode> asStreamExpandingUnion() {
        return this.candidates().stream();
    }
}

