/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class TypeNode {
    @Nullable
    private SoyType resolvedType;

    TypeNode() {
    }

    public abstract SourceLocation sourceLocation();

    public abstract <T> T accept(TypeNodeVisitor<T> var1);

    public void setResolvedType(SoyType type) {
        Preconditions.checkState((this.resolvedType == null ? 1 : 0) != 0, (String)"type has already been set to %s", (Object)this.resolvedType);
        this.resolvedType = type;
    }

    public SoyType getResolvedType() {
        Preconditions.checkState((this.resolvedType != null ? 1 : 0) != 0, (String)"type hasn't been set yet on %s at %s", (Object)this.toString(), (Object)this.sourceLocation());
        return this.resolvedType;
    }

    public boolean isTypeResolved() {
        return this.resolvedType != null;
    }

    public abstract String toString();

    public abstract TypeNode copy();

    void copyResolvedTypeFrom(TypeNode old) {
        this.resolvedType = old.resolvedType;
    }

    public Stream<TypeNode> asStreamExpandingUnion() {
        return Stream.of(this);
    }
}

