/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.ast.AutoValue_TemplateTypeNode;
import com.google.template.soy.types.ast.AutoValue_TemplateTypeNode_Parameter;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

@AutoValue
public abstract class TemplateTypeNode
extends TypeNode {
    public static TemplateTypeNode create(SourceLocation sourceLocation, Iterable<Parameter> parameters, TypeNode returnType) {
        return new AutoValue_TemplateTypeNode(sourceLocation, (ImmutableList<Parameter>)ImmutableList.copyOf(parameters), returnType);
    }

    public abstract ImmutableList<Parameter> parameters();

    public abstract TypeNode returnType();

    @Override
    public final String toString() {
        return "(" + Joiner.on((String)", ").join(this.parameters()) + ") => " + String.valueOf(this.returnType());
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public TemplateTypeNode copy() {
        ImmutableList.Builder newParameters = ImmutableList.builder();
        for (Parameter parameter : this.parameters()) {
            newParameters.add((Object)parameter.copy());
        }
        TemplateTypeNode copy = TemplateTypeNode.create(this.sourceLocation(), (Iterable<Parameter>)newParameters.build(), this.returnType().copy());
        copy.copyResolvedTypeFrom(this);
        return copy;
    }

    @AutoValue
    public static abstract class Parameter {
        public static Parameter create(SourceLocation nameLocation, String name, String sourceName, TemplateType.ParameterKind kind, TypeNode type, boolean required) {
            return new AutoValue_TemplateTypeNode_Parameter(nameLocation, name, sourceName, kind, type, required);
        }

        public abstract SourceLocation nameLocation();

        public abstract String name();

        public abstract String sourceName();

        public abstract TemplateType.ParameterKind kind();

        public abstract TypeNode type();

        public abstract boolean required();

        public final String toString() {
            return this.sourceName() + (this.required() ? "" : "?") + ": " + String.valueOf(this.type());
        }

        Parameter copy() {
            return Parameter.create(this.nameLocation(), this.name(), this.sourceName(), this.kind(), this.type().copy(), this.required());
        }
    }
}

