/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.types.ast.AutoValue_FunctionTypeNode;
import com.google.template.soy.types.ast.AutoValue_FunctionTypeNode_Parameter;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

@AutoValue
public abstract class FunctionTypeNode
extends TypeNode {
    public static FunctionTypeNode create(SourceLocation sourceLocation, Iterable<Parameter> parameters, TypeNode returnType) {
        return new AutoValue_FunctionTypeNode(sourceLocation, (ImmutableList<Parameter>)ImmutableList.copyOf(parameters), returnType);
    }

    public abstract ImmutableList<Parameter> parameters();

    public abstract TypeNode returnType();

    @Override
    public final String toString() {
        if (this.parameters().size() < 3) {
            return "(" + Joiner.on((String)", ").join(this.parameters()) + ") => " + String.valueOf(this.returnType());
        }
        return "(\n  " + Joiner.on((String)",\n  ").join(this.parameters()) + "\n) => " + String.valueOf(this.returnType());
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public FunctionTypeNode copy() {
        ImmutableList.Builder newParameters = ImmutableList.builder();
        for (Parameter parameter : this.parameters()) {
            newParameters.add((Object)parameter.copy());
        }
        FunctionTypeNode copy = FunctionTypeNode.create(this.sourceLocation(), (Iterable<Parameter>)newParameters.build(), this.returnType().copy());
        copy.copyResolvedTypeFrom(this);
        return copy;
    }

    @AutoValue
    public static abstract class Parameter {
        public static Parameter create(SourceLocation nameLocation, String name, String sourceName, TypeNode type) {
            return new AutoValue_FunctionTypeNode_Parameter(nameLocation, name, sourceName, type);
        }

        public abstract SourceLocation nameLocation();

        public abstract String name();

        public abstract String sourceName();

        public abstract TypeNode type();

        public final String toString() {
            return this.sourceName() + ": " + String.valueOf(this.type());
        }

        Parameter copy() {
            return Parameter.create(this.nameLocation(), this.name(), this.sourceName(), this.type().copy());
        }
    }
}

