/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.treebuilder;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.treebuilder.AutoValue_ExprNodes_NamedExprNode;
import java.util.List;
import javax.annotation.Nullable;

public final class ExprNodes {
    public static ExprNode.OperatorNode ampAmp(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.AMP_AMP, left, right);
    }

    public static BooleanNode booleanLiteral(boolean value) {
        return new BooleanNode(value, SourceLocation.UNKNOWN);
    }

    public static ExprNode conditional(ExprNode condition, ExprNode left, ExprNode right) {
        if (condition instanceof BooleanNode) {
            return ((BooleanNode)condition).getValue() ? ExprNodes.maybeCopyNode(left) : ExprNodes.maybeCopyNode(right);
        }
        return ExprNodes.operator(Operator.CONDITIONAL, condition, left, right);
    }

    public static GlobalNode global(String fullEnumName) {
        return new GlobalNode(ExprNodes.identifier(fullEnumName));
    }

    public static ExprNode.OperatorNode equal(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.EQUAL, left, right);
    }

    public static FieldAccessNode fieldAccess(ExprNode base, String fieldName, boolean isNullSafe) {
        return new FieldAccessNode(ExprNodes.maybeCopyNode(base), fieldName, SourceLocation.UNKNOWN, isNullSafe);
    }

    public static FloatNode floatLiteral(double value) {
        return new FloatNode(value, SourceLocation.UNKNOWN);
    }

    public static FunctionNode function(String name, ExprNode ... params) {
        return ExprNodes.function(name, (ImmutableList<ExprNode>)ImmutableList.copyOf((Object[])params));
    }

    public static FunctionNode function(String name, ImmutableList<ExprNode> params) {
        FunctionNode node = FunctionNode.newPositional(ExprNodes.identifier(name), SourceLocation.UNKNOWN, null);
        node.addChildren((List<? extends ExprNode>)ExprNodes.maybeCopyNodes(params));
        return node;
    }

    public static FunctionNode elementCall(String name, ImmutableList<NamedExprNode> params) {
        ImmutableList.Builder paramNames = ImmutableList.builder();
        for (NamedExprNode param : params) {
            paramNames.add((Object)ExprNodes.identifier(param.name()));
        }
        FunctionNode node = FunctionNode.newNamed(ExprNodes.identifier(name), (Iterable<Identifier>)paramNames.build(), SourceLocation.UNKNOWN);
        for (NamedExprNode child : params) {
            node.addChild(ExprNodes.maybeCopyNode(child.expr()));
        }
        return node;
    }

    public static ExprNode.OperatorNode greaterThan(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.GREATER_THAN, left, right);
    }

    public static GroupNode group(ExprNode expr) {
        return new GroupNode(ExprNodes.maybeCopyNode(expr), SourceLocation.UNKNOWN);
    }

    public static IntegerNode integerLiteral(long value) {
        return new IntegerNode(value, SourceLocation.UNKNOWN);
    }

    public static ItemAccessNode itemAccess(ExprNode base, ExprNode key, boolean isNullSafe) {
        return new ItemAccessNode(ExprNodes.maybeCopyNode(base), ExprNodes.maybeCopyNode(key), SourceLocation.UNKNOWN, isNullSafe);
    }

    public static ListComprehensionNode listComprehension(ExprNode base, String listItemVarName, @Nullable String indexVarName, ExprNode mapExpression, @Nullable ExprNode filterExpression) {
        return new ListComprehensionNode(ExprNodes.maybeCopyNode(base), "$" + listItemVarName, SourceLocation.UNKNOWN, indexVarName == null ? null : "$" + indexVarName, SourceLocation.UNKNOWN, ExprNodes.maybeCopyNode(mapExpression), filterExpression == null ? null : ExprNodes.maybeCopyNode(filterExpression), SourceLocation.UNKNOWN, 0);
    }

    public static ListLiteralNode listLiteral(ExprNode ... items) {
        return ExprNodes.listLiteral((ImmutableList<ExprNode>)ImmutableList.copyOf((Object[])items));
    }

    public static ListLiteralNode listLiteral(ImmutableList<ExprNode> items) {
        return new ListLiteralNode((List<ExprNode>)ExprNodes.maybeCopyNodes(items), SourceLocation.UNKNOWN);
    }

    public static MethodCallNode methodCall(ExprNode base, String methodName, boolean isNullSafe, ExprNode ... params) {
        return MethodCallNode.newWithPositionalArgs(ExprNodes.maybeCopyNode(base), (List<ExprNode>)ImmutableList.copyOf((Object[])ExprNodes.maybeCopyNodes(params)), ExprNodes.identifier(methodName), SourceLocation.UNKNOWN, isNullSafe);
    }

    public static ExprNode.OperatorNode nonNullAssertion(ExprNode operand) {
        return ExprNodes.operator(Operator.ASSERT_NON_NULL, operand);
    }

    public static ExprNode.OperatorNode notEqual(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.NOT_EQUAL, left, right);
    }

    public static ExprNode.OperatorNode not(ExprNode operand) {
        return ExprNodes.operator(Operator.NOT, operand);
    }

    public static NullNode nullLiteral() {
        return new NullNode(SourceLocation.UNKNOWN);
    }

    public static ExprNode.OperatorNode nullCoalescing(ExprNode base, ExprNode ifNull) {
        return ExprNodes.operator(Operator.NULL_COALESCING, base, ifNull);
    }

    public static ExprNode.OperatorNode operator(Operator op, ImmutableList<ExprNode> children) {
        return ExprNodes.operator(op, (ExprNode[])children.toArray((Object[])new ExprNode[0]));
    }

    public static ExprNode.OperatorNode operator(Operator op, ExprNode ... children) {
        return op.createNode(SourceLocation.UNKNOWN, SourceLocation.UNKNOWN, ExprNodes.maybeCopyNodes(children));
    }

    public static ExprNode.OperatorNode barBar(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.BAR_BAR, left, right);
    }

    public static ExprNode.OperatorNode plus(ExprNode left, ExprNode right) {
        return ExprNodes.operator(Operator.PLUS, left, right);
    }

    public static FunctionNode protoInit(String protoName, ImmutableList<NamedExprNode> children) {
        FunctionNode node = FunctionNode.newNamed(ExprNodes.identifier(protoName), (Iterable)children.stream().map(namedExprNode -> ExprNodes.identifier(namedExprNode.name())).collect(ImmutableList.toImmutableList()), SourceLocation.UNKNOWN);
        node.setSoyFunction(BuiltinFunction.PROTO_INIT);
        for (NamedExprNode child : children) {
            node.addChild(ExprNodes.maybeCopyNode(child.expr()));
        }
        return node;
    }

    public static boolean isProtoInit(ExprNode node, String protoName) {
        if (!(node instanceof FunctionNode)) {
            return false;
        }
        FunctionNode functionNode = (FunctionNode)node;
        if (!functionNode.isResolved() || functionNode.getSoyFunction() != BuiltinFunction.PROTO_INIT) {
            return false;
        }
        return functionNode.getFunctionName().equals(protoName);
    }

    public static RecordLiteralNode recordLiteral(NamedExprNode ... children) {
        return ExprNodes.recordLiteral((ImmutableList<NamedExprNode>)ImmutableList.copyOf((Object[])children));
    }

    public static RecordLiteralNode recordLiteral(ImmutableList<NamedExprNode> children) {
        RecordLiteralNode node = new RecordLiteralNode(ExprNodes.identifier("record"), (Iterable)children.stream().map(namedExprNode -> ExprNodes.identifier(namedExprNode.name())).collect(ImmutableList.toImmutableList()), SourceLocation.UNKNOWN);
        for (NamedExprNode child : children) {
            node.addChild(ExprNodes.maybeCopyNode(child.expr()));
        }
        return node;
    }

    public static StringNode stringLiteral(String value) {
        return new StringNode(value, QuoteStyle.SINGLE, SourceLocation.UNKNOWN);
    }

    public static TemplateLiteralNode templateLiteral(String templateName) {
        if (templateName.startsWith(".")) {
            templateName = templateName.substring(1);
        }
        return TemplateLiteralNode.forVarRef(new VarRefNode(templateName, SourceLocation.UNKNOWN, null));
    }

    public static VarRefNode varRef(String name) {
        return new VarRefNode("$" + name, SourceLocation.UNKNOWN, null);
    }

    public static Identifier identifier(String identifier) {
        return Identifier.create(identifier, SourceLocation.UNKNOWN);
    }

    private static ImmutableList<ExprNode> maybeCopyNodes(ImmutableList<ExprNode> nodes) {
        return (ImmutableList)nodes.stream().map(ExprNodes::maybeCopyNode).collect(ImmutableList.toImmutableList());
    }

    private static ExprNode[] maybeCopyNodes(ExprNode ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = ExprNodes.maybeCopyNode(nodes[i]);
        }
        return nodes;
    }

    private static ExprNode maybeCopyNode(ExprNode node) {
        if (node.getParent() != null) {
            return node.copy(new CopyState());
        }
        return node;
    }

    private ExprNodes() {
    }

    @AutoValue
    public static abstract class NamedExprNode {
        public abstract String name();

        public abstract ExprNode expr();

        public static NamedExprNode create(String name, ExprNode expr) {
            return new AutoValue_ExprNodes_NamedExprNode(name, expr);
        }
    }
}

