/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Converter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ConstantP;
import com.google.template.soy.soytree.DataAllCallSituationP;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ExternP;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.FunctionTypeP;
import com.google.template.soy.soytree.ParameterP;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileP;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateKindP;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateMetadataP;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.VisibilityP;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.MessageType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UndefinedType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;

public final class TemplateMetadataSerializer {
    private static final SoyErrorKind UNABLE_TO_PARSE_TEMPLATE_HEADER = SoyErrorKind.of("Unable to parse template header for {0} from Soy file {1}: {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNABLE_TO_FIND_TYPE = SoyErrorKind.of("Unable to find {0}: {1} referenced by dependency.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TYPE = SoyErrorKind.of("Expected {0} to be a {1} but it was a {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final Converter<VisibilityP, Visibility> VISIBILITY_CONVERTER = TemplateMetadataSerializer.createEnumConverter(VisibilityP.class, Visibility.class);
    private static final Converter<TemplateKindP, TemplateType.TemplateKind> TEMPLATE_KIND_CONVERTER = TemplateMetadataSerializer.createEnumConverter(TemplateKindP.class, TemplateType.TemplateKind.class);

    private TemplateMetadataSerializer() {
    }

    public static CompilationUnit compilationUnitFromFileSet(SoyFileSetNode fileSet, FileSetMetadata registry) {
        CompilationUnit.Builder builder = CompilationUnit.newBuilder();
        for (SoyFileNode file : fileSet.getChildren()) {
            SoyFileP.Builder fileBuilder = SoyFileP.newBuilder().setNamespace(file.getNamespace()).setModName(Strings.nullToEmpty((String)file.getModName())).setFilePath(file.getFilePath().path()).setFileRoot(file.getFilePath().getRoot());
            file.getConstants().stream().filter(ConstNode::isExported).forEach(c -> fileBuilder.addConstants(TemplateMetadataSerializer.protoFromConstant(c)));
            file.getExterns().stream().filter(ExternNode::isExported).forEach(e -> fileBuilder.addExterns(TemplateMetadataSerializer.protoFromExtern(e)));
            for (TemplateNode template : file.getTemplates()) {
                TemplateMetadata meta = registry.getTemplate(template);
                fileBuilder.addTemplate(TemplateMetadataSerializer.protoFromTemplate(meta, file));
            }
            builder.addFile(fileBuilder.build());
        }
        return builder.build();
    }

    @VisibleForTesting
    public static ImmutableList<TemplateMetadata> templatesFromSoyFileP(SoyFileP fileProto, SoyFileKind fileKind, SoyTypeRegistry typeRegistry, SourceFilePath headerFilePath, ErrorReporter errorReporter) {
        ImmutableList.Builder templates = ImmutableList.builder();
        for (TemplateMetadataP templateProto : fileProto.getTemplateList()) {
            try {
                templates.add((Object)TemplateMetadataSerializer.metadataFromProto(fileProto, templateProto, fileKind, typeRegistry, headerFilePath, errorReporter));
            }
            catch (IllegalArgumentException iae) {
                errorReporter.report(new SourceLocation(headerFilePath), UNABLE_TO_PARSE_TEMPLATE_HEADER, templateProto.getTemplateName(), SourceFilePath.getRealPath(fileProto), iae.getMessage());
            }
        }
        return templates.build();
    }

    private static ConstantP protoFromConstant(ConstNode node) {
        return ConstantP.newBuilder().setName(node.getVar().name()).setType(node.getVar().type().toProto()).build();
    }

    private static ExternP protoFromExtern(ExternNode node) {
        return ExternP.newBuilder().setName(node.getIdentifier().identifier()).setSignature(node.getType().toProto().getFunction()).build();
    }

    private static TemplateMetadataP protoFromTemplate(TemplateMetadata meta, SoyFileNode fileNode) {
        TemplateType templateType = meta.getTemplateType();
        TemplateMetadataP.Builder builder = TemplateMetadataP.newBuilder().setTemplateName(templateType.getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE ? meta.getDelTemplateName() : TemplateMetadataSerializer.maybeShortenTemplateName(fileNode.getNamespace(), meta.getTemplateName())).setModifiableTemplateName(Strings.nullToEmpty((String)meta.getDelTemplateName())).setTemplateKind((TemplateKindP)((Object)TEMPLATE_KIND_CONVERTER.reverse().convert((Object)templateType.getTemplateKind()))).setVisibility((VisibilityP)((Object)VISIBILITY_CONVERTER.reverse().convert((Object)meta.getVisibility()))).setTemplateType(templateType.toProto().getTemplate()).setDelTemplateVariant(Strings.nullToEmpty((String)meta.getDelTemplateVariant())).setStrictHtml(templateType.isStrictHtml()).setComponent(meta.getComponent()).addAllDataAllCallSituation((Iterable<? extends DataAllCallSituationP>)TemplateMetadataSerializer.protosFromCallSitatuations(templateType.getDataAllCallSituations(), fileNode));
        if (meta.getHtmlElement() != null && meta.getSoyElement() != null) {
            builder = builder.setHtmlElement(meta.getHtmlElement()).setSoyElement(meta.getSoyElement());
        }
        return builder.build();
    }

    static TemplateMetadata metadataFromProto(SoyFileP fileProto, TemplateMetadataP templateProto, SoyFileKind fileKind, SoyTypeRegistry typeRegistry, SourceFilePath filePath, ErrorReporter errorReporter) {
        String templateName;
        TemplateMetadata.Builder builder = TemplateMetadata.builder();
        TemplateType.TemplateKind templateKind = (TemplateType.TemplateKind)((Object)TEMPLATE_KIND_CONVERTER.convert((Object)templateProto.getTemplateKind()));
        String modName = Strings.emptyToNull((String)fileProto.getModName());
        String variant = templateProto.getDelTemplateVariant();
        switch (templateKind) {
            case ELEMENT: 
            case BASIC: {
                templateName = TemplateNodeBuilder.combineNsAndName(fileProto.getNamespace(), templateProto.getTemplateName());
                if (!templateProto.getTemplateType().getIsModifiable() && !templateProto.getTemplateType().getIsModifying()) break;
                builder.setDelTemplateVariant(variant).setDelTemplateName(templateProto.getModifiableTemplateName());
                break;
            }
            case DELTEMPLATE: {
                String delTemplateName = templateProto.getTemplateName();
                templateName = TemplateNodeBuilder.combineNsAndName(fileProto.getNamespace(), TemplateDelegateNodeBuilder.partialDeltemplateTemplateName(delTemplateName, modName, variant));
                builder.setDelTemplateVariant(variant).setDelTemplateName(delTemplateName);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        SoyTypeP returnTypeP = templateProto.getTemplateType().getReturnType();
        SoyType returnType = TemplateMetadataSerializer.fromProto(returnTypeP, typeRegistry, filePath, errorReporter);
        TemplateContentKind.ElementContentKind templateContentKind = returnTypeP.getHtml().getIsElement() ? TemplateContentKind.ElementContentKind.valueOf(returnTypeP.getHtml().getTagName()) : TemplateContentKind.fromSanitizedContentKind(returnType instanceof StringType ? SanitizedContentKind.TEXT : ((SanitizedType)returnType).getContentKind());
        return builder.setTemplateName(templateName).setSoyFileKind(fileKind).setModName(modName).setHtmlElement(templateProto.getHtmlElement()).setSoyElement(templateProto.getSoyElement()).setTemplateType(TemplateType.builder().setTemplateKind(templateKind).setContentKind(templateContentKind).setStrictHtml(templateProto.getStrictHtml()).setAllowExtraAttributes(returnTypeP.getHtml().getAllowExtraAttributes()).setReservedAttributes((ImmutableSet<String>)ImmutableSet.copyOf((Collection)returnTypeP.getHtml().getReservedAttributesList())).setDataAllCallSituations(TemplateMetadataSerializer.callSituationsFromProto(templateProto.getDataAllCallSituationList(), fileProto)).setParameters(TemplateMetadataSerializer.parametersFromProto(templateProto.getTemplateType().getParameterList(), typeRegistry, filePath, errorReporter)).setIdentifierForDebugging(templateName).setUseVariantType(TemplateMetadataSerializer.fromProto(templateProto.getTemplateType().getUseVariantType(), typeRegistry, filePath, errorReporter)).setModifiable(templateProto.getTemplateType().getIsModifiable()).setModifying(templateProto.getTemplateType().getIsModifying()).setLegacyDeltemplateNamespace(templateProto.getTemplateType().getLegacyDeltemplateNamespace()).build()).setSourceLocation(new SourceLocation(SourceFilePath.create(fileProto))).setVisibility((Visibility)((Object)VISIBILITY_CONVERTER.convert((Object)templateProto.getVisibility()))).setComponent(templateProto.getComponent()).build();
    }

    private static ImmutableList<TemplateType.Parameter> parametersFromProto(List<ParameterP> parameterList, SoyTypeRegistry typeRegistry, SourceFilePath filePath, ErrorReporter errorReporter) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)parameterList.size());
        for (ParameterP parameter : parameterList) {
            builder.add((Object)TemplateType.Parameter.builder().setName(parameter.getName()).setKind(TemplateType.ParameterKind.fromProto(parameter.getKind())).setRequired(parameter.getRequired()).setImplicit(parameter.getImplicit()).setTypeLazily(new SoyTypeSupplier(parameter.getType(), typeRegistry, filePath, errorReporter)).build());
        }
        return builder.build();
    }

    static SoyType fromProto(SoyTypeP proto, SoyTypeRegistry typeRegistry, SourceFilePath filePath, ErrorReporter errorReporter) {
        switch (proto.getTypeKindCase()) {
            case PRIMITIVE: {
                switch (proto.getPrimitive()) {
                    case ANY: {
                        return AnyType.getInstance();
                    }
                    case UNKNOWN: {
                        return UnknownType.getInstance();
                    }
                    case INT: {
                        return IntType.getInstance();
                    }
                    case NULL: {
                        return NullType.getInstance();
                    }
                    case UNDEFINED: {
                        return UndefinedType.getInstance();
                    }
                    case BOOL: {
                        return BoolType.getInstance();
                    }
                    case FLOAT: {
                        return FloatType.getInstance();
                    }
                    case STRING: {
                        return StringType.getInstance();
                    }
                    case ATTRIBUTES: {
                        return SanitizedType.AttributesType.getInstance();
                    }
                    case JS: {
                        return SanitizedType.JsType.getInstance();
                    }
                    case CSS: {
                        return SanitizedType.StyleType.getInstance();
                    }
                    case URI: {
                        return SanitizedType.UriType.getInstance();
                    }
                    case TRUSTED_RESOURCE_URI: {
                        return SanitizedType.TrustedResourceUriType.getInstance();
                    }
                    case VE_DATA: {
                        return VeDataType.getInstance();
                    }
                }
                throw new AssertionError((Object)("Unknown primitive: " + String.valueOf((Object)proto.getPrimitive())));
            }
            case HTML: {
                if (proto.getHtml().getIsElement()) {
                    return typeRegistry.getOrCreateElementType(proto.getHtml().getTagName());
                }
                return SanitizedType.HtmlType.getInstance();
            }
            case LIST_ELEMENT: {
                return typeRegistry.getOrCreateListType(TemplateMetadataSerializer.fromProto(proto.getListElement(), typeRegistry, filePath, errorReporter));
            }
            case LEGACY_OBJECT_MAP: {
                return typeRegistry.getOrCreateLegacyObjectMapType(TemplateMetadataSerializer.fromProto(proto.getLegacyObjectMap().getKey(), typeRegistry, filePath, errorReporter), TemplateMetadataSerializer.fromProto(proto.getLegacyObjectMap().getValue(), typeRegistry, filePath, errorReporter));
            }
            case MAP: {
                return typeRegistry.getOrCreateMapType(TemplateMetadataSerializer.fromProto(proto.getMap().getKey(), typeRegistry, filePath, errorReporter), TemplateMetadataSerializer.fromProto(proto.getMap().getValue(), typeRegistry, filePath, errorReporter));
            }
            case MESSAGE: {
                return MessageType.getInstance();
            }
            case PROTO: {
                SoyType type = typeRegistry.getProtoRegistry().getProtoType(proto.getProto());
                if (type == null) {
                    errorReporter.report(new SourceLocation(filePath), UNABLE_TO_FIND_TYPE, "proto", proto.getProto());
                    return UnknownType.getInstance();
                }
                if (type instanceof SoyProtoType) {
                    return type;
                }
                errorReporter.report(new SourceLocation(filePath), UNEXPECTED_TYPE, new Object[]{proto.getProto(), "proto", type.getKind()});
                return UnknownType.getInstance();
            }
            case PROTO_ENUM: {
                SoyType type = typeRegistry.getProtoRegistry().getProtoType(proto.getProtoEnum());
                if (type == null) {
                    errorReporter.report(new SourceLocation(filePath), UNABLE_TO_FIND_TYPE, "proto enum", proto.getProtoEnum());
                    return UnknownType.getInstance();
                }
                if (type instanceof SoyProtoEnumType) {
                    return type;
                }
                errorReporter.report(new SourceLocation(filePath), UNEXPECTED_TYPE, new Object[]{proto.getProtoEnum(), "proto enum", type.getKind()});
                return UnknownType.getInstance();
            }
            case RECORD: {
                ArrayList<RecordType.Member> members = new ArrayList<RecordType.Member>();
                for (SoyTypeP.RecordMemberP member : proto.getRecord().getMembersList()) {
                    members.add(RecordType.memberOf(member.getName(), member.getOptional(), TemplateMetadataSerializer.fromProto(member.getType(), typeRegistry, filePath, errorReporter)));
                }
                return typeRegistry.getOrCreateRecordType(members);
            }
            case TEMPLATE: {
                ArrayList<TemplateType.Parameter> parameters = new ArrayList<TemplateType.Parameter>();
                for (ParameterP parameter : proto.getTemplate().getParameterList()) {
                    parameters.add(TemplateType.Parameter.builder().setName(parameter.getName()).setKind(TemplateType.ParameterKind.fromProto(parameter.getKind())).setType(TemplateMetadataSerializer.fromProto(parameter.getType(), typeRegistry, filePath, errorReporter)).setRequired(parameter.getRequired()).setImplicit(parameter.getImplicit()).build());
                }
                return typeRegistry.internTemplateType(TemplateType.declaredTypeOf(parameters, TemplateMetadataSerializer.fromProto(proto.getTemplate().getReturnType(), typeRegistry, filePath, errorReporter), TemplateMetadataSerializer.fromProto(proto.getTemplate().getUseVariantType(), typeRegistry, filePath, errorReporter), proto.getTemplate().getIsModifiable(), proto.getTemplate().getIsModifying(), proto.getTemplate().getLegacyDeltemplateNamespace()));
            }
            case FUNCTION: {
                ArrayList<FunctionType.Parameter> parameters = new ArrayList<FunctionType.Parameter>();
                for (FunctionTypeP.Parameter parameter : proto.getFunction().getParametersList()) {
                    parameters.add(FunctionType.Parameter.of(parameter.getName(), TemplateMetadataSerializer.fromProto(parameter.getType(), typeRegistry, filePath, errorReporter)));
                }
                return typeRegistry.intern(FunctionType.of(parameters, TemplateMetadataSerializer.fromProto(proto.getFunction().getReturnType(), typeRegistry, filePath, errorReporter)));
            }
            case UNION: {
                ArrayList<SoyType> members = new ArrayList<SoyType>(proto.getUnion().getMemberCount());
                for (SoyTypeP member : proto.getUnion().getMemberList()) {
                    members.add(TemplateMetadataSerializer.fromProto(member, typeRegistry, filePath, errorReporter));
                }
                return typeRegistry.getOrCreateUnionType(members);
            }
            case VE: {
                return typeRegistry.getOrCreateVeType(proto.getVe());
            }
        }
        throw new AssertionError((Object)("unhandled typeKind: " + String.valueOf((Object)proto.getTypeKindCase())));
    }

    private static ImmutableList<TemplateType.DataAllCallSituation> callSituationsFromProto(List<DataAllCallSituationP> callSituationList, SoyFileP fileProto) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)callSituationList.size());
        for (DataAllCallSituationP call : callSituationList) {
            Object templateName = call.getTemplateName();
            if (((String)templateName).startsWith(".")) {
                templateName = fileProto.getNamespace() + (String)templateName;
            }
            builder.add((Object)TemplateType.DataAllCallSituation.builder().setTemplateName((String)templateName).setDelCall(call.getDelCall()).setExplicitlyPassedParameters((ImmutableSet<String>)ImmutableSet.copyOf((Collection)call.getExplicitlyPassedParametersList())).build());
        }
        return builder.build();
    }

    private static ImmutableList<DataAllCallSituationP> protosFromCallSitatuations(ImmutableList<TemplateType.DataAllCallSituation> callSituationList, SoyFileNode fileNode) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)callSituationList.size());
        for (TemplateType.DataAllCallSituation call : callSituationList) {
            builder.add((Object)DataAllCallSituationP.newBuilder().setTemplateName(call.isDelCall() ? call.getTemplateName() : TemplateMetadataSerializer.maybeShortenTemplateName(fileNode.getNamespace(), call.getTemplateName())).setDelCall(call.isDelCall()).addAllExplicitlyPassedParameters((Iterable<String>)call.getExplicitlyPassedParameters()).build());
        }
        return builder.build();
    }

    private static String maybeShortenTemplateName(String namespace, String templateName) {
        if (templateName.startsWith(namespace) && templateName.indexOf(46, namespace.length() + 2) == -1) {
            return templateName.substring(namespace.length());
        }
        return templateName;
    }

    private static <T1 extends Enum<T1>, T2 extends Enum<T2>> Converter<T1, T2> createEnumConverter(final Class<T1> t1, final Class<T2> t2) {
        HashMap<String, Enum> t1NameMap = new HashMap<String, Enum>();
        for (Enum instance : (Enum[])t1.getEnumConstants()) {
            t1NameMap.put(instance.name(), instance);
        }
        final EnumMap<T1, Enum> forwardMap = new EnumMap<T1, Enum>(t1);
        final EnumMap<T2, Enum> backwardMap = new EnumMap<T2, Enum>(t2);
        for (Enum t2Instance : (Enum[])t2.getEnumConstants()) {
            Enum t1Instance = (Enum)t1NameMap.remove(t2Instance.name());
            if (t1Instance == null) continue;
            forwardMap.put(t1Instance, t2Instance);
            backwardMap.put(t2Instance, t1Instance);
        }
        return new Converter<T1, T2>(){

            protected T2 doForward(T1 a) {
                Enum r = (Enum)forwardMap.get(a);
                if (r == null) {
                    throw new IllegalArgumentException("Failed to map: " + String.valueOf(a) + " to an instance of " + String.valueOf(t2));
                }
                return r;
            }

            protected T1 doBackward(T2 b) {
                Enum r = (Enum)backwardMap.get(b);
                if (r == null) {
                    throw new IllegalArgumentException("Failed to map: " + String.valueOf(b) + " to an instance of " + String.valueOf(t1));
                }
                return r;
            }
        };
    }

    private static final class SoyTypeSupplier
    implements Supplier<SoyType> {
        final SoyTypeP typeProto;
        final SoyTypeRegistry typeRegistry;
        final SourceFilePath filePath;
        final ErrorReporter errorReporter;

        SoyTypeSupplier(SoyTypeP type, SoyTypeRegistry typeRegistry, SourceFilePath filePath, ErrorReporter errorReporter) {
            this.typeProto = type;
            this.typeRegistry = typeRegistry;
            this.filePath = filePath;
            this.errorReporter = errorReporter;
        }

        @Override
        public SoyType get() {
            return TemplateMetadataSerializer.fromProto(this.typeProto, this.typeRegistry, this.filePath, this.errorReporter);
        }
    }
}

