/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.MsgSubstUnitPlaceholderNameUtils;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public final class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS = SoyErrorKind.of("The ''offset'' for plural must be a positive integer.", new SoyErrorKind.StyleAllowance[0]);
    public static final String FALLBACK_BASE_PLURAL_VAR_NAME = "NUM";
    private final SourceLocation openTagLocation;
    private final List<CommandTagAttribute> attributes;
    private final int offset;
    private final ExprRootNode pluralExpr;
    private final MessagePlaceholder placeholder;

    private MsgPluralNode(int id, SourceLocation location, SourceLocation openTagLocation, ExprRootNode pluralExpr, List<CommandTagAttribute> attributes, int offset, MessagePlaceholder placeholder) {
        super(id, location, "plural");
        this.openTagLocation = openTagLocation;
        this.pluralExpr = pluralExpr;
        this.attributes = ImmutableList.copyOf(attributes);
        this.offset = offset;
        this.placeholder = placeholder;
    }

    private MsgPluralNode(MsgPluralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.openTagLocation = orig.openTagLocation;
        this.pluralExpr = orig.pluralExpr.copy(copyState);
        this.attributes = (List)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        this.offset = orig.offset;
        this.placeholder = orig.placeholder;
        copyState.updateRefs(orig, this);
    }

    public static MsgPluralNode fromPluralExpr(int id, SourceLocation location, SourceLocation openTagLocation, ExprNode expr, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        int offset = 0;
        SourceLocation phNameLocation = null;
        String phName = null;
        block8: for (CommandTagAttribute attribute : attributes) {
            switch (attribute.getName().identifier()) {
                case "offset": {
                    OptionalInt optionalOffset = attribute.valueAsOptionalInt(errorReporter);
                    if (!optionalOffset.isPresent() || (offset = optionalOffset.getAsInt()) > 0) continue block8;
                    errorReporter.report(attribute.getValueLocation(), PLURAL_OFFSET_OUT_OF_BOUNDS, new Object[0]);
                    offset = 0;
                    continue block8;
                }
                case "phname": {
                    phNameLocation = attribute.getValueLocation();
                    phName = MessagePlaceholder.validatePlaceholderName(attribute.getValue(), phNameLocation, errorReporter);
                    continue block8;
                }
            }
            errorReporter.report(attribute.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attribute.getName().identifier(), "plural", ImmutableSet.of((Object)"offset", (Object)"phname"));
        }
        return new MsgPluralNode(id, location, openTagLocation, new ExprRootNode(expr), attributes, offset, phName == null ? MessagePlaceholder.create(MsgSubstUnitPlaceholderNameUtils.genNaiveBaseNameForExpr(expr, FALLBACK_BASE_PLURAL_VAR_NAME)) : MessagePlaceholder.createWithUserSuppliedName(phName, phNameLocation));
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public ExprRootNode getExpr() {
        return this.pluralExpr;
    }

    @Override
    public MessagePlaceholder getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other, ExprEquivalence exprEquivalence) {
        if (!(other instanceof MsgPluralNode)) {
            return false;
        }
        MsgPluralNode that = (MsgPluralNode)other;
        return exprEquivalence.equivalent(this.pluralExpr, that.pluralExpr) && this.offset == that.offset && Objects.equals(this.placeholder.name(), that.placeholder.name());
    }

    @Override
    public String getCommandText() {
        StringBuilder builder = new StringBuilder(this.pluralExpr.toSourceString());
        if (this.offset > 0) {
            builder.append(" offset=\"").append(this.offset).append("\"");
        }
        this.placeholder.userSuppliedName().ifPresent(phname -> builder.append(" phname=\"").append((String)phname).append("\""));
        return builder.toString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.pluralExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode copy(CopyState copyState) {
        return new MsgPluralNode(this, copyState);
    }
}

