/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_MsgNode_RepresentativeNodes;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MessagePlaceholder;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MsgNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.MsgBlockNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final SoyErrorKind WRONG_NUMBER_OF_GENDER_EXPRS = SoyErrorKind.of("Attribute ''genders'' should contain 1-3 expressions.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BASE_NAME_COLLISION_SINGLE = SoyErrorKind.of("Placeholder ''{0}'' collision with element at {1}, please collapse them into a single Soy variable, or change `phname` of at last one to avoid conflict (go/soy-msg#msg).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BASE_NAME_COLLISION_MULTIPLE = SoyErrorKind.of("Placeholder ''{0}'' collision with element at {1}, please collapse them into a single Soy variable, or change `phname`  of at last one to avoid conflict, ditto for these {2} (go/soy-msg#msg).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_PLACEHOLDER_EXAMPLES = SoyErrorKind.of("The example set on this placeholder is incompatible with other examples for the same placeholder. If a placeholder occurs multiple times in a msg, then all examples must be the same.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    @Nullable
    private ImmutableList<ExprRootNode> genderExprs;
    @Nullable
    private final String meaning;
    private final String desc;
    private final List<CommandTagAttribute> attributes;
    private final SourceLocation openTagLocation;
    @Nullable
    private final String genderExprsString;
    @Nullable
    private SubstUnitInfo substUnitInfo = null;
    @Nullable
    private EscapingMode escapingMode = null;
    private final Optional<CommandTagAttribute> alternateIdAttribute;
    private final OptionalLong alternateId;

    public MsgNode(int id, SourceLocation location, SourceLocation openTagLocation, String commandName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, openTagLocation, commandName);
        String meaning = null;
        String desc = null;
        ImmutableList<ExprRootNode> genders = null;
        Optional<Object> alternateIdAttribute = Optional.empty();
        this.attributes = attributes;
        this.openTagLocation = openTagLocation;
        block12: for (CommandTagAttribute attr : attributes) {
            String name = attr.getName().identifier();
            switch (attr.getName().identifier()) {
                case "meaning": {
                    meaning = attr.getValue();
                    meaning = LINE_BOUNDARY_PATTERN.matcher(meaning).replaceAll(" ");
                    continue block12;
                }
                case "desc": {
                    desc = attr.getValue();
                    continue block12;
                }
                case "genders": {
                    genders = attr.valueAsExprList();
                    if (!genders.isEmpty() && genders.size() <= 3) continue block12;
                    errorReporter.report(attr.getValueLocation(), WRONG_NUMBER_OF_GENDER_EXPRS, new Object[0]);
                    continue block12;
                }
                case "alternateId": {
                    alternateIdAttribute = Optional.of(attr);
                    continue block12;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, commandName, ImmutableList.of((Object)"meaning", (Object)"desc", (Object)"genders", (Object)"alternateId"));
        }
        if (desc == null) {
            errorReporter.report(location, CommandTagAttribute.MISSING_ATTRIBUTE, "desc", commandName);
            desc = "";
        }
        this.meaning = meaning;
        this.desc = desc;
        this.genderExprs = genders;
        this.alternateIdAttribute = alternateIdAttribute;
        this.alternateId = alternateIdAttribute.isPresent() ? ((CommandTagAttribute)alternateIdAttribute.get()).valueAsOptionalLong(errorReporter) : OptionalLong.empty();
        this.genderExprsString = genders != null ? SoyTreeUtils.toSourceString(genders) : null;
    }

    private MsgNode(MsgNode orig, CopyState copyState) {
        super(orig, copyState);
        this.openTagLocation = orig.openTagLocation;
        this.attributes = (List)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        if (orig.genderExprs != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ExprRootNode node : orig.genderExprs) {
                builder.add((Object)node.copy(copyState));
            }
            this.genderExprs = builder.build();
        } else {
            this.genderExprs = null;
        }
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        if (orig.substUnitInfo != null) {
            IdentityHashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> oldToNew = new IdentityHashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>();
            for (SoyNode.MsgSubstUnitNode old : orig.substUnitInfo.nodeToVarNameMap.keySet()) {
                copyState.registerRefListener(old, newObject -> oldToNew.put(old, (SoyNode.MsgSubstUnitNode)newObject));
            }
            this.substUnitInfo = orig.substUnitInfo.copy(oldToNew);
        }
        this.genderExprsString = orig.genderExprsString;
        this.escapingMode = orig.escapingMode;
        this.alternateIdAttribute = orig.alternateIdAttribute.isPresent() ? Optional.of(orig.alternateIdAttribute.get().copy(copyState)) : Optional.empty();
        this.alternateId = orig.alternateId;
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_NODE;
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public List<ExprRootNode> getAndRemoveGenderExprs() {
        ImmutableList<ExprRootNode> genderExprs = this.genderExprs;
        this.genderExprs = null;
        return genderExprs;
    }

    public void calculateSubstitutionInfo(ErrorReporter reporter) {
        if (this.substUnitInfo != null) {
            throw new IllegalStateException("calculateSubstitutionInfo has already been called.");
        }
        this.substUnitInfo = MsgNode.genSubstUnitInfo(this, reporter);
    }

    @VisibleForTesting
    SubstUnitInfo getSubstUnitInfo() {
        if (this.substUnitInfo == null) {
            throw new IllegalStateException("calculateSubstitutionInfo hasn't been called yet.");
        }
        return this.substUnitInfo;
    }

    public EscapingMode getEscapingMode() {
        return this.escapingMode;
    }

    public void setEscapingMode(EscapingMode escapingMode) {
        this.escapingMode = escapingMode;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.genderExprs != null) {
            return ImmutableList.copyOf(this.genderExprs);
        }
        return ImmutableList.of();
    }

    @Nullable
    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public Optional<CommandTagAttribute> getAlternateIdAttribute() {
        return this.alternateIdAttribute;
    }

    public OptionalLong getAlternateId() {
        return this.alternateId;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public boolean isPlrselMsg() {
        return this.isSelectMsg() || this.isPluralMsg();
    }

    public boolean isSelectMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgSelectNode;
    }

    public boolean isPluralMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgPluralNode;
    }

    public boolean isRawTextMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof RawTextNode;
    }

    public void ensureSubstUnitInfoHasNotBeenAccessed() {
        if (this.substUnitInfo != null) {
            throw new IllegalStateException("Substitution info has already been accessed.");
        }
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String placeholderName) {
        return (MsgPlaceholderNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)placeholderName);
    }

    public MessagePlaceholder.Summary getPlaceholder(MsgPlaceholderNode placeholderNode) {
        return (MessagePlaceholder.Summary)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)placeholderNode);
    }

    public MsgPluralNode getRepPluralNode(String pluralVarName) {
        return (MsgPluralNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)pluralVarName);
    }

    public String getPluralVarName(MsgPluralNode pluralNode) {
        return ((MessagePlaceholder.Summary)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)pluralNode)).name();
    }

    public MsgSelectNode getRepSelectNode(String selectVarName) {
        return (MsgSelectNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)selectVarName);
    }

    public String getSelectVarName(MsgSelectNode selectNode) {
        return ((MessagePlaceholder.Summary)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)selectNode)).name();
    }

    public ImmutableMap<String, SoyNode.MsgSubstUnitNode> getVarNameToRepNodeMap() {
        return this.getSubstUnitInfo().varNameToRepNodeMap;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder();
        if (this.meaning != null) {
            commandText.append(" meaning=\"").append(this.meaning).append('\"');
        }
        if (this.desc != null) {
            commandText.append(" desc=\"").append(this.desc).append('\"');
        }
        if (this.genderExprsString != null) {
            commandText.append(" genders=\"").append(this.genderExprsString).append('\"');
        }
        if (this.alternateId.isPresent()) {
            commandText.append(" alternateId=\"").append(this.alternateId).append('\"');
        }
        return commandText.toString().trim();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public MsgNode copy(CopyState copyState) {
        return new MsgNode(this, copyState);
    }

    private static SubstUnitInfo genSubstUnitInfo(MsgNode msgNode, ErrorReporter errorReporter) {
        return MsgNode.genFinalSubstUnitInfoMapsHelper(RepresentativeNodes.createFromNode(msgNode, errorReporter), errorReporter);
    }

    private static SourceLocation phnameLocation(SoyNode.MsgSubstUnitNode node) {
        return node.getPlaceholder().userSuppliedNameLocation().orElse(node.getSourceLocation());
    }

    private static boolean equivalentCalls(SoyNode a, SoyNode b) {
        if (!(a instanceof CallBasicNode) || !(b instanceof CallBasicNode)) {
            return false;
        }
        CallBasicNode callA = (CallBasicNode)a;
        CallBasicNode callB = (CallBasicNode)b;
        ExprEquivalence eq = new ExprEquivalence();
        if (!eq.equivalent(callA.getCalleeExpr(), callB.getCalleeExpr())) {
            return false;
        }
        if (!eq.equivalent(callA.getVariantExpr(), callB.getVariantExpr())) {
            return false;
        }
        if (SoyTreeUtils.allNodesOfType(a, CallParamContentNode.class).findAny().isPresent() || SoyTreeUtils.allNodesOfType(b, CallParamContentNode.class).findAny().isPresent()) {
            return false;
        }
        ImmutableMap<String, CallParamValueNode> paramsA = MsgNode.paramsByName(callA);
        ImmutableMap<String, CallParamValueNode> paramsB = MsgNode.paramsByName(callB);
        if (paramsA.size() != paramsB.size()) {
            return false;
        }
        for (Map.Entry entry : paramsA.entrySet()) {
            CallParamValueNode valueB = (CallParamValueNode)paramsB.get(entry.getKey());
            if (valueB != null && eq.equivalent(((CallParamValueNode)entry.getValue()).getExpr(), valueB.getExpr())) continue;
            return false;
        }
        return true;
    }

    private static ImmutableMap<String, CallParamValueNode> paramsByName(CallBasicNode call) {
        return (ImmutableMap)SoyTreeUtils.allNodesOfType(call, CallParamValueNode.class).collect(ImmutableMap.toImmutableMap(p -> p.getKey().identifier(), p -> p));
    }

    private static boolean allEquivalentCallsWithExplicitPhname(List<SoyNode.MsgSubstUnitNode> nodes) {
        MsgPlaceholderNode last = null;
        for (SoyNode.MsgSubstUnitNode node : nodes) {
            if (!(node instanceof MsgPlaceholderNode)) {
                return false;
            }
            MsgPlaceholderNode placeholder = (MsgPlaceholderNode)node;
            if (!placeholder.getPlaceholder().userSuppliedName().isPresent()) {
                return false;
            }
            if (!(last == null || MsgNode.equivalentCalls((SoyNode)last.getChild(0), (SoyNode)placeholder.getChild(0)) && last.getPlaceholder().example().equals(placeholder.getPlaceholder().example()))) {
                return false;
            }
            last = placeholder;
        }
        return true;
    }

    private static SubstUnitInfo genFinalSubstUnitInfoMapsHelper(RepresentativeNodes representativeNodes, ErrorReporter errorReporter) {
        LinkedHashMap<Object, SoyNode.MsgSubstUnitNode> substUnitVarNameToRepNodeMap = new LinkedHashMap<Object, SoyNode.MsgSubstUnitNode>();
        LinkedHashMap<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary> substUnitNodeToVarNameMap = new LinkedHashMap<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary>();
        for (String string : representativeNodes.baseNameToRepNodesMap().keySet()) {
            ImmutableList nodesWithSameBaseName = representativeNodes.baseNameToRepNodesMap().get((Object)string);
            Preconditions.checkState((!nodesWithSameBaseName.isEmpty() ? 1 : 0) != 0, (String)"%s not found in `baseNameToRepNodesMap`.", (Object)string);
            if (nodesWithSameBaseName.size() == 1) {
                substUnitVarNameToRepNodeMap.put(string, (SoyNode.MsgSubstUnitNode)nodesWithSameBaseName.get(0));
                continue;
            }
            if (MsgNode.allEquivalentCallsWithExplicitPhname((List<SoyNode.MsgSubstUnitNode>)nodesWithSameBaseName)) {
                substUnitVarNameToRepNodeMap.put(string, (SoyNode.MsgSubstUnitNode)nodesWithSameBaseName.get(0));
                MessagePlaceholder.Summary varName = MessagePlaceholder.Summary.create(string, ((MsgPlaceholderNode)nodesWithSameBaseName.get(0)).getPlaceholder().example());
                nodesWithSameBaseName.forEach(node -> substUnitNodeToVarNameMap.put((SoyNode.MsgSubstUnitNode)node, varName));
                continue;
            }
            int nextSuffix = 1;
            for (int i = 0; i < nodesWithSameBaseName.size(); ++i) {
                String newName;
                SoyNode.MsgSubstUnitNode repNode = (SoyNode.MsgSubstUnitNode)nodesWithSameBaseName.get(i);
                do {
                    newName = string + "_" + nextSuffix;
                    ++nextSuffix;
                } while (representativeNodes.baseNameToRepNodesMap().containsKey((Object)newName));
                substUnitVarNameToRepNodeMap.put(newName, repNode);
                if (!repNode.getPlaceholder().userSuppliedName().isPresent()) continue;
                SoyNode.MsgSubstUnitNode exampleCollidingNode = (SoyNode.MsgSubstUnitNode)nodesWithSameBaseName.get(i == 0 ? 1 : 0);
                if (representativeNodes.repNodeToNonRepNodesMap().containsKey((Object)repNode)) {
                    errorReporter.report(MsgNode.phnameLocation(repNode), BASE_NAME_COLLISION_MULTIPLE, string, MsgNode.phnameLocation(exampleCollidingNode).toLineColumnString(), representativeNodes.repNodeToNonRepNodesMap().get((Object)repNode).stream().map(node -> MsgNode.phnameLocation(node).toLineColumnString()).collect(ImmutableList.toImmutableList()));
                    continue;
                }
                errorReporter.report(MsgNode.phnameLocation(repNode), BASE_NAME_COLLISION_SINGLE, string, MsgNode.phnameLocation(exampleCollidingNode).toLineColumnString());
            }
        }
        for (Map.Entry entry : substUnitVarNameToRepNodeMap.entrySet()) {
            substUnitNodeToVarNameMap.put((SoyNode.MsgSubstUnitNode)entry.getValue(), MessagePlaceholder.Summary.create((String)entry.getKey(), Optional.ofNullable((String)representativeNodes.repNodeToPhExample().get(entry.getValue()))));
        }
        for (Map.Entry entry : representativeNodes.repNodeToNonRepNodesMap().entries()) {
            SoyNode.MsgSubstUnitNode repNode = (SoyNode.MsgSubstUnitNode)entry.getKey();
            SoyNode.MsgSubstUnitNode nonRepNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            substUnitNodeToVarNameMap.put(nonRepNode, (MessagePlaceholder.Summary)substUnitNodeToVarNameMap.get(repNode));
        }
        return new SubstUnitInfo((Map<String, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(substUnitVarNameToRepNodeMap), (Map<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary>)ImmutableMap.copyOf(substUnitNodeToVarNameMap));
    }

    private static Optional<String> getPhExample(SoyNode.MsgSubstUnitNode node) {
        if (node instanceof MsgPlaceholderNode) {
            return node.getPlaceholder().example();
        }
        return Optional.empty();
    }

    @AutoValue
    static abstract class RepresentativeNodes {
        RepresentativeNodes() {
        }

        static RepresentativeNodes createFromNode(MsgNode msgNode, ErrorReporter reporter) {
            LinkedListMultimap baseNameToRepNodesMap = LinkedListMultimap.create();
            LinkedListMultimap repNodeToNonRepNodesMap = LinkedListMultimap.create();
            HashMap<SoyNode.MsgSubstUnitNode, String> repNodeToExample = new HashMap<SoyNode.MsgSubstUnitNode, String>();
            ArrayDeque<SoyNode> traversalQueue = new ArrayDeque<SoyNode>();
            ExprEquivalence exprEquivalence = new ExprEquivalence();
            for (SoyNode child : msgNode.getChildren()) {
                RepresentativeNodes.maybeEnqueue(traversalQueue, child);
            }
            while (!traversalQueue.isEmpty()) {
                SoyNode node = (SoyNode)traversalQueue.remove();
                if (node instanceof MsgSelectNode) {
                    RepresentativeNodes.maybeEnqueueMsgNode(traversalQueue, (MsgSelectNode)node);
                } else if (node instanceof MsgPluralNode) {
                    RepresentativeNodes.maybeEnqueueMsgNode(traversalQueue, (MsgPluralNode)node);
                } else if (node instanceof VeLogNode) {
                    VeLogNode velogNode = (VeLogNode)node;
                    for (SoyNode grandchild : velogNode.getChildren()) {
                        RepresentativeNodes.maybeEnqueue(traversalQueue, grandchild);
                    }
                }
                if (!(node instanceof SoyNode.MsgSubstUnitNode)) continue;
                SoyNode.MsgSubstUnitNode substUnit = (SoyNode.MsgSubstUnitNode)node;
                String baseName = substUnit.getPlaceholder().name();
                if (!baseNameToRepNodesMap.containsKey((Object)baseName)) {
                    baseNameToRepNodesMap.put((Object)baseName, (Object)substUnit);
                    MsgNode.getPhExample(substUnit).ifPresent(example -> repNodeToExample.put(substUnit, (String)example));
                    continue;
                }
                boolean isNew = true;
                for (SoyNode.MsgSubstUnitNode repNode : baseNameToRepNodesMap.get((Object)baseName)) {
                    if (!substUnit.shouldUseSameVarNameAs(repNode, exprEquivalence)) continue;
                    repNodeToNonRepNodesMap.put((Object)repNode, (Object)substUnit);
                    String example2 = RepresentativeNodes.checkCompatibleExamples(substUnit, repNode, reporter);
                    if (example2 != null) {
                        repNodeToExample.put(repNode, example2);
                    }
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                baseNameToRepNodesMap.put((Object)baseName, (Object)substUnit);
                MsgNode.getPhExample(substUnit).ifPresent(example -> repNodeToExample.put(substUnit, (String)example));
            }
            return new AutoValue_MsgNode_RepresentativeNodes((ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode>)ImmutableListMultimap.copyOf((Multimap)baseNameToRepNodesMap), (ImmutableListMultimap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>)ImmutableListMultimap.copyOf((Multimap)repNodeToNonRepNodesMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, String>)ImmutableMap.copyOf((Map)Maps.filterValues(repNodeToExample, Objects::nonNull)));
        }

        private static void maybeEnqueue(Deque<SoyNode> traversalQueue, SoyNode child) {
            if (child instanceof SoyNode.MsgSubstUnitNode || child instanceof VeLogNode) {
                traversalQueue.add(child);
            }
        }

        private static void maybeEnqueueMsgNode(Deque<SoyNode> traversalQueue, SoyNode.ParentSoyNode<CaseOrDefaultNode> node) {
            for (CaseOrDefaultNode child : node.getChildren()) {
                for (SoyNode grandchild : child.getChildren()) {
                    RepresentativeNodes.maybeEnqueue(traversalQueue, grandchild);
                }
            }
        }

        @Nullable
        private static String checkCompatibleExamples(SoyNode.MsgSubstUnitNode left, SoyNode.MsgSubstUnitNode right, ErrorReporter reporter) {
            Optional<String> leftExample = MsgNode.getPhExample(left);
            Optional<String> rightExample = MsgNode.getPhExample(right);
            if (leftExample.isPresent() && rightExample.isPresent() && !leftExample.equals(rightExample)) {
                reporter.report(left.getSourceLocation(), INCOMPATIBLE_PLACEHOLDER_EXAMPLES, new Object[0]);
                return null;
            }
            return leftExample.orElse(rightExample.orElse(null));
        }

        abstract ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode> baseNameToRepNodesMap();

        abstract ImmutableListMultimap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> repNodeToNonRepNodesMap();

        abstract ImmutableMap<SoyNode.MsgSubstUnitNode, String> repNodeToPhExample();
    }

    @VisibleForTesting
    static final class SubstUnitInfo {
        public final ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap;
        public final ImmutableMap<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary> nodeToVarNameMap;

        public SubstUnitInfo(Map<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap, Map<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary> nodeToVarNameMap) {
            this.varNameToRepNodeMap = ImmutableMap.copyOf(varNameToRepNodeMap);
            this.nodeToVarNameMap = ImmutableMap.copyOf(nodeToVarNameMap);
        }

        public SubstUnitInfo copy(Map<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> oldToNew) {
            Function oldToNewFunction = Functions.forMap(oldToNew);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.nodeToVarNameMap.entrySet()) {
                builder.put((Object)oldToNew.get(entry.getKey()), (Object)((MessagePlaceholder.Summary)entry.getValue()));
            }
            return new SubstUnitInfo((Map)this.varNameToRepNodeMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, arg_0 -> SubstUnitInfo.lambda$copy$0((java.util.function.Function)oldToNewFunction, arg_0))), (Map<SoyNode.MsgSubstUnitNode, MessagePlaceholder.Summary>)builder.buildOrThrow());
        }

        private static /* synthetic */ SoyNode.MsgSubstUnitNode lambda$copy$0(java.util.function.Function oldToNewFunction, Map.Entry e) {
            return (SoyNode.MsgSubstUnitNode)oldToNewFunction.apply((SoyNode.MsgSubstUnitNode)e.getValue());
        }
    }
}

