/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SoyNode;

public final class HtmlOpenTagNode
extends HtmlTagNode {
    private boolean isElementRoot = false;
    private boolean isSkipRoot = false;
    private boolean isSkipChildren = false;
    private String keyId = null;
    private boolean isDynamic = true;

    public HtmlOpenTagNode(int id, SoyNode.StandaloneNode node, SourceLocation sourceLocation, boolean selfClosing, HtmlTagNode.TagExistence tagExistence) {
        super(id, node, sourceLocation, tagExistence, selfClosing);
    }

    private HtmlOpenTagNode(HtmlOpenTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isElementRoot = orig.isElementRoot;
        this.keyId = orig.keyId;
        this.isSkipRoot = orig.isSkipRoot;
        this.isSkipChildren = orig.isSkipChildren;
        this.isDynamic = orig.isDynamic;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_OPEN_TAG_NODE;
    }

    public boolean isElementRoot() {
        return this.isElementRoot;
    }

    public void setElementRoot() {
        this.isElementRoot = true;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setIsDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isSlot() {
        return this.getTagName().isStatic() && this.getTagName().getStaticTagName().equals("parameter") && this.getDirectAttributeNamed("slot") != null;
    }

    public boolean isSkipRoot() {
        return this.isSkipRoot || this.isSkipChildren;
    }

    public void setSkipRoot() {
        this.isSkipRoot = true;
    }

    public boolean isSkipChildrenRoot() {
        return this.isSkipChildren;
    }

    public void setSkipChildren() {
        this.isSkipChildren = true;
    }

    public KeyNode getKeyNode() {
        for (SoyNode child : this.getChildren()) {
            if (!(child instanceof KeyNode)) continue;
            return (KeyNode)child;
        }
        return null;
    }

    @Override
    public HtmlOpenTagNode copy(CopyState copyState) {
        return new HtmlOpenTagNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.numChildren(); ++i) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)this.getChild(i);
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(child.toSourceString());
        }
        sb.append(this.isSelfClosing() ? "/>" : ">");
        return sb.toString();
    }
}

