/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyInjector;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateValue;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.Converters;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.sharedpasses.render.CountingFlushableAppendable;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitorAssistantForMsgs;
import com.google.template.soy.sharedpasses.render.RenderableThunk;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    protected final EvalVisitor.EvalVisitorFactory evalVisitorFactory;
    protected final ImmutableMap<String, TemplateNode> basicTemplates;
    protected final DelTemplateSelector<TemplateNode> deltemplates;
    protected final ImmutableTable<SourceLogicalPath, String, ConstNode> constants;
    protected final ParamStore data;
    protected final SoyInjector ijData;
    private final ImmutableTable<SourceLogicalPath, String, ImmutableList<ExternNode>> externs;
    protected Environment env;
    protected final Predicate<String> activeModSelector;
    protected final SoyMsgBundle msgBundle;
    protected final SoyIdRenamingMap xidRenamingMap;
    protected final SoyCssRenamingMap cssRenamingMap;
    protected boolean debugSoyTemplateInfo;
    private EvalVisitor evalVisitor;
    private RenderVisitorAssistantForMsgs assistantForMsgs;
    protected Deque<Appendable> outputBufStack;
    private Appendable currOutputBuf;
    private CountingFlushableAppendable flushable;
    private final PluginInstances pluginInstances;
    private static final RecordProperty VARIANT_PARAM_SYMBOL = RecordProperty.get("$$__variant__");

    public RenderVisitor(EvalVisitor.EvalVisitorFactory evalVisitorFactory, Appendable outputBuf, ImmutableMap<String, TemplateNode> basicTemplates, DelTemplateSelector<TemplateNode> deltemplates, ImmutableTable<SourceLogicalPath, String, ConstNode> constants, ImmutableTable<SourceLogicalPath, String, ImmutableList<ExternNode>> externs, ParamStore data, @Nullable SoyInjector ijData, @Nullable Predicate<String> activeModSelector, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo, PluginInstances pluginInstances) {
        Preconditions.checkNotNull((Object)data);
        this.evalVisitorFactory = evalVisitorFactory;
        this.basicTemplates = (ImmutableMap)Preconditions.checkNotNull(basicTemplates);
        this.deltemplates = (DelTemplateSelector)Preconditions.checkNotNull(deltemplates);
        this.constants = (ImmutableTable)Preconditions.checkNotNull(constants);
        this.externs = (ImmutableTable)Preconditions.checkNotNull(externs);
        this.data = data;
        this.ijData = ijData;
        this.activeModSelector = activeModSelector;
        this.msgBundle = msgBundle;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.pluginInstances = (PluginInstances)Preconditions.checkNotNull((Object)pluginInstances);
        this.evalVisitor = null;
        this.assistantForMsgs = null;
        this.outputBufStack = new ArrayDeque<Appendable>();
        if (outputBuf instanceof Flushable) {
            this.flushable = outputBuf instanceof CountingFlushableAppendable ? (CountingFlushableAppendable)outputBuf : new CountingFlushableAppendable(outputBuf);
            outputBuf = this.flushable;
        }
        this.pushOutputBuf(outputBuf);
    }

    @Override
    public Void exec(SoyNode node) {
        if (this.flushable != null) {
            SoyFutureValueProvider.FutureBlockCallback old = SoyFutureValueProvider.futureBlockCallback.get();
            SoyFutureValueProvider.futureBlockCallback.set(this.flushable);
            super.exec(node);
            SoyFutureValueProvider.futureBlockCallback.set(old);
        } else {
            super.exec(node);
        }
        return null;
    }

    protected RenderVisitor createHelperInstance(Appendable outputBuf, ParamStore data) {
        return new RenderVisitor(this.evalVisitorFactory, outputBuf, this.basicTemplates, this.deltemplates, this.constants, this.externs, data, this.ijData, this.activeModSelector, this.msgBundle, this.xidRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo, this.pluginInstances);
    }

    void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    private void renderTemplate(TemplateNode template) {
        TemplateNode templateToRender = this.getTemplateToRender(template);
        this.env = Environment.create(templateToRender, this.data, this.ijData);
        SoyFileNode file = templateToRender.getParent();
        file.getImports().forEach(this::visitImportNode);
        file.getConstants().forEach(this::visitConstNode);
        this.checkStrictParamTypes(templateToRender);
        this.visitChildren(templateToRender);
        this.env = null;
    }

    private TemplateNode getTemplateToRender(TemplateNode template) {
        if (template instanceof TemplateBasicNode && ((TemplateBasicNode)template).isModifiable()) {
            TemplateBasicNode templateBasicNode = (TemplateBasicNode)template;
            String mapKey = !templateBasicNode.getLegacyDeltemplateNamespace().isEmpty() ? templateBasicNode.getLegacyDeltemplateNamespace() : templateBasicNode.getTemplateName();
            return this.deltemplates.selectTemplate(mapKey, this.data.getFieldProvider(VARIANT_PARAM_SYMBOL).resolve().stringValue(), this.activeModSelector);
        }
        return template;
    }

    @Override
    protected void visitImportNode(ImportNode node) {
        if (node.getImportType() != ImportNode.ImportType.TEMPLATE) {
            return;
        }
        node.visitVars((var, parentType) -> {
            if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE && var.type().getKind() != SoyType.Kind.TEMPLATE_TYPE) {
                this.env.bind((VarDefn)var, SoyValueConverter.INSTANCE.convertLazy(() -> {
                    ConstNode constNode = (ConstNode)this.constants.get((Object)SourceLogicalPath.create(node.getPath()), (Object)var.getSymbol());
                    return this.eval(constNode.getExpr(), constNode);
                }));
            }
        });
    }

    @Override
    protected void visitConstNode(ConstNode node) {
        SoyValue constValue = this.eval(node.getExpr(), node);
        this.env.bind(node.getVar(), constValue);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.renderTemplate(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        RenderVisitor.append(this.currOutputBuf, node.getRawText());
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new RenderVisitorAssistantForMsgs(this, this.msgBundle);
        }
        if (!node.getEscapingDirectives().isEmpty()) {
            this.pushOutputBuf(new StringBuilder());
        }
        this.assistantForMsgs.visitForUseByMaster(node);
        if (!node.getEscapingDirectives().isEmpty()) {
            SoyValue wholeMsg = StringData.forValue(this.popOutputBuf().toString());
            for (SoyPrintDirective directive : node.getEscapingDirectives()) {
                wholeMsg = this.applyDirective(directive, wholeMsg, (List<SoyValue>)ImmutableList.of(), node);
            }
            RenderVisitor.append(this.currOutputBuf, wholeMsg.stringValue());
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        SoyValue result = this.eval(node.getExpr(), node);
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            ImmutableList<ExprRootNode> argsExprs = directiveNode.getArgs();
            ArrayList argsSoyDatas = Lists.newArrayListWithCapacity((int)argsExprs.size());
            for (ExprRootNode argExpr : argsExprs) {
                argsSoyDatas.add(this.eval(argExpr, directiveNode));
            }
            result = this.applyDirective(directiveNode.getPrintDirective(), result, argsSoyDatas, node);
        }
        RenderVisitor.append(this.currOutputBuf, result, node);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.env.bind(node.getVar(), this.lazyEval(node.getExpr(), node));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.env.bind(node.getVar(), this.renderRenderUnitNode(node));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                if (!this.eval(icn.getExpr(), node).coerceToBoolean()) continue;
                this.visit(icn);
                return;
            }
            if (child instanceof IfElseNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        SoyValue switchValue = this.eval(node.getExpr(), node);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprNode caseExpr : scn.getExprList()) {
                    if (!SharedRuntime.switchCaseEqual(switchValue, this.eval(caseExpr, scn))) continue;
                    this.visit(scn);
                    return;
                }
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitForNode(ForNode node) {
        block5: {
            block4: {
                Optional<RangeArgs> exprAsRangeArgs = RangeArgs.createFromNode(node);
                if (!exprAsRangeArgs.isPresent()) break block4;
                RangeArgs args = exprAsRangeArgs.get();
                int step = args.increment().isPresent() ? this.evalRangeArg(node, args.increment().get()) : 1;
                int start = args.start().isPresent() ? this.evalRangeArg(node, args.start().get()) : 0;
                int end = this.evalRangeArg(node, args.limit());
                int length = end - start;
                if ((length ^ step) < 0) break block5;
                ForNonemptyNode child = (ForNonemptyNode)node.getChild(0);
                int size = length / step + (length % step == 0 ? 0 : 1);
                for (int i = 0; i < size; ++i) {
                    this.executeForeachBody(child, i, IntegerData.forValue(start + step * i));
                }
                break block5;
            }
            SoyValue dataRefValue = this.eval(node.getExpr(), node);
            if (!(dataRefValue instanceof SoyList)) {
                throw RenderException.createWithSource("In 'for' command " + node.toSourceString() + ", the data reference does not resolve to a SoyList (encountered type " + dataRefValue.getClass().getName() + ").", node);
            }
            SoyList foreachList = (SoyList)dataRefValue;
            int listLength = foreachList.length();
            if (listLength > 0) {
                ForNonemptyNode child = (ForNonemptyNode)node.getChild(0);
                for (int i = 0; i < listLength; ++i) {
                    this.executeForeachBody(child, i, foreachList.getProvider(i));
                }
            }
        }
    }

    private void executeForeachBody(ForNonemptyNode child, int i, SoyValueProvider value) {
        this.env.bindLoopPosition(child.getVar(), value);
        if (child.getIndexVar() != null) {
            this.env.bind(child.getIndexVar(), SoyValueConverter.INSTANCE.convert(i));
        }
        this.visitChildren(child);
    }

    private int evalRangeArg(SoyNode node, ExprNode rangeArg) {
        SoyValue rangeArgValue = this.eval(rangeArg, node);
        if (!(rangeArgValue instanceof IntegerData)) {
            throw RenderException.create("In 'range' expression \"" + rangeArg.toSourceString() + "\" does not resolve to an integer.").addStackTraceElement(node.getNearestAncestor(TemplateNode.class), rangeArg.getSourceLocation());
        }
        return rangeArgValue.integerValue();
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateValue calleeExpr = (TemplateValue)this.eval(node.getCalleeExpr(), node);
        TemplateNode callee = (TemplateNode)this.basicTemplates.get((Object)calleeExpr.getTemplateName());
        if (callee == null) {
            throw RenderException.createWithSource("Attempting to render undefined template '" + node.getCalleeName() + "'.", node);
        }
        this.visitCallNodeHelper(node, callee, calleeExpr.getBoundParameters());
    }

    protected String variantString(ExprNode variantExpr, CallNode node) {
        try {
            SoyValue variantData = this.eval(variantExpr, node);
            if (variantData instanceof IntegerData) {
                return String.valueOf(variantData.longValue());
            }
            return variantData.coerceToString();
        }
        catch (SoyDataException e) {
            throw RenderException.createWithSource(String.format("Variant expression \"%s\" doesn't evaluate to a valid type (Only string, integer, and proto enums are supported).", variantExpr.toSourceString()), e, node);
        }
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateNode callee;
        ExprRootNode variantExpr = node.getDelCalleeVariantExpr();
        String variant = variantExpr == null ? "" : this.variantString(variantExpr, node);
        try {
            callee = this.deltemplates.selectTemplate(node.getDelCalleeName(), variant, this.activeModSelector);
        }
        catch (IllegalArgumentException e) {
            throw RenderException.createWithSource(e.getMessage(), e, node);
        }
        if (callee == null) {
            throw RenderException.createWithSource("Found no active impl for delegate call to \"" + node.getDelCalleeName() + (String)(variant.isEmpty() ? "" : ":" + variant) + "\".", node);
        }
        this.visitCallNodeHelper(node, callee, Optional.empty());
    }

    private void visitCallNodeHelper(CallNode node, TemplateNode callee, Optional<ParamStore> boundParams) {
        ParamStore callData = this.createCallParamsWithVariant(node);
        if (boundParams.isPresent()) {
            callData = ParamStore.merge(boundParams.get(), callData);
        }
        if (node.getEscapingDirectives().isEmpty()) {
            RenderVisitor rv = this.createHelperInstance(this.currOutputBuf, callData);
            try {
                rv.renderTemplate(callee);
            }
            catch (RenderException re) {
                throw re.addStackTraceElement(node);
            }
        }
        StringBuilder calleeBuilder = new StringBuilder();
        RenderVisitor rv = this.createHelperInstance(calleeBuilder, callData);
        try {
            rv.renderTemplate(callee);
        }
        catch (RenderException re) {
            throw re.addStackTraceElement(node);
        }
        SanitizedContent.ContentKind calleeKind = RenderVisitor.fromSanitizedContentKind(callee.getContentKind());
        SoyValue resultData = calleeKind != SanitizedContent.ContentKind.TEXT ? UnsafeSanitizedContentOrdainer.ordainAsSafe(calleeBuilder.toString(), calleeKind) : StringData.forValue(calleeBuilder.toString());
        for (SoyPrintDirective directive : node.getEscapingDirectives()) {
            resultData = this.applyDirective(directive, resultData, (List<SoyValue>)ImmutableList.of(), node);
        }
        RenderVisitor.append(this.currOutputBuf, resultData, node);
    }

    private String getVariant(CallNode node) {
        if (!(node instanceof CallBasicNode)) {
            return "";
        }
        CallBasicNode callBasicNode = (CallBasicNode)node;
        if (callBasicNode.getVariantExpr() == null) {
            return "";
        }
        return this.variantString(callBasicNode.getVariantExpr(), callBasicNode);
    }

    private ParamStore createCallParamsWithVariant(CallNode node) {
        ParamStore params = this.createCallParams(node);
        return new ParamStore(params, params.size() + 1).setField(VARIANT_PARAM_SYMBOL, StringData.forValue(this.getVariant(node))).freeze();
    }

    private ParamStore createCallParams(CallNode node) {
        ParamStore params;
        if (node.numChildren() == 0) {
            if (!node.isPassingData()) {
                return ParamStore.EMPTY_INSTANCE;
            }
            if (!node.isPassingAllData()) {
                return ParamStore.fromRecord(this.getDataRecord(node));
            }
            ImmutableList<TemplateParam> params2 = node.getNearestAncestor(TemplateNode.class).getParams();
            ParamStore dataWithDefaults = null;
            for (TemplateParam param : params2) {
                RecordProperty paramSymbol = RecordProperty.get(param.name());
                if (!param.hasDefault() || this.data.containsKey(paramSymbol)) continue;
                if (dataWithDefaults == null) {
                    dataWithDefaults = new ParamStore(this.data, params2.size());
                }
                dataWithDefaults.setField(paramSymbol, this.lazyEval(param.defaultValue(), node));
            }
            return dataWithDefaults == null ? this.data : dataWithDefaults.freeze();
        }
        if (node.isPassingData()) {
            ParamStore dataRecord = node.isPassingAllData() ? this.data : ParamStore.fromRecord(this.getDataRecord(node));
            params = new ParamStore(dataRecord, node.numChildren());
            if (node.isPassingAllData()) {
                for (TemplateParam param : node.getNearestAncestor(TemplateNode.class).getParams()) {
                    RecordProperty key = RecordProperty.get(param.name());
                    if (!param.hasDefault() || params.hasField(key)) continue;
                    params.setField(key, this.lazyEval(param.defaultValue(), node));
                }
            }
        } else {
            params = new ParamStore(node.numChildren());
        }
        for (CallParamNode child : node.getChildren()) {
            if (child instanceof CallParamValueNode) {
                params.setField(RecordProperty.get(child.getKey().identifier()), this.lazyEval(((CallParamValueNode)child).getExpr(), child));
                continue;
            }
            if (child instanceof CallParamContentNode) {
                params.setField(RecordProperty.get(child.getKey().identifier()), this.renderRenderUnitNode((CallParamContentNode)child));
                continue;
            }
            throw new AssertionError();
        }
        return params;
    }

    private SoyRecord getDataRecord(CallNode node) {
        SoyValue dataRefValue = this.eval(node.getDataExpr(), node);
        if (!(dataRefValue instanceof SoyRecord)) {
            throw RenderException.create("In 'call' command " + node.toSourceString() + ", the data reference does not resolve to a SoyRecord.").addStackTraceElement(node);
        }
        return (SoyRecord)dataRefValue;
    }

    @Override
    protected void visitCallParamNode(CallParamNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        ExprRootNode logonlyExpression = node.getLogonlyExpression();
        if (logonlyExpression != null && this.eval(logonlyExpression, node).booleanValue()) {
            throw RenderException.createWithSource("Cannot set logonly=\"true\" unless there is a logger configured, but tofu doesn't support loggers", node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitLogNode(LogNode node) {
        this.renderBlock(node, System.out);
        System.out.println();
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void pushOutputBuf(Appendable outputBuf) {
        this.outputBufStack.push(outputBuf);
        this.currOutputBuf = outputBuf;
    }

    private Appendable popOutputBuf() {
        Appendable poppedOutputBuf = this.outputBufStack.pop();
        this.currOutputBuf = this.outputBufStack.peek();
        return poppedOutputBuf;
    }

    Appendable getCurrOutputBufForUseByAssistants() {
        return this.currOutputBuf;
    }

    private void renderBlock(SoyNode.BlockNode block, Appendable to) {
        this.pushOutputBuf(to);
        this.visitChildren(block);
        this.popOutputBuf();
    }

    private SoyValueProvider renderRenderUnitNode(final SoyNode.RenderUnitNode renderUnitNode) {
        return new RenderableThunk(RenderVisitor.fromSanitizedContentKind(renderUnitNode.getContentKind())){

            @Override
            protected void doRender(Appendable appendable) {
                RenderVisitor.this.renderBlock(renderUnitNode, appendable);
            }
        };
    }

    private static SanitizedContent.ContentKind fromSanitizedContentKind(SanitizedContentKind kind) {
        return Converters.toContentKind(kind);
    }

    private SoyValue eval(ExprNode expr, SoyNode node) {
        if (expr == null) {
            throw RenderException.create("Cannot evaluate expression in V1 syntax.").addStackTraceElement(node);
        }
        if (this.evalVisitor == null) {
            this.evalVisitor = this.evalVisitorFactory.create(this.env, this.cssRenamingMap, this.xidRenamingMap, this.msgBundle, this.debugSoyTemplateInfo, this.pluginInstances, this.externs, this.deltemplates, this.activeModSelector);
        }
        try {
            return (SoyValue)this.evalVisitor.exec(expr);
        }
        catch (RenderException e) {
            throw RenderException.createFromRenderException("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage(), e, node);
        }
        catch (Exception e) {
            throw RenderException.createWithSource("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage(), e, node);
        }
    }

    private SoyValueProvider lazyEval(final ExprNode expr, final SoyNode node) {
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return RenderVisitor.this.eval(expr, node);
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    SoyValue evalForUseByAssistants(ExprNode expr, SoyNode node) {
        return this.eval(expr, node);
    }

    static void append(Appendable outputBuf, CharSequence cs) {
        try {
            outputBuf.append(cs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void append(Appendable outputBuf, SoyValue value, SoyNode node) {
        try {
            value.render(outputBuf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RenderException e) {
            throw e.addStackTraceElement(node);
        }
    }

    private SoyValue applyDirective(SoyPrintDirective directive, SoyValue value, List<SoyValue> args, SoyNode node) {
        if (!(directive instanceof SoyJavaPrintDirective)) {
            throw RenderException.createWithSource("Failed to find Soy print directive with name '" + String.valueOf(directive) + "' (tag " + node.toSourceString() + ")", node);
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw RenderException.createWithSource("Print directive '" + String.valueOf(directive) + "' used with the wrong number of arguments (tag " + node.toSourceString() + ").", node);
        }
        try {
            return ((SoyJavaPrintDirective)directive).applyForJava(value, args);
        }
        catch (RuntimeException e) {
            throw RenderException.createWithSource(String.format("Failed in applying directive '%s' in tag \"%s\" due to exception: %s", directive, node.toSourceString(), e.getMessage()), e, node);
        }
    }

    private void checkStrictParamTypes(TemplateNode node) {
        for (TemplateParam param : node.getParams()) {
            this.checkStrictParamType(node, param, this.env.getVarProvider(param));
        }
        for (TemplateParam param : node.getInjectedParams()) {
            this.checkStrictParamType(node, param, this.env.getVarProvider(param));
        }
    }

    private void checkStrictParamType(final TemplateNode node, final TemplateParam param, @Nullable SoyValueProvider paramValue) {
        SoyValue value;
        SoyType.Kind kind = param.type().getKind();
        if (kind == SoyType.Kind.ANY || kind == SoyType.Kind.UNKNOWN) {
            return;
        }
        if (paramValue == null) {
            paramValue = UndefinedData.INSTANCE;
        } else if (paramValue instanceof SoyAbstractCachingValueProvider) {
            SoyAbstractCachingValueProvider typedValue = (SoyAbstractCachingValueProvider)paramValue;
            if (!typedValue.isComputed()) {
                typedValue.addValueAssertion(new SoyAbstractCachingValueProvider.ValueAssertion(){

                    @Override
                    public void check(SoyValue value) {
                        RenderVisitor.this.checkValueType(param, value, node);
                    }
                });
                return;
            }
        } else if (param.hasDefault() && paramValue.resolve() instanceof UndefinedData) {
            return;
        }
        try {
            value = paramValue.resolve();
        }
        catch (Exception e) {
            throw RenderException.createWithSource("failed to evaluate param: " + param.name(), e, node);
        }
        this.checkValueType(param, value, node);
    }

    private void checkValueType(TemplateParam param, SoyValue value, TemplateNode node) {
        if (!TofuTypeChecks.isInstance(param.type(), value, param.nameLocation())) {
            throw RenderException.createWithSource("Parameter type mismatch: attempt to bind value '" + String.valueOf(value instanceof UndefinedData ? "(undefined)" : value) + "' (a " + value.getClass().getSimpleName() + ") to parameter '" + param.name() + "' which has a declared type of '" + String.valueOf(param.type()) + "'.", node);
        }
    }
}

