/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.internal.SoyScopedData;
import java.util.ArrayDeque;
import javax.annotation.Nullable;

public final class SoySimpleScope
implements SoyScopedData,
SoyScopedData.Enterable {
    private static final ThreadLocal<ArrayDeque<BidiGlobalDir>> scopedValuesTl = new ThreadLocal();

    @Override
    @CheckReturnValue
    public InScope enter(@Nullable SoyMsgBundle msgBundle) {
        return this.enter(msgBundle, null);
    }

    @Override
    @CheckReturnValue
    public InScope enter(@Nullable SoyMsgBundle msgBundle, @Nullable BidiGlobalDir bidiGlobalDir) {
        return this.enter(bidiGlobalDir == null ? BidiGlobalDir.forStaticIsRtl(msgBundle != null && msgBundle.isRtl()) : bidiGlobalDir);
    }

    @Override
    @CheckReturnValue
    public InScope enter(BidiGlobalDir bidiGlobalDir) {
        ArrayDeque<BidiGlobalDir> stack = scopedValuesTl.get();
        if (stack == null) {
            stack = new ArrayDeque();
            scopedValuesTl.set(stack);
        }
        stack.push(bidiGlobalDir);
        return new InScope(bidiGlobalDir, stack);
    }

    @Override
    public SoyScopedData.Enterable enterable() {
        return this;
    }

    @Override
    public BidiGlobalDir getBidiGlobalDir() {
        ArrayDeque<BidiGlobalDir> arrayDeque = scopedValuesTl.get();
        if (arrayDeque == null || arrayDeque.isEmpty()) {
            throw new IllegalStateException("Cannot access scoped data outside of a scoping block");
        }
        return arrayDeque.peek();
    }

    private static final class InScope
    implements SoyScopedData.InScope {
        private boolean isClosed;
        private final Thread openThread = Thread.currentThread();
        private final ArrayDeque<BidiGlobalDir> deque;
        private final BidiGlobalDir dir;

        InScope(BidiGlobalDir dir, ArrayDeque<BidiGlobalDir> deque) {
            this.deque = deque;
            this.dir = dir;
        }

        @Override
        public BidiGlobalDir getBidiGlobalDir() {
            return this.dir;
        }

        @Override
        public void close() {
            this.checkOpenAndOnCorrectThread();
            this.isClosed = true;
            this.deque.pop();
        }

        private void checkOpenAndOnCorrectThread() {
            if (this.isClosed) {
                throw new IllegalStateException("called close() more than once!");
            }
            if (Thread.currentThread() != this.openThread) {
                throw new IllegalStateException("cannot move the scope to another thread");
            }
        }
    }
}

