/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SharedRuntime {
    public static boolean equal(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof StringData) {
            return SharedRuntime.compareString(operand0.stringValue(), operand1);
        }
        if (operand1 instanceof StringData) {
            return SharedRuntime.compareString(operand1.stringValue(), operand0);
        }
        if ((operand0 == null || operand0.isNullish()) && (operand1 == null || operand1.isNullish())) {
            return true;
        }
        return Objects.equals(operand0, operand1);
    }

    public static boolean tripleEqual(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof BooleanData && operand1 instanceof BooleanData) {
            return operand0.booleanValue() == operand1.booleanValue();
        }
        if (operand0 instanceof NumberData && operand1 instanceof NumberData) {
            return operand0.numberValue() == operand1.numberValue();
        }
        if (operand0 instanceof StringData && operand1 instanceof StringData) {
            return operand0.stringValue().equals(operand1.stringValue());
        }
        return operand0 == operand1;
    }

    public static boolean switchCaseEqual(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof SanitizedContent) {
            operand0 = StringData.forValue(operand0.toString());
        }
        if (operand1 instanceof SanitizedContent) {
            operand1 = StringData.forValue(operand1.toString());
        }
        return SharedRuntime.tripleEqual(operand0, operand1);
    }

    @Nonnull
    public static SoyValue plus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() + operand1.longValue());
        }
        if (operand0 instanceof NumberData && operand1 instanceof NumberData) {
            return FloatData.forValue(operand0.numberValue() + operand1.numberValue());
        }
        return StringData.forValue(operand0.coerceToString() + operand1.coerceToString());
    }

    @Nonnull
    public static SoyValue minus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() - operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() - operand1.numberValue());
    }

    @Nonnull
    public static NumberData times(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() * operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() * operand1.numberValue());
    }

    public static double dividedBy(SoyValue operand0, SoyValue operand1) {
        return operand0.numberValue() / operand1.numberValue();
    }

    @Nonnull
    public static NumberData mod(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() % operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() % operand1.numberValue());
    }

    @Nonnull
    public static NumberData shiftRight(SoyValue operand0, SoyValue operand1) {
        return IntegerData.forValue(operand0.longValue() >> (int)operand1.longValue());
    }

    @Nonnull
    public static NumberData shiftLeft(SoyValue operand0, SoyValue operand1) {
        return IntegerData.forValue(operand0.longValue() << (int)operand1.longValue());
    }

    @Nonnull
    public static NumberData bitwiseOr(SoyValue operand0, SoyValue operand1) {
        return IntegerData.forValue(operand0.longValue() | operand1.longValue());
    }

    @Nonnull
    public static NumberData bitwiseXor(SoyValue operand0, SoyValue operand1) {
        return IntegerData.forValue(operand0.longValue() ^ operand1.longValue());
    }

    @Nonnull
    public static NumberData bitwiseAnd(SoyValue operand0, SoyValue operand1) {
        return IntegerData.forValue(operand0.longValue() & operand1.longValue());
    }

    public static boolean lessThan(SoyValue left, SoyValue right) {
        if (left instanceof StringData && right instanceof StringData) {
            return left.stringValue().compareTo(right.stringValue()) < 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() < right.longValue();
        }
        return left.numberValue() < right.numberValue();
    }

    public static boolean lessThanOrEqual(SoyValue left, SoyValue right) {
        if (left instanceof StringData && right instanceof StringData) {
            return left.stringValue().compareTo(right.stringValue()) <= 0;
        }
        if (left instanceof IntegerData && right instanceof IntegerData) {
            return left.longValue() <= right.longValue();
        }
        return left.numberValue() <= right.numberValue();
    }

    @Nonnull
    public static NumberData negative(SoyValue node) {
        if (node instanceof IntegerData) {
            return IntegerData.forValue(-node.longValue());
        }
        return FloatData.forValue(-node.floatValue());
    }

    public static boolean compareString(String string, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return string.equals(other.toString());
        }
        if (other instanceof NumberData) {
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    @Nonnull
    public static String soyServerKey(SoyValue key) {
        if (key instanceof NumberData) {
            return SharedRuntime.serialize(key.coerceToString(), "#");
        }
        if (key == null) {
            return SharedRuntime.serialize("null", "_");
        }
        return SharedRuntime.serialize(key.coerceToString(), ":");
    }

    @Nonnull
    public static SoyMap constructMapFromList(List<? extends SoyValueProvider> list) {
        ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            SoyValue recordEntry = list.get(i).resolve();
            SharedRuntime.checkMapFromListConstructorCondition(recordEntry instanceof SoyRecord, recordEntry, i);
            SoyRecord record = (SoyRecord)recordEntry;
            SoyValue key = record.getField(RecordProperty.KEY);
            SoyValueProvider valueProvider = record.getFieldProvider(RecordProperty.VALUE);
            SharedRuntime.checkMapFromListConstructorCondition(SoyMap.isAllowedKeyType(key) && valueProvider != null, recordEntry, i);
            map.put((Object)key, (Object)valueProvider);
        }
        return SoyMapImpl.forProviderMap((Map<? extends SoyValue, ? extends SoyValueProvider>)map.buildKeepingLast());
    }

    public static void checkMapFromListConstructorCondition(boolean condition, SoyValue value, int index) {
        if (!condition) {
            String exceptionString = String.format("Error constructing map. Expected a list where each item is a record of 'key', 'value' pairs, with the 'key' fields holding primitive values. Found: %s at index %d", value, index);
            throw new IllegalArgumentException(exceptionString);
        }
    }

    private static String serialize(String key, String delimiter) {
        return key.length() + delimiter + key;
    }

    private SharedRuntime() {
    }
}

