/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.shared.ToggleRegistry;
import java.util.Map;
import javax.annotation.Nullable;

public final class ImmutableSetMultimapToggleRegistry
implements ToggleRegistry {
    private final ImmutableSetMultimap<SourceLogicalPath, String> filePathToToggleMap;
    private final ImmutableMap<SourceLogicalPath, SourceFilePath> logicalToFilePathMap;

    public static ImmutableSetMultimapToggleRegistry createForTest(ImmutableSetMultimap<SourceLogicalPath, String> filePathToToggleMap) {
        return new ImmutableSetMultimapToggleRegistry(filePathToToggleMap, (ImmutableMap<SourceLogicalPath, SourceFilePath>)ImmutableMap.of());
    }

    public static ImmutableSetMultimapToggleRegistry create(ImmutableSetMultimap<SourceFilePath, String> filePathToToggleMap) {
        return new ImmutableSetMultimapToggleRegistry((ImmutableSetMultimap<SourceLogicalPath, String>)((ImmutableSetMultimap)filePathToToggleMap.entries().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(e -> ((SourceFilePath)e.getKey()).asLogicalPath(), Map.Entry::getValue))), (ImmutableMap<SourceLogicalPath, SourceFilePath>)((ImmutableMap)filePathToToggleMap.asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((SourceFilePath)e.getKey()).asLogicalPath(), Map.Entry::getKey))));
    }

    private ImmutableSetMultimapToggleRegistry(ImmutableSetMultimap<SourceLogicalPath, String> filePathToToggleMap, ImmutableMap<SourceLogicalPath, SourceFilePath> logicalToFilePathMap) {
        this.filePathToToggleMap = filePathToToggleMap;
        this.logicalToFilePathMap = logicalToFilePathMap;
    }

    @Override
    public ImmutableSet<String> getToggles(SourceLogicalPath path) {
        return this.filePathToToggleMap.get((Object)path);
    }

    @Override
    public ImmutableSet<SourceLogicalPath> getPaths() {
        return this.filePathToToggleMap.keySet();
    }

    @Nullable
    public SourceFilePath getFilePathForLogicalPath(SourceLogicalPath path) {
        return (SourceFilePath)this.logicalToFilePathMap.get((Object)path);
    }
}

