/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UndefinedType;
import com.google.template.soy.types.UnionType;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public enum BuiltinFunction implements SoyFunction
{
    CHECK_NOT_NULL("checkNotNull"),
    CSS("css"),
    EVAL_TOGGLE("$evalToggle"),
    XID("xid"),
    SOY_SERVER_KEY("$soyServerKey"),
    UNKNOWN_JS_GLOBAL("unknownJsGlobal"),
    REMAINDER("remainder"),
    MSG_WITH_ID("msgWithId"),
    VE_DATA("ve_data"),
    LEGACY_DYNAMIC_TAG("legacyDynamicTag"),
    IS_PRIMARY_MSG_IN_USE("$$isPrimaryMsgInUse"),
    TO_FLOAT("$$toFloat"),
    DEBUG_SOY_TEMPLATE_INFO("$$debugSoyTemplateInfo"),
    PROTO_INIT("$$protoInit"),
    VE_DEF("ve_def"),
    EMPTY_TO_NULL("$$emptyToNull"),
    UNDEFINED_TO_NULL("undefinedToNullForMigration"),
    UNDEFINED_TO_NULL_SSR("undefinedToNullForSsrMigration"),
    BOOLEAN("Boolean"),
    HAS_CONTENT("hasContent"),
    IS_TRUTHY_NON_EMPTY("isTruthyNonEmpty");

    private final String functionName;

    private BuiltinFunction(String name) {
        this.functionName = name;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        switch (this) {
            case CSS: 
            case EVAL_TOGGLE: 
            case VE_DATA: {
                return ImmutableSet.of((Object)1, (Object)2);
            }
            case IS_PRIMARY_MSG_IN_USE: {
                return ImmutableSet.of((Object)3);
            }
            case DEBUG_SOY_TEMPLATE_INFO: {
                return ImmutableSet.of((Object)0);
            }
            case SOY_SERVER_KEY: 
            case CHECK_NOT_NULL: 
            case XID: 
            case UNKNOWN_JS_GLOBAL: 
            case LEGACY_DYNAMIC_TAG: 
            case REMAINDER: 
            case MSG_WITH_ID: 
            case TO_FLOAT: 
            case EMPTY_TO_NULL: 
            case UNDEFINED_TO_NULL: 
            case UNDEFINED_TO_NULL_SSR: 
            case BOOLEAN: 
            case IS_TRUTHY_NON_EMPTY: 
            case HAS_CONTENT: {
                return ImmutableSet.of((Object)1);
            }
            case PROTO_INIT: {
                throw new UnsupportedOperationException();
            }
            case VE_DEF: {
                return ImmutableSet.of((Object)2, (Object)3, (Object)4);
            }
        }
        throw new AssertionError(this);
    }

    public Optional<List<SoyType>> getValidArgTypes() {
        switch (this) {
            case HAS_CONTENT: {
                return Optional.of(ImmutableList.of((Object)UnionType.of(SanitizedType.AttributesType.getInstance(), SanitizedType.ElementType.getInstance("?"), SanitizedType.HtmlType.getInstance(), SanitizedType.JsType.getInstance(), SanitizedType.StyleType.getInstance(), SanitizedType.TrustedResourceUriType.getInstance(), SanitizedType.UriType.getInstance(), StringType.getInstance(), NullType.getInstance(), UndefinedType.getInstance())));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isPure() {
        switch (this) {
            case VE_DATA: 
            case CHECK_NOT_NULL: 
            case MSG_WITH_ID: 
            case TO_FLOAT: 
            case EMPTY_TO_NULL: 
            case UNDEFINED_TO_NULL: 
            case UNDEFINED_TO_NULL_SSR: 
            case BOOLEAN: 
            case IS_TRUTHY_NON_EMPTY: 
            case HAS_CONTENT: 
            case PROTO_INIT: {
                return true;
            }
            case CSS: 
            case EVAL_TOGGLE: 
            case IS_PRIMARY_MSG_IN_USE: 
            case DEBUG_SOY_TEMPLATE_INFO: 
            case SOY_SERVER_KEY: 
            case XID: 
            case UNKNOWN_JS_GLOBAL: 
            case LEGACY_DYNAMIC_TAG: 
            case REMAINDER: 
            case VE_DEF: {
                return false;
            }
        }
        throw new AssertionError(this);
    }

    public String deprecatedWarning() {
        return "";
    }
}

