/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.ArrayList;
import java.util.List;

final class PythonValueFactoryImpl
extends PythonValueFactory {
    private static final PythonValueImpl ERROR_VALUE = new PythonValueImpl(new PyStringExpr("uh oh, if you see this the soy compiler has swallowed an error", Integer.MIN_VALUE));
    private static final SoyErrorKind NULL_RETURN = SoyErrorKind.of(PythonValueFactoryImpl.formatPlain("{2}.applyForPythonSource returned null."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of(PythonValueFactoryImpl.formatPlain("{2}"), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final PythonPluginContext context;
    private final ErrorReporter reporter;

    private static String formatPlain(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\nPlugin implementation: {1}";
    }

    PythonValueFactoryImpl(ErrorReporter reporter, BidiGlobalDir bidiDir) {
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
        Preconditions.checkNotNull((Object)bidiDir);
        this.context = () -> new PythonValueImpl(new PyExpr(bidiDir.getCodeSnippet(), Integer.MIN_VALUE));
    }

    PyExpr applyFunction(SourceLocation location, String name, SoyPythonSourceFunction fn, List<PyExpr> args) {
        PythonValueImpl result;
        try {
            result = (PythonValueImpl)fn.applyForPythonSource(this, PythonValueFactoryImpl.wrapParams(args), this.context);
            if (result == null) {
                this.report(location, name, fn, NULL_RETURN, fn.getClass().getSimpleName());
                result = ERROR_VALUE;
            }
        }
        catch (Throwable t) {
            BaseUtils.trimStackTraceTo(t, fn.getClass());
            this.report(location, name, fn, UNEXPECTED_ERROR, Throwables.getStackTraceAsString((Throwable)t));
            result = ERROR_VALUE;
        }
        return result.expr;
    }

    private void report(SourceLocation location, String name, SoyPythonSourceFunction fn, SoyErrorKind error, Object ... additionalArgs) {
        Object[] args = new Object[additionalArgs.length + 2];
        args[0] = name;
        args[1] = fn.getClass().getName();
        System.arraycopy(additionalArgs, 0, args, 2, additionalArgs.length);
        this.reporter.report(location, error, args);
    }

    private static List<PythonValue> wrapParams(List<PyExpr> params) {
        ArrayList<PythonValue> exprs = new ArrayList<PythonValue>(params.size());
        for (PyExpr e : params) {
            exprs.add(new PythonValueImpl(e));
        }
        return exprs;
    }

    @Override
    public PythonValue constant(long num) {
        return new PythonValueImpl(new PyExpr(Long.toString(num), Integer.MAX_VALUE));
    }

    @Override
    public PythonValue constant(double num) {
        return new PythonValueImpl(new PyExpr(Double.toString(num), Integer.MAX_VALUE));
    }

    @Override
    public PythonValue constant(String str) {
        return new PythonValueImpl(new PyStringExpr("'" + str + "'", Integer.MAX_VALUE));
    }

    @Override
    public PythonValue constant(boolean bool) {
        return new PythonValueImpl(new PyExpr(bool ? "True" : "False", Integer.MAX_VALUE));
    }

    @Override
    public PythonValue constantNull() {
        return new PythonValueImpl(new PyExpr("None", Integer.MAX_VALUE));
    }

    @Override
    public PythonValue global(String globalSymbol) {
        return new PythonValueImpl(new PyExpr(globalSymbol, Integer.MAX_VALUE));
    }

    private static final class PythonValueImpl
    implements PythonValue {
        final PyExpr expr;

        PythonValueImpl(PyExpr expr) {
            this.expr = (PyExpr)Preconditions.checkNotNull((Object)expr);
        }

        @Override
        public PythonValue isNull() {
            return new PythonValueImpl(PyExprUtils.genPyNullCheck(this.expr));
        }

        @Override
        public PythonValue isNonNull() {
            return new PythonValueImpl(PyExprUtils.genPyNotNullCheck(this.expr));
        }

        @Override
        public PythonValue getProp(String ident) {
            return new PythonValueImpl(new PyExpr(PyExprUtils.maybeProtect(this.expr, 9).getText() + "." + ident, 9));
        }

        @Override
        public PythonValue call(PythonValue ... args) {
            StringBuilder sb = new StringBuilder().append(PyExprUtils.maybeProtect(this.expr, 9).getText()).append("(");
            boolean isFirst = true;
            for (PythonValue arg : args) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(PythonValueImpl.unwrap(arg).getText());
            }
            sb.append(")");
            return new PythonValueImpl(new PyExpr(sb.toString(), 9));
        }

        @Override
        public PythonValue plus(PythonValue value) {
            int plusPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.PLUS);
            return new PythonValueImpl(new PyExpr(PyExprUtils.maybeProtect(this.expr, plusPrecedence).getText() + " + " + PyExprUtils.maybeProtect(PythonValueImpl.unwrap(value), plusPrecedence).getText(), plusPrecedence));
        }

        @Override
        public PythonValue coerceToString() {
            return new PythonValueImpl(this.expr.toPyString());
        }

        @Override
        public PythonValue in(PythonValue value) {
            return new PythonValueImpl(new PyExpr(PyExprUtils.maybeProtect(this.expr, 5).getText() + " in " + PyExprUtils.maybeProtect(PythonValueImpl.unwrap(value), 5).getText(), 5));
        }

        @Override
        public PythonValue getItem(PythonValue key) {
            return new PythonValueImpl(new PyExpr(PyExprUtils.maybeProtect(this.expr, 9).getText() + "[" + PythonValueImpl.unwrap(key).getText() + "]", 9));
        }

        @Override
        public PythonValue and(PythonValue value) {
            int andPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.AND);
            return new PythonValueImpl(new PyExpr(PyExprUtils.maybeProtect(this.expr, andPrecedence).getText() + " and " + PyExprUtils.maybeProtect(PythonValueImpl.unwrap(value), andPrecedence).getText(), andPrecedence));
        }

        private static PyExpr unwrap(PythonValue start) {
            return ((PythonValueImpl)start).expr;
        }

        public String toString() {
            return this.expr.getText();
        }
    }
}

