/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.pysrc.restricted.PyExpr;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class LocalVariableStack {
    private final Deque<Map<String, PyExpr>> localVarExprs = new ArrayDeque<Map<String, PyExpr>>();

    LocalVariableStack() {
    }

    void pushFrame() {
        this.localVarExprs.push(new HashMap());
    }

    void popFrame() {
        this.localVarExprs.pop();
    }

    @CanIgnoreReturnValue
    LocalVariableStack addVariable(String name, PyExpr varExpression) {
        Preconditions.checkState((!this.localVarExprs.isEmpty() ? 1 : 0) != 0);
        this.localVarExprs.peek().put(name, varExpression);
        return this;
    }

    @Nullable
    PyExpr getVariableExpression(String variableName) {
        for (Map<String, PyExpr> frame : this.localVarExprs) {
            PyExpr translation = frame.get(variableName);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }
}

