/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.plugin.java.internal.ValidatorFactory;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.types.SoyType;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ValidatorErrorReporter {
    private static final SoyErrorKind INVALID_RETURN_TYPE_WITH_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Return type cannot be represented in Soy.\nMethod: {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_RETURN_TYPE_NO_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Return type cannot be represented in Soy."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_RETURN_TYPE_WITH_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Type mismatch on return type of {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_RETURN_TYPE_NO_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Type mismatch on return type."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAMETER_LENGTH_MISMATCH = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Parameter length mismatch calling {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAM_MISMATCH_ONE = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Type mismatch on the {5} parameter of {6}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAM_MISMATCH_MANY = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedListAndActual("Type mismatch on the {5} parameter of {6}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_PARAM = SoyErrorKind.of(ValidatorErrorReporter.formatWithExpectedAndActual("Passed null to the {5} parameter of {6}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_RETURN = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("{3}.applyForJavaSource returned null."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("Passed a null method to JavaValueFactory.{3}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NULL_VALUES = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("Passed a null JavaValue[] to JavaValueFactory.{3} while trying to call method: {4}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INCOMPATIBLE_TYPES = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("Invalid call to {3}, {4} is incompatible with {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind STATIC_MISMATCH = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("{3} method {4} passed to JavaValueFactory.{5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INTERFACE_MISMATCH = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("MethodSignature.{3} used for a method {4}in an interface. Use MethodSignature.{5} instead."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_PLUGIN_METHOD = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("Can''t find a public method with signature ''{3}''{4} in the plugin''s java deps."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind WRONG_PLUGIN_METHOD_RETURN_TYPE = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("Plugin runtime method {3} returns a {4}, not a {5}."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of(ValidatorErrorReporter.formatPlain("{3}"), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter reporter;
    private final String fnName;
    private final Class<?> fnClass;
    private final SourceLocation sourceLocation;
    private final boolean includeTriggeredInTemplateMsg;

    public ValidatorErrorReporter(ErrorReporter reporter, String fnName, Class<?> fnClass, SourceLocation sourceLocation, boolean includeTriggeredInTemplateMsg) {
        this.reporter = reporter;
        this.fnName = fnName;
        this.fnClass = fnClass;
        this.sourceLocation = sourceLocation;
        this.includeTriggeredInTemplateMsg = includeTriggeredInTemplateMsg;
    }

    private void report(SoyErrorKind error, Object ... additionalArgs) {
        this.reporter.report(this.sourceLocation, error, this.createArgs(additionalArgs));
    }

    private void warn(SoyErrorKind error, Object ... additionalArgs) {
        this.reporter.warn(this.sourceLocation, error, this.createArgs(additionalArgs));
    }

    private Object[] createArgs(Object ... additionalArgs) {
        Object[] args = new Object[additionalArgs.length + 3];
        args[0] = this.fnName;
        args[1] = this.fnClass.getName();
        args[2] = this.includeTriggeredInTemplateMsg ? "\nTriggered by usage in template at:" : "";
        for (int i = 0; i < additionalArgs.length; ++i) {
            args[3 + i] = additionalArgs[i];
        }
        return args;
    }

    ErrorReporter.Checkpoint checkpoint() {
        return this.reporter.checkpoint();
    }

    boolean errorsSince(ErrorReporter.Checkpoint checkpoint) {
        return this.reporter.errorsSince(checkpoint);
    }

    void invalidReturnType(Class<?> actualReturnType, SoyType expectedReturnType, @Nullable MethodSignature method) {
        if (method == null) {
            this.report(INVALID_RETURN_TYPE_NO_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "java type of '" + actualReturnType.getName() + "'");
        } else {
            this.report(INVALID_RETURN_TYPE_WITH_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "java type of '" + actualReturnType.getName() + "'", ValidatorErrorReporter.simpleMethodName(method));
        }
    }

    void incompatibleReturnType(SoyType actualType, SoyType expectedReturnType, @Nullable MethodSignature method) {
        if (method == null) {
            this.report(INCOMPATIBLE_RETURN_TYPE_NO_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "soy type of '" + String.valueOf(actualType) + "'");
        } else {
            this.report(INCOMPATIBLE_RETURN_TYPE_WITH_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "soy type of '" + String.valueOf(actualType) + "'", ValidatorErrorReporter.simpleMethodName(method));
        }
    }

    void incompatibleReturnType(Class<?> actualJavaType, SoyType expectedReturnType, @Nullable MethodSignature method) {
        if (method == null) {
            this.report(INCOMPATIBLE_RETURN_TYPE_NO_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "java type of '" + actualJavaType.getName() + "'");
        } else {
            this.report(INCOMPATIBLE_RETURN_TYPE_WITH_METHOD, "soy type of '" + String.valueOf(expectedReturnType) + "'", "java type of '" + actualJavaType.getName() + "'", ValidatorErrorReporter.simpleMethodName(method));
        }
    }

    void invalidParameterLength(MethodSignature method, JavaValue[] actualParams) {
        String expected = method.arguments().size() == 1 ? "1 parameter" : method.arguments().size() + " parameters";
        String actual = actualParams.length == 1 ? "1 parameter" : actualParams.length + " parameters";
        this.report(PARAMETER_LENGTH_MISMATCH, expected, actual, ValidatorErrorReporter.simpleMethodName(method));
    }

    void invalidParameterType(MethodSignature method, int paramIdx, Class<?> actualParamType, Class<?> expectedClass) {
        this.report(PARAM_MISMATCH_ONE, "'" + expectedClass.getName() + "'", "'" + actualParamType.getName() + "'", paramIdx + 1 + ValidatorErrorReporter.getOrdinalSuffix(paramIdx + 1), ValidatorErrorReporter.simpleMethodName(method));
    }

    void invalidParameterType(MethodSignature method, int paramIdx, Class<?> expectedType, ValidatorFactory.ValidationResult result) {
        switch (result.result()) {
            case VALID: {
                throw new IllegalStateException("unexpected valid result");
            }
            case INVALID: {
                Object expected;
                SoyErrorKind msg;
                if (result.allowedTypes().size() == 1) {
                    msg = PARAM_MISMATCH_ONE;
                    expected = "'" + (String)Iterables.getOnlyElement(result.allowedTypes()) + "'";
                } else {
                    msg = PARAM_MISMATCH_MANY;
                    expected = result.allowedTypes().stream().collect(Collectors.joining("'\n          '", "\n          '", "'"));
                }
                this.report(msg, expected, "'" + expectedType.getName() + "'", paramIdx + 1 + ValidatorErrorReporter.getOrdinalSuffix(paramIdx + 1), ValidatorErrorReporter.simpleMethodName(method));
                break;
            }
            case NULL_TO_PRIMITIVE: {
                this.report(PARAM_MISMATCH_ONE, "a nullable soy type ('" + String.valueOf(result.allowedSoyType()) + "')", "primitive type '" + expectedType.getName() + "'", paramIdx + 1 + ValidatorErrorReporter.getOrdinalSuffix(paramIdx + 1), ValidatorErrorReporter.simpleMethodName(method));
            }
        }
    }

    void nonSoyExpressionNotConvertible(Class<?> actualClass, SoyType newType, String methodName) {
        this.report(INCOMPATIBLE_TYPES, methodName, "java type of '" + actualClass.getName() + "'", "soy type of '" + String.valueOf(newType) + "'");
    }

    void nonSoyExpressionNotCoercible(Class<?> actualClass, SoyType newType, String methodName) {
        this.report(INCOMPATIBLE_TYPES, methodName, "java type of '" + actualClass.getName() + "'", "soy type of '" + String.valueOf(newType) + "'");
    }

    void incompatibleSoyType(SoyType allowedType, SoyType newType, String methodName) {
        this.report(INCOMPATIBLE_TYPES, methodName, "soy type of '" + String.valueOf(allowedType) + "'", "soy type of '" + String.valueOf(newType) + "'");
    }

    void nullReturn() {
        this.report(NULL_RETURN, this.fnClass.getSimpleName());
    }

    void nullMethod(String methodName) {
        this.report(NULL_METHOD, methodName);
    }

    void nullParamArray(MethodSignature method, String methodName) {
        this.report(NULL_VALUES, methodName, ValidatorErrorReporter.simpleMethodName(method));
    }

    void nullParam(MethodSignature method, int paramIdx, Class<?> expectedType) {
        this.report(NULL_PARAM, "'" + expectedType.getName() + "'", "null", paramIdx + ValidatorErrorReporter.getOrdinalSuffix(paramIdx), ValidatorErrorReporter.simpleMethodName(method));
    }

    void staticMismatch(MethodSignature method, boolean expectedInstance) {
        String actual;
        String expected;
        if (expectedInstance) {
            expected = "callInstanceMethod";
            actual = "Static";
        } else {
            expected = "callStaticMethod";
            actual = "Instance";
        }
        this.report(STATIC_MISMATCH, actual, ValidatorErrorReporter.simpleMethodName(method), expected);
    }

    void interfaceMismatch(MethodSignature method) {
        String correctMethod;
        String maybeNot;
        String userMethod;
        if (method.inInterface()) {
            userMethod = "createInterfaceMethod";
            maybeNot = "not ";
            correctMethod = "create";
        } else {
            userMethod = "create";
            maybeNot = "";
            correctMethod = "createInterfaceMethod";
        }
        this.report(INTERFACE_MISMATCH, userMethod, maybeNot, correctMethod);
    }

    void invalidPluginMethod(MethodSignature method) {
        String signature = String.format("%s.%s(%s)", method.fullyQualifiedClassName(), method.methodName(), method.arguments().stream().map(Class::getName).collect(Collectors.joining(", ")));
        this.report(INVALID_PLUGIN_METHOD, signature, method.arguments().isEmpty() ? " (with no parameters)" : "");
    }

    void wrongPluginMethodReturnType(String actualReturnType, MethodSignature expectedMethod) {
        this.report(WRONG_PLUGIN_METHOD_RETURN_TYPE, ValidatorErrorReporter.simpleMethodName(expectedMethod), actualReturnType, expectedMethod.returnType().getName());
    }

    void unexpectedError(Throwable t) {
        this.report(UNEXPECTED_ERROR, Throwables.getStackTraceAsString((Throwable)t));
    }

    private static String formatPlain(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\nPlugin implementation: {1}{2}";
    }

    private static String formatWithExpectedAndActual(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\n  expected: {3}\n  actual:   {4}\nPlugin implementation: {1}{2}";
    }

    private static String formatWithExpectedListAndActual(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\n  expected one of:{3}\n  actual: {4}\nPlugin implementation: {1}{2}";
    }

    private static String simpleMethodName(MethodSignature method) {
        return "'" + method.fullyQualifiedClassName() + "." + method.methodName() + "'";
    }

    private static String getOrdinalSuffix(int ordinal) {
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0);
        if (ordinal / 10 % 10 == 1) {
            return "th";
        }
        switch (ordinal % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public void wrapErrors(Iterable<SoyError> errors) {
        errors.forEach(e -> this.report(UNEXPECTED_ERROR, e.message()));
    }

    public void wrapWarnings(Iterable<SoyError> warnings) {
        warnings.forEach(e -> this.warn(UNEXPECTED_ERROR, e.message()));
    }
}

