/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.plugin.java.ReadMethodData;
import com.google.template.soy.plugin.java.internal.AbstractMethodChecker;
import com.google.template.soy.plugin.java.internal.AutoValue_CompiledJarsPluginSignatureReader_PartialSignature;
import com.google.template.soy.plugin.java.internal.PluginSignatureReader;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CompiledJarsPluginSignatureReader
implements PluginSignatureReader,
MethodChecker {
    private static final Logger logger = Logger.getLogger(CompiledJarsPluginSignatureReader.class.getName());
    private final ImmutableList<File> pluginRuntimeJars;
    private final ConcurrentMap<String, ClassSignatures> readMethodsPerClass;
    private final boolean allowReflection;

    public CompiledJarsPluginSignatureReader(List<File> pluginRuntimeJars, boolean allowReflection) {
        this.pluginRuntimeJars = ImmutableList.copyOf(pluginRuntimeJars);
        this.readMethodsPerClass = new ConcurrentHashMap<String, ClassSignatures>();
        this.allowReflection = allowReflection;
    }

    @Override
    @Nullable
    public ReadMethodData findMethod(MethodSignature methodSignature) {
        String className = methodSignature.fullyQualifiedClassName();
        ClassSignatures readMethods = this.readMethodsPerClass.computeIfAbsent(className, k -> this.index((String)k, null));
        MethodSignatures methodsForSig = readMethods.forPartial(PartialSignature.create(methodSignature));
        if (methodsForSig.hasReturnType(methodSignature.returnType().getName())) {
            return methodsForSig.forReturnType(methodSignature.returnType().getName());
        }
        if (!methodsForSig.isEmpty()) {
            return methodsForSig.allSignatures().iterator().next();
        }
        return null;
    }

    @Override
    public MethodChecker.Response findMethod(String className, String methodName, String returnType, List<String> arguments) {
        return new AbstractMethodChecker(){

            @Override
            protected ClassSignatures getSignatures(String className) {
                return CompiledJarsPluginSignatureReader.this.readMethodsPerClass.computeIfAbsent(className, k -> CompiledJarsPluginSignatureReader.this.index((String)k, s -> {}));
            }
        }.findMethod(className, methodName, returnType, arguments);
    }

    public static boolean hasMatchingMethod(ClassSignatures signature, String methodName, String returnType, List<String> arguments) {
        MethodSignatures methodsForSig = signature.forPartial(PartialSignature.create(methodName, (ImmutableList<String>)ImmutableList.copyOf(arguments)));
        if (methodsForSig.hasReturnType(returnType)) {
            return true;
        }
        if (!methodsForSig.isEmpty()) {
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ClassSignatures index(String runtimeClassName, Consumer<String> errorReporter) {
        String ownerName = TypeInfo.create(runtimeClassName, false).internalName();
        for (File f : this.pluginRuntimeJars) {
            try (ZipFile jar = new ZipFile(f);){
                ClassSignatures classSignatures;
                block17: {
                    ZipEntry entry = jar.getEntry(ownerName + ".class");
                    if (entry == null) continue;
                    InputStream in = jar.getInputStream(entry);
                    try {
                        ClassReader reader = new ClassReader(in);
                        Visitor visitor = new Visitor();
                        reader.accept((ClassVisitor)visitor, 7);
                        classSignatures = visitor.signatures.build();
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return classSignatures;
            }
            catch (IOException | UnsupportedOperationException e) {
                if (errorReporter != null) {
                    errorReporter.accept("Unable to read class: " + runtimeClassName);
                    continue;
                }
                logger.log(Level.WARNING, e, () -> "Unable to read class: " + runtimeClassName);
            }
        }
        if (this.allowReflection) {
            return CompiledJarsPluginSignatureReader.indexReflectively(runtimeClassName);
        }
        return ClassSignatures.EMPTY;
    }

    public static ClassSignatures indexReflectively(String runtimeClassName) {
        try {
            Class<?> clazz = Class.forName(runtimeClassName);
            boolean classIsPublic = Modifier.isPublic(clazz.getModifiers());
            Method[] declaredMethods = clazz.getDeclaredMethods();
            ClassSignatures.Builder signatures = new ClassSignatures.Builder();
            for (Method m : declaredMethods) {
                signatures.add(PartialSignature.create(m), ReadMethodData.create(classIsPublic && Modifier.isPublic(m.getModifiers()), !Modifier.isStatic(m.getModifiers()), clazz.isInterface(), m.getReturnType().getName()));
            }
            return signatures.build();
        }
        catch (ClassNotFoundException | SecurityException e) {
            return ClassSignatures.EMPTY;
        }
    }

    @AutoValue
    static abstract class PartialSignature {
        PartialSignature() {
        }

        abstract String methodName();

        abstract ImmutableList<String> arguments();

        public final String toString() {
            return this.methodName() + "(" + String.join((CharSequence)", ", this.arguments()) + ")";
        }

        static PartialSignature create(Method method) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(method.getName(), (ImmutableList<String>)((ImmutableList)Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(ImmutableList.toImmutableList())));
        }

        static PartialSignature create(String methodName, ImmutableList<String> arguments) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(methodName, arguments);
        }

        static PartialSignature create(MethodSignature methodSignature) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(methodSignature.methodName(), (ImmutableList<String>)((ImmutableList)methodSignature.arguments().stream().map(Class::getName).collect(ImmutableList.toImmutableList())));
        }

        static PartialSignature create(String methodName, Type methodType) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(methodName, (ImmutableList<String>)((ImmutableList)Arrays.stream(methodType.getArgumentTypes()).map(Type::getClassName).collect(ImmutableList.toImmutableList())));
        }
    }

    static class MethodSignatures {
        static final MethodSignatures EMPTY = new Builder().build();
        final ImmutableMap<String, ReadMethodData> signaturesPerReturnType;

        MethodSignatures(Builder builder) {
            this.signaturesPerReturnType = builder.signaturesBuilder.build();
        }

        Iterable<ReadMethodData> allSignatures() {
            return this.signaturesPerReturnType.values();
        }

        boolean isEmpty() {
            return this.signaturesPerReturnType.isEmpty();
        }

        ReadMethodData forReturnType(String type) {
            return (ReadMethodData)this.signaturesPerReturnType.get((Object)type);
        }

        boolean hasReturnType(String type) {
            return this.signaturesPerReturnType.containsKey((Object)type);
        }

        ImmutableSet<String> returnTypes() {
            return this.signaturesPerReturnType.keySet();
        }

        static class Builder {
            final ImmutableMap.Builder<String, ReadMethodData> signaturesBuilder = ImmutableMap.builder();

            Builder() {
            }

            void add(ReadMethodData data) {
                this.signaturesBuilder.put((Object)data.returnType(), (Object)data);
            }

            MethodSignatures build() {
                return new MethodSignatures(this);
            }
        }
    }

    public static class ClassSignatures {
        public static final ClassSignatures EMPTY = new Builder().build();
        final ImmutableMap<PartialSignature, MethodSignatures> methods;

        ClassSignatures(Builder builder) {
            this.methods = (ImmutableMap)builder.methodsBuilder.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((MethodSignatures.Builder)e.getValue()).build()));
        }

        public MethodSignatures forPartial(PartialSignature partial) {
            return (MethodSignatures)this.methods.getOrDefault((Object)partial, (Object)MethodSignatures.EMPTY);
        }

        public ImmutableSet<PartialSignature> allPartials() {
            return this.methods.keySet();
        }

        static class Builder {
            final Map<PartialSignature, MethodSignatures.Builder> methodsBuilder = new LinkedHashMap<PartialSignature, MethodSignatures.Builder>();

            Builder() {
            }

            @CanIgnoreReturnValue
            Builder add(PartialSignature partialSig, ReadMethodData data) {
                this.methodsBuilder.computeIfAbsent(partialSig, k -> new MethodSignatures.Builder()).add(data);
                return this;
            }

            ClassSignatures build() {
                return new ClassSignatures(this);
            }
        }
    }

    private static class Visitor
    extends ClassVisitor {
        final ClassSignatures.Builder signatures = new ClassSignatures.Builder();
        boolean classIsInterface;
        boolean classIsPublic;

        Visitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classIsInterface = Modifier.isInterface(access);
            this.classIsPublic = Modifier.isPublic(access);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            Type methodType = Type.getMethodType((String)descriptor);
            this.signatures.add(PartialSignature.create(name, methodType), ReadMethodData.create(this.classIsPublic && Modifier.isPublic(access), !Modifier.isStatic(access), this.classIsInterface, methodType.getReturnType().getClassName()));
            return null;
        }
    }
}

