/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes.htmlmatcher;

import com.google.common.base.Preconditions;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HtmlMatcherBlockNode
extends HtmlMatcherGraphNode {
    private final HtmlMatcherGraph graph;
    private final String parentBlockType;
    @Nullable
    private HtmlMatcherGraphNode nextNode;

    public HtmlMatcherBlockNode(HtmlMatcherGraph graph, String parentBlockType) {
        this.graph = graph;
        this.parentBlockType = parentBlockType;
    }

    public HtmlMatcherGraph getGraph() {
        return this.graph;
    }

    public String getParentBlockType() {
        return this.parentBlockType;
    }

    @Override
    public Optional<SoyNode> getSoyNode() {
        return Optional.empty();
    }

    @Override
    public Optional<HtmlMatcherGraphNode> getNodeForEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        if (edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE) {
            return Optional.ofNullable(this.nextNode);
        }
        return Optional.empty();
    }

    @Override
    public void setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind edgeKind) {
        throw new UnsupportedOperationException("Cannot set the edge kind of a Block node.");
    }

    @Override
    public void linkEdgeToNode(HtmlMatcherGraphNode.EdgeKind edgeKind, HtmlMatcherGraphNode node) {
        Preconditions.checkState((edgeKind == HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE ? 1 : 0) != 0, (Object)"HTML Block nodes only have a true branch.");
        Preconditions.checkState((!this.equals(node) ? 1 : 0) != 0, (Object)"Can't link a node to itsself.");
        Preconditions.checkNotNull((Object)node);
        this.nextNode = node;
    }
}

