/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

@RunAfter(value={RewriteGlobalsPass.class})
public final class XidPass
implements CompilerFilePass {
    private static final SoyErrorKind STRING_OR_GLOBAL_REQUIRED = SoyErrorKind.of("Argument to function ''xid'' must be a string literal or a (possibly) dotted identifier.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter reporter;

    XidPass(ErrorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allFunctionInvocations(file, BuiltinFunction.XID).forEach(fn -> {
            if (fn.numParams() != 1) {
                return;
            }
            ExprNode child = fn.getParam(0);
            switch (child.getKind()) {
                case GLOBAL_NODE: {
                    GlobalNode global = (GlobalNode)child;
                    String xid = global.getName();
                    fn.replaceChild(0, (ExprNode)new StringNode(xid, QuoteStyle.SINGLE, global.getSourceLocation()));
                    break;
                }
                case VAR_REF_NODE: 
                case FIELD_ACCESS_NODE: {
                    String source = child.toSourceString();
                    if (!BaseUtils.isDottedIdentifier(source) || source.startsWith("$")) {
                        this.reporter.report(child.getSourceLocation(), STRING_OR_GLOBAL_REQUIRED, new Object[0]);
                        break;
                    }
                    String expanded = file.resolveAlias(Identifier.create(source, SourceLocation.UNKNOWN)).identifier();
                    fn.replaceChild(0, (ExprNode)new StringNode(expanded, QuoteStyle.SINGLE, child.getSourceLocation()));
                    break;
                }
                case STRING_NODE: {
                    break;
                }
                default: {
                    this.reporter.report(child.getSourceLocation(), STRING_OR_GLOBAL_REQUIRED, new Object[0]);
                }
            }
        });
    }
}

