/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.templatecall.TemplateCallMetadata;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@RunAfter(value={ResolveTemplateNamesPass.class, ResolveExpressionTypesPass.class})
final class TemplateCallMetadataPass
implements CompilerFileSetPass {
    private ErrorReporter errorReporter;

    TemplateCallMetadataPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator nodeIdGen) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.CONTINUE;
        }
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getTemplates()) {
                List shortFormCalls = (List)SoyTreeUtils.getAllNodesOfType(template, PrintNode.class).stream().map(TemplateCallMetadataPass::parseShortFormTemplateCallAndElementComposition).flatMap(Streams::stream).collect(ImmutableList.toImmutableList());
                template.setTemplateCallMetadata(TemplateCallMetadata.Template.newBuilder().setName(this.getTemplateName(template)).setModname(Strings.nullToEmpty((String)template.getModName())).addAllCalls((Iterable)SoyTreeUtils.getAllNodesOfType(template, CallNode.class).stream().map(TemplateCallMetadataPass::calculateTemplateCall).collect(ImmutableList.toImmutableList())).addAllCalls(shortFormCalls).build());
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private String getTemplateName(TemplateNode template) {
        if (!(template instanceof TemplateBasicNode)) {
            return template.getTemplateName();
        }
        TemplateBasicNode basicNode = (TemplateBasicNode)template;
        if (basicNode.getModifiesExpr() != null && basicNode.getModifiesExpr().getRoot() instanceof TemplateLiteralNode) {
            TemplateLiteralNode literal = (TemplateLiteralNode)basicNode.getModifiesExpr().getRoot();
            return literal.getResolvedName();
        }
        return template.getTemplateName();
    }

    private static Optional<TemplateCallMetadata.TemplateCall> parseShortFormTemplateCallAndElementComposition(PrintNode printNode) {
        if (printNode.getExpr().getRoot() instanceof FunctionNode) {
            FunctionNode fnNode = (FunctionNode)printNode.getExpr().getRoot();
            if (!fnNode.allowedToInvokeAsFunction() || fnNode.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
                return Optional.empty();
            }
            if (fnNode.getNameExpr() instanceof TemplateLiteralNode) {
                TemplateLiteralNode templateLiteralNode = (TemplateLiteralNode)fnNode.getNameExpr();
                TemplateCallMetadata.TemplateCall.Builder templateCall = TemplateCallMetadata.TemplateCall.newBuilder().addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)TemplateCallMetadataPass.getFunctionParams(fnNode.getParamNames(), fnNode.getParams()));
                return Optional.of(templateCall.setDestTemplateName(templateLiteralNode.getResolvedName()).build());
            }
            TemplateType templateType = SoyTypes.getTemplateType(fnNode.getNameExpr().getType());
            if (templateType == null) {
                return Optional.empty();
            }
            TemplateCallMetadata.TemplateCall.Builder templateCall = TemplateCallMetadata.TemplateCall.newBuilder().addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)TemplateCallMetadataPass.getFunctionParams(fnNode.getParamNames(), fnNode.getParams()));
            return TemplateCallMetadataPass.resolveVarRefTemplateCall((VarRefNode)fnNode.getNameExpr(), templateCall);
        }
        return TemplateCallMetadataPass.resolveTemplateReference(printNode.getExpr().getRoot());
    }

    private static TemplateCallMetadata.TemplateCall calculateTemplateCall(CallNode templateCallNode) {
        Optional<TemplateCallMetadata.TemplateCall> boundTemplateCall;
        ExprNode exprNode;
        ImmutableList callParamArgs = (ImmutableList)templateCallNode.getChildren().stream().map(TemplateCallMetadataPass::createParamArg).collect(ImmutableList.toImmutableList());
        if (templateCallNode.getKind() == SoyNode.Kind.CALL_BASIC_NODE && (TemplateCallMetadataPass.isBindStatement(exprNode = ((CallBasicNode)templateCallNode).getCalleeExpr().getRoot()) || exprNode.getKind() == ExprNode.Kind.VAR_REF_NODE) && (boundTemplateCall = TemplateCallMetadataPass.resolveTemplateReference(exprNode)).isPresent()) {
            return TemplateCallMetadata.TemplateCall.newBuilder(boundTemplateCall.get()).addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)callParamArgs).build();
        }
        TemplateCallMetadata.TemplateCall.Builder templateCallMetaData = TemplateCallMetadata.TemplateCall.newBuilder().setDestTemplateName(TemplateCallMetadataPass.getDestTemplateName(templateCallNode)).setIsDelcall(templateCallNode.getKind() == SoyNode.Kind.CALL_DELEGATE_NODE).setIsModifiableCall(TemplateCallMetadataPass.isModifiableCall(templateCallNode)).addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)callParamArgs);
        if (templateCallNode.isPassingAllData()) {
            templateCallMetaData.setIsPassingAllData(true);
        } else if (templateCallNode.getDataExpr() != null) {
            templateCallMetaData.setDataArg(TemplateCallMetadataPass.resolveLocalVarRefToParamRef(templateCallNode.getDataExpr().getRoot(), TemplateCallMetadata.VarRefInfo.newBuilder()));
        }
        return templateCallMetaData.build();
    }

    private static boolean isModifiableCall(CallNode call) {
        if (!(call instanceof CallBasicNode)) {
            return false;
        }
        CallBasicNode callBasicNode = (CallBasicNode)call;
        if (!(callBasicNode.getCalleeExpr().getRoot().getType() instanceof TemplateType)) {
            return false;
        }
        return ((TemplateType)callBasicNode.getCalleeExpr().getRoot().getType()).isModifiable();
    }

    private static Optional<TemplateCallMetadata.TemplateCall> resolveTemplateReference(ExprNode exprNode) {
        if (exprNode instanceof TemplateLiteralNode) {
            String destTemplateName = ((TemplateLiteralNode)exprNode).getResolvedName();
            return Optional.of(TemplateCallMetadata.TemplateCall.newBuilder().setDestTemplateName(destTemplateName).build());
        }
        if (exprNode.getKind() == ExprNode.Kind.VAR_REF_NODE) {
            VarRefNode varRefNode = (VarRefNode)exprNode;
            return TemplateCallMetadataPass.resolveVarRefTemplateCall(varRefNode, TemplateCallMetadata.TemplateCall.newBuilder());
        }
        if (!TemplateCallMetadataPass.isBindStatement(exprNode)) {
            return Optional.empty();
        }
        MethodCallNode bind = (MethodCallNode)exprNode;
        ExprNode bindCaller = bind.getChild(0);
        TemplateCallMetadata.TemplateCall.Builder templateCall = TemplateCallMetadata.TemplateCall.newBuilder().addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)TemplateCallMetadataPass.getBoundTemplateParams(bind)).setIsDelcall(false);
        if (bindCaller.getKind() == ExprNode.Kind.VAR_REF_NODE) {
            VarRefNode varRefNode = (VarRefNode)bindCaller;
            return TemplateCallMetadataPass.resolveVarRefTemplateCall(varRefNode, templateCall);
        }
        String destTemplateName = ((TemplateLiteralNode)bindCaller).getResolvedName();
        return Optional.of(templateCall.setDestTemplateName(destTemplateName).build());
    }

    private static Optional<TemplateCallMetadata.TemplateCall> resolveVarRefTemplateCall(VarRefNode varRefNode, TemplateCallMetadata.TemplateCall.Builder templateCallInfo) {
        SoyNode.LocalVarNode localVarDefn;
        VarDefn varDefn;
        if (templateCallInfo.getDestTemplateName().isEmpty()) {
            templateCallInfo.setDestTemplateName(varRefNode.getName());
        }
        if ((varDefn = varRefNode.getDefnDecl()).kind() == VarDefn.Kind.PARAM && (varDefn.type().getKind() == SoyType.Kind.TEMPLATE_TYPE || varDefn.type().getKind() == SoyType.Kind.TEMPLATE)) {
            return Optional.of(templateCallInfo.setSourceParam(varDefn.name()).build());
        }
        if (varDefn.kind() == VarDefn.Kind.LOCAL_VAR && (localVarDefn = (SoyNode.LocalVarNode)((LocalVar)varDefn).declaringNode()) instanceof LetValueNode) {
            ExprNode letExpression = ((LetValueNode)localVarDefn).getExpr().getRoot();
            if (letExpression.getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE) {
                return Optional.of(templateCallInfo.setSourceTemplate(((TemplateLiteralNode)letExpression).getResolvedName()).build());
            }
            if (TemplateCallMetadataPass.isBindStatement(letExpression)) {
                templateCallInfo.addAllParamArgs((Iterable<? extends TemplateCallMetadata.ParamArg>)TemplateCallMetadataPass.getBoundTemplateParams((MethodCallNode)letExpression));
                ExprNode bindCaller = ((MethodCallNode)letExpression).getChild(0);
                if (bindCaller.getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE) {
                    return Optional.of(templateCallInfo.setSourceTemplate(((TemplateLiteralNode)bindCaller).getResolvedName()).build());
                }
                if (bindCaller.getKind() == ExprNode.Kind.VAR_REF_NODE) {
                    return TemplateCallMetadataPass.resolveVarRefTemplateCall((VarRefNode)bindCaller, templateCallInfo);
                }
            }
        }
        return Optional.empty();
    }

    private static TemplateCallMetadata.ParamArg createParamArg(CallParamNode callParamNode) {
        if (!(callParamNode instanceof CallParamValueNode)) {
            return TemplateCallMetadata.ParamArg.newBuilder().setKey(callParamNode.getKey().identifier()).build();
        }
        ExprNode possibleParamRefExpr = ((CallParamValueNode)callParamNode).getExpr().getRoot();
        return TemplateCallMetadataPass.resolveParam(callParamNode.getKey().identifier(), possibleParamRefExpr);
    }

    private static TemplateCallMetadata.ParamArg resolveParam(String key, ExprNode valueExpr) {
        Optional<TemplateCallMetadata.TemplateCall> boundTemplate;
        TemplateCallMetadata.ParamArg.Builder paramArg = TemplateCallMetadata.ParamArg.newBuilder().setKey(key);
        TemplateCallMetadata.VarRefInfo varRefInfo = TemplateCallMetadataPass.resolveLocalVarRefToParamRef(valueExpr, TemplateCallMetadata.VarRefInfo.newBuilder());
        if (varRefInfo.getHeaderParam().isEmpty() && (boundTemplate = TemplateCallMetadataPass.resolveTemplateReference(valueExpr)).isPresent()) {
            return paramArg.setBoundTemplate(boundTemplate.get()).build();
        }
        return paramArg.setVarRef(varRefInfo).build();
    }

    private static ImmutableList<TemplateCallMetadata.ParamArg> getFunctionParams(List<Identifier> keys, List<ExprNode> values) {
        ArrayList callParamArgs = Lists.newArrayList();
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Both keys and values must be the same size");
        }
        for (int i = 0; i < keys.size(); ++i) {
            callParamArgs.add(TemplateCallMetadataPass.resolveParam(keys.get(i).identifier(), values.get(i)));
        }
        return ImmutableList.copyOf((Collection)callParamArgs);
    }

    private static ImmutableList<TemplateCallMetadata.ParamArg> getBoundTemplateParams(MethodCallNode bind) {
        ExprNode possibleBindParams = bind.getParam(0);
        if (possibleBindParams.getKind() != ExprNode.Kind.RECORD_LITERAL_NODE) {
            return ImmutableList.of();
        }
        RecordLiteralNode recordLiteralNode = (RecordLiteralNode)possibleBindParams;
        List<ExprNode> bindExprs = recordLiteralNode.getChildren();
        return TemplateCallMetadataPass.getFunctionParams(recordLiteralNode.getKeys(), bindExprs);
    }

    private static TemplateCallMetadata.VarRefInfo resolveLocalVarRefToParamRef(ExprNode varExpr, TemplateCallMetadata.VarRefInfo.Builder varRefInfo) {
        if (varExpr.getKind() == ExprNode.Kind.VAR_REF_NODE) {
            VarDefn possibleParamRefDef = ((VarRefNode)varExpr).getDefnDecl();
            if (possibleParamRefDef.kind() == VarDefn.Kind.PARAM) {
                varRefInfo.setHeaderParam(possibleParamRefDef.name());
                return varRefInfo.build();
            }
            if (possibleParamRefDef.kind() == VarDefn.Kind.LOCAL_VAR) {
                SoyNode.LocalVarNode varRefNode = (SoyNode.LocalVarNode)((LocalVar)possibleParamRefDef).declaringNode();
                if (varRefNode.getKind() == SoyNode.Kind.FOR_NONEMPTY_NODE) {
                    varRefInfo.setUsesListIndex(true);
                    return TemplateCallMetadataPass.resolveLocalVarRefToParamRef(((ForNonemptyNode)varRefNode).getExpr().getRoot(), varRefInfo);
                }
                if (varRefNode instanceof LetValueNode) {
                    return TemplateCallMetadataPass.resolveLocalVarRefToParamRef(((LetValueNode)varRefNode).getExpr().getRoot(), varRefInfo);
                }
            }
        } else {
            if (varExpr.getKind() == ExprNode.Kind.ITEM_ACCESS_NODE) {
                varRefInfo.setUsesListIndex(true);
                return TemplateCallMetadataPass.resolveLocalVarRefToParamRef(((ItemAccessNode)varExpr).getBaseExprChild(), varRefInfo);
            }
            if (varExpr.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                FieldAccessNode fieldAccessNode = (FieldAccessNode)varExpr;
                varRefInfo.setDataAccessAlias(fieldAccessNode.getFieldName());
                return TemplateCallMetadataPass.resolveLocalVarRefToParamRef(fieldAccessNode.getBaseExprChild(), varRefInfo);
            }
            if (varExpr.getKind() == ExprNode.Kind.FUNCTION_NODE && "checkNotNull".equals(((FunctionNode)varExpr).getFunctionName())) {
                return TemplateCallMetadataPass.resolveLocalVarRefToParamRef(((FunctionNode)varExpr).getParam(0), varRefInfo);
            }
        }
        return varRefInfo.build();
    }

    private static boolean isBindStatement(ExprNode exprNode) {
        return exprNode.getKind() == ExprNode.Kind.METHOD_CALL_NODE && ((MethodCallNode)exprNode).getMethodName().identifier().equals("bind");
    }

    private static String getDestTemplateName(CallNode callNode) {
        switch (callNode.getKind()) {
            case CALL_BASIC_NODE: {
                CallBasicNode basicNode = (CallBasicNode)callNode;
                return basicNode.isStaticCall() ? basicNode.getCalleeName() : basicNode.getCalleeExpr().toSourceString();
            }
            case CALL_DELEGATE_NODE: {
                return ((CallDelegateNode)callNode).getDelCalleeName();
            }
        }
        throw new IllegalStateException("Unknown CallNode kind");
    }
}

