/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basicfunctions.BasicFunctions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.DesugarStateNodesPass;
import com.google.template.soy.passes.ElementAttributePass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UndefinedType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RunAfter(value={ResolveExpressionTypesPass.class, FinalizeTemplateRegistryPass.class})
final class SoyElementCompositionPass
implements CompilerFileSetPass {
    private static final SoyErrorKind ILLEGAL_CHILD = SoyErrorKind.of("Only HTML attributes are allowed as children of this template call.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_ATTRIBUTE = SoyErrorKind.of("Attribute specified multiple times.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SKIP_NODE_NOT_ALLOWED = SoyErrorKind.of("Skip nodes are not allowed on this template call.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXTRA_ATTRIBUTES_NOT_ALLOWED = SoyErrorKind.of("The called template does not specify '''{'attribute *'}''' so only static HTML attributes are allowed.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ImmutableList<? extends SoyPrintDirective> printDirectives;
    private final Supplier<FileSetMetadata> templateRegistryFull;
    private final boolean desugarIdomFeatures;

    SoyElementCompositionPass(ErrorReporter errorReporter, ImmutableList<? extends SoyPrintDirective> printDirectives, Supplier<FileSetMetadata> templateRegistryFull, boolean desugarIdomFeatures) {
        this.errorReporter = errorReporter;
        this.printDirectives = printDirectives;
        this.templateRegistryFull = templateRegistryFull;
        this.desugarIdomFeatures = desugarIdomFeatures;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.CONTINUE;
        }
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            for (HtmlTagNode tagNode : SoyTreeUtils.getAllNodesOfType(template, HtmlTagNode.class)) {
                this.process(template, tagNode, nodeIdGen);
            }
        }
    }

    private void process(TemplateNode template, HtmlTagNode tagNode, IdGenerator nodeIdGen) {
        TagName name = tagNode.getTagName();
        if (name.isStatic()) {
            return;
        }
        PrintNode printNode = name.getDynamicTagName();
        if (!tagNode.getTagName().isTemplateCall()) {
            return;
        }
        Preconditions.checkState((tagNode.getTaggedPairs().size() <= 1 ? 1 : 0) != 0);
        SourceLocation unknown = template.getSourceLocation().clearRange();
        ImmutableMap attrs = (ImmutableMap)template.getAllParams().stream().filter(AttrParam.class::isInstance).map(AttrParam.class::cast).collect(ImmutableMap.toImmutableMap(AbstractVarDefn::name, Function.identity()));
        SourceLocation location = tagNode.getSourceLocation();
        if (!tagNode.getTaggedPairs().isEmpty()) {
            location = location.extend(tagNode.getTaggedPairs().get(0).getSourceLocation());
        }
        CallBasicNode call = new CallBasicNode(nodeIdGen.genId(), location, unknown, printNode.getExpr().getRoot().copy(new CopyState()), (List<CommandTagAttribute>)ImmutableList.of(), false, this.errorReporter);
        if (tagNode instanceof HtmlOpenTagNode) {
            HtmlOpenTagNode openTagNode = (HtmlOpenTagNode)tagNode;
            ContextualAutoescaper.annotateAndRewriteHtmlTag(openTagNode, this.templateRegistryFull.get(), nodeIdGen, this.errorReporter, this.printDirectives);
            if (this.desugarIdomFeatures) {
                Optional<TemplateParam> keyParam = template.getParams().stream().filter(p -> p.name().equals("ssk")).findFirst();
                AbstractExprNode expr = openTagNode.getKeyNode() == null ? (keyParam.isPresent() ? new VarRefNode("$" + keyParam.get().name(), SourceLocation.UNKNOWN, keyParam.get()) : null) : DesugarStateNodesPass.extractKeyFunctionFromHtmlTag(openTagNode);
                if (expr != null) {
                    call.addChild(new CallParamValueNode(nodeIdGen.genId(), openTagNode.getSourceLocation(), Identifier.create("ssk", openTagNode.getSourceLocation()), expr));
                }
            }
        }
        TemplateType templateType = (TemplateType)call.getCalleeExpr().getRoot().getType();
        CallParamContentNode attributesNode = new CallParamContentNode(nodeIdGen.genId(), location, SourceLocation.UNKNOWN, Identifier.create("extraRootElementAttributes", SourceLocation.UNKNOWN), new CommandTagAttribute(Identifier.create("kind", SourceLocation.UNKNOWN), QuoteStyle.SINGLE, "attributes", SourceLocation.UNKNOWN, SourceLocation.UNKNOWN), this.errorReporter);
        if (!tagNode.getTaggedPairs().isEmpty()) {
            HtmlTagNode closeTag = tagNode.getTaggedPairs().get(0);
            List params = templateType.getParameters().stream().filter(p -> SoyTypes.transitivelyContainsKind(p.getType(), SoyType.Kind.HTML)).map(TemplateType.Parameter::getName).collect(Collectors.toCollection(ArrayList::new));
            SoyNode.StandaloneNode next = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(tagNode);
            if (params.size() != 1 || next instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)next).isSlot()) {
                while (next != closeTag) {
                    if ((next = this.consumeSlot(call, next, nodeIdGen)) != null) continue;
                    return;
                }
            } else if (params.size() == 1) {
                CallParamContentNode callParamContent = new CallParamContentNode(nodeIdGen.genId(), unknown, unknown, Identifier.create((String)params.get(0), unknown), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, "html", unknown, unknown), this.errorReporter);
                call.addChild(callParamContent);
                while (next != closeTag) {
                    SoyNode.StandaloneNode sibling = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(next);
                    next.getParent().removeChild(next);
                    callParamContent.addChild(next);
                    next = sibling;
                }
            }
            closeTag.getParent().removeChild(closeTag);
        }
        call.getCalleeExpr().setType(printNode.getExpr().getType());
        call.setHtmlContext(HtmlContext.HTML_PCDATA);
        tagNode.getParent().replaceChild(tagNode, call);
        ImmutableMap<String, TemplateType.Parameter> parameterMap = templateType.getParameterMap();
        HashSet seenAttr = new HashSet();
        tagNode.getChildren().stream().skip(1L).forEach(c -> {
            if (c.getKind() == SoyNode.Kind.IF_NODE) {
                IfNode ifNode = (IfNode)c;
                if (ifNode.numChildren() != 1) {
                    this.errorReporter.report(c.getSourceLocation(), ILLEGAL_CHILD, new Object[0]);
                    return;
                }
                IfCondNode ifCond = (IfCondNode)ifNode.getChild(0);
                LetValueNode letValueNode = new LetValueNode(nodeIdGen.genId(), unknown, "$__internal_call_" + nodeIdGen.genId(), unknown, ifCond.getExpr().getRoot().copy(new CopyState()));
                letValueNode.getVar().setType(ifCond.getExpr().getRoot().getType());
                call.getParent().addChild(call.getParent().getChildIndex(call), letValueNode);
                for (SoyNode.StandaloneNode child : ifCond.getChildren()) {
                    VarRefNode ref = new VarRefNode(letValueNode.getVarRefName(), unknown, letValueNode.getVar());
                    ref.setSubstituteType(letValueNode.getVar().type());
                    this.maybeConsumeAttribute(child, call, nodeIdGen, seenAttr, (Map<String, TemplateType.Parameter>)parameterMap, (Map<String, AttrParam>)attrs, attributesNode, Optional.of(ref));
                }
            } else if (c instanceof KeyNode) {
                call.setKeyExpr(((KeyNode)c).getExpr().copy(new CopyState()));
            } else if (c instanceof SkipNode) {
                this.errorReporter.report(c.getSourceLocation(), SKIP_NODE_NOT_ALLOWED, new Object[0]);
            } else {
                this.maybeConsumeAttribute((SoyNode.StandaloneNode)c, call, nodeIdGen, seenAttr, (Map<String, TemplateType.Parameter>)parameterMap, (Map<String, AttrParam>)attrs, attributesNode, Optional.empty());
            }
        });
        if (attributesNode != null && attributesNode.numChildren() > 0) {
            if (templateType.getAllowExtraAttributesOrExplicit()) {
                call.addChild(attributesNode);
            } else {
                this.errorReporter.report(tagNode.getSourceLocation(), EXTRA_ATTRIBUTES_NOT_ALLOWED, new Object[0]);
            }
        }
        ResolveTemplateNamesPass.updateTemplateLiteralsStaticCallProperty(call);
    }

    private void maybeConsumeAttribute(SoyNode.StandaloneNode c, CallBasicNode call, IdGenerator nodeIdGen, Set<String> seenAttr, Map<String, TemplateType.Parameter> parameterMap, Map<String, AttrParam> attrs, @Nullable CallParamContentNode attributesNode, Optional<ExprNode> conditional) {
        if (c.getKind() == SoyNode.Kind.HTML_ATTRIBUTE_NODE) {
            HtmlAttributeNode attrNode = (HtmlAttributeNode)c;
            if (ElementAttributePass.getStaticOrMergingKey(attrNode) != null) {
                CallParamNode param = this.consumeAttribute(attrNode, nodeIdGen, seenAttr, parameterMap, attrs, attributesNode, call, conditional);
                if (param != null) {
                    param.setOriginalName(ElementAttributePass.getStaticOrMergingKey(attrNode));
                    call.addChild(param);
                }
                return;
            }
            if (attrNode.numChildren() == 1 && attributesNode != null && SoyElementCompositionPass.isOkToPutInElement(attrNode)) {
                SoyElementCompositionPass.maybePrintAttribute(attributesNode, conditional, nodeIdGen, attrNode);
                return;
            }
        }
        this.errorReporter.report(c.getSourceLocation(), ILLEGAL_CHILD, new Object[0]);
    }

    private static void maybePrintAttribute(CallParamContentNode attributesNode, Optional<ExprNode> conditional, IdGenerator nodeIdGen, HtmlAttributeNode attrNode) {
        SourceLocation unknown = attributesNode.getSourceLocation().clearRange();
        if (conditional.isPresent()) {
            IfNode ifNode = new IfNode(nodeIdGen.genId(), unknown);
            ifNode.setHtmlContext(HtmlContext.HTML_TAG);
            IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), unknown, unknown, "if", conditional.get().copy(new CopyState()));
            ifNode.addChild(ifCondNode);
            ifCondNode.getExpr().setType(conditional.get().getType());
            ifCondNode.addChild(attrNode.copy(new CopyState()));
            attributesNode.addChild(ifNode);
        } else {
            attributesNode.addChild(attrNode.copy(new CopyState()));
        }
    }

    static boolean isOkToPutInElement(HtmlAttributeNode attrNode) {
        return ((SoyNode.StandaloneNode)attrNode.getChild(0)).getKind() == SoyNode.Kind.PRINT_NODE && SoyTypes.makeNullish(SanitizedType.AttributesType.getInstance()).isAssignableFromStrict(((PrintNode)attrNode.getChild(0)).getExpr().getType()) || ((SoyNode.StandaloneNode)attrNode.getChild(0)).getKind() == SoyNode.Kind.CALL_BASIC_NODE && ((TemplateType)((CallBasicNode)attrNode.getChild(0)).getCalleeExpr().getType()).getContentKind().getSanitizedContentKind() == SanitizedContentKind.ATTRIBUTES;
    }

    private SoyNode.StandaloneNode consumeSlot(CallBasicNode callNode, SoyNode startNode, IdGenerator nodeIdGen) {
        SourceLocation unknown = startNode.getSourceLocation().clearRange();
        HtmlOpenTagNode nextOpenTag = (HtmlOpenTagNode)startNode;
        String paramName = ((HtmlAttributeNode)nextOpenTag.getChild(1)).getStaticContent();
        HtmlTagNode closeTag = nextOpenTag.getTaggedPairs().get(0);
        CallParamContentNode callParamContent = new CallParamContentNode(nodeIdGen.genId(), startNode.getSourceLocation(), unknown, Identifier.create(paramName, unknown), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, "html", startNode.getSourceLocation().extend(closeTag.getSourceLocation()), unknown), this.errorReporter);
        callNode.addChild(callParamContent);
        SoyNode.StandaloneNode next = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(nextOpenTag);
        while (next != closeTag) {
            SoyNode.StandaloneNode sibling = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(next);
            next.getParent().removeChild(next);
            callParamContent.addChild(next);
            next = sibling;
        }
        nextOpenTag.getParent().removeChild(nextOpenTag);
        SoyNode retNode = SoyTreeUtils.nextSibling(closeTag);
        closeTag.getParent().removeChild(closeTag);
        return (SoyNode.StandaloneNode)retNode;
    }

    private static boolean hasLoggingFunction(HtmlAttributeNode node) {
        return SoyTreeUtils.allNodesOfType(node, FunctionNode.class).anyMatch(fnNode -> !fnNode.isResolved() || fnNode.getSoyFunction() instanceof LoggingFunction);
    }

    @Nullable
    private CallParamNode consumeAttribute(HtmlAttributeNode attr, IdGenerator nodeIdGen, Set<String> seenAttr, Map<String, TemplateType.Parameter> parameterMap, Map<String, AttrParam> attrs, CallParamContentNode attributesNode, CallBasicNode call, Optional<ExprNode> condition) {
        String paramName;
        SourceLocation unknown = attr.getSourceLocation().clearRange();
        String attrName = ElementAttributePass.getStaticOrMergingKey(attr);
        boolean isSoyAttr = attrName.startsWith("@");
        if (isSoyAttr) {
            attrName = attrName.substring(1);
        }
        if (!seenAttr.add(attrName)) {
            this.errorReporter.report(((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation(), DUPLICATE_ATTRIBUTE, new Object[0]);
            return null;
        }
        String string = paramName = attrName.contains("-") ? TemplateType.Parameter.attrToParamName(attrName) : attrName;
        if (!parameterMap.containsKey(paramName)) {
            SoyElementCompositionPass.maybePrintAttribute(attributesNode, condition, nodeIdGen, attr);
            return null;
        }
        if (isSoyAttr) {
            VarRefNode val = new VarRefNode("$" + paramName, unknown, attrs.get(paramName));
            if (condition.isPresent()) {
                return new CallParamValueNode(nodeIdGen.genId(), attr.getSourceLocation(), Identifier.create(paramName, ((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation()), SoyElementCompositionPass.emptyToUndefined(val));
            }
            if (ElementAttributePass.getMergingKey(attr) == null) {
                return new CallParamValueNode(nodeIdGen.genId(), attr.getSourceLocation(), Identifier.create(paramName, ((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation()), val);
            }
            return new CallParamValueNode(nodeIdGen.genId(), attr.getSourceLocation(), Identifier.create(paramName, unknown), this.getMergingValueExpr(attr));
        }
        SoyNode.StandaloneNode value = (SoyNode.StandaloneNode)attr.getChild(1);
        if (value.getKind() != SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)value;
        if (!condition.isPresent() || SoyElementCompositionPass.hasLoggingFunction(attr)) {
            CallParamContentNode contentNode;
            CopyState copyState = new CopyState();
            AbstractCommandNode valueParent = contentNode = new CallParamContentNode(nodeIdGen.genId(), attr.getSourceLocation(), unknown, Identifier.create(paramName, ((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation()), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, SoyElementCompositionPass.getKind(parameterMap.get(paramName).getType()), unknown, unknown), this.errorReporter);
            if (condition.isPresent()) {
                IfNode ifNode = new IfNode(nodeIdGen.genId(), attrValue.getSourceLocation());
                ifNode.setHtmlContext(HtmlContext.HTML_TAG);
                contentNode.addChild(ifNode);
                IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), attrValue.getSourceLocation(), attrValue.getSourceLocation(), "if", condition.get().copy(new CopyState()));
                ifNode.addChild(ifCondNode);
                ifCondNode.getExpr().setType(condition.get().getType());
                valueParent = ifCondNode;
            }
            for (SoyNode.StandaloneNode node : attrValue.getChildren()) {
                valueParent.addChild(node.copy(copyState));
            }
            return contentNode;
        }
        LetContentNode letContentNode = LetContentNode.forVariable(nodeIdGen.genId(), unknown, "$__internal_call_" + paramName + nodeIdGen.genId(), unknown, parameterMap.containsKey(paramName) ? SanitizedContentKind.fromAttributeValue(SoyElementCompositionPass.getKind(parameterMap.get(paramName).getType())).get() : SanitizedContentKind.TEXT);
        call.getParent().addChild(call.getParent().getChildIndex(call), letContentNode);
        IfNode ifNode = new IfNode(nodeIdGen.genId(), unknown);
        ifNode.setHtmlContext(HtmlContext.HTML_TAG);
        letContentNode.addChild(ifNode);
        IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), unknown, unknown, "if", condition.get().copy(new CopyState()));
        ifNode.addChild(ifCondNode);
        ifCondNode.getExpr().setType(condition.get().getType());
        CopyState copyState = new CopyState();
        for (SoyNode.StandaloneNode node : attrValue.getChildren()) {
            ifCondNode.addChild(node.copy(copyState));
        }
        VarRefNode varRef = new VarRefNode("$" + letContentNode.getVar().name(), unknown, letContentNode.getVar());
        return new CallParamValueNode(nodeIdGen.genId(), unknown, Identifier.create(paramName, unknown), SoyElementCompositionPass.emptyToUndefined(varRef));
    }

    private static ExprNode emptyToUndefined(ExprNode val) {
        FunctionNode functionNode = FunctionNode.newPositional(Identifier.create(BuiltinFunction.EMPTY_TO_NULL.getName(), val.getSourceLocation()), BuiltinFunction.EMPTY_TO_NULL, val.getSourceLocation());
        functionNode.setType(UnionType.of(UndefinedType.getInstance(), val.getType()));
        functionNode.addChild(val);
        return functionNode;
    }

    private static String getKind(SoyType attrType) {
        attrType = SoyTypes.tryRemoveNullish(attrType);
        if (SanitizedType.TrustedResourceUriType.getInstance().isAssignableFromStrict(attrType)) {
            return "trusted_resource_uri";
        }
        if (SanitizedType.UriType.getInstance().isAssignableFromStrict(attrType)) {
            return "uri";
        }
        if (SanitizedType.StyleType.getInstance().isAssignableFromStrict(attrType)) {
            return "css";
        }
        return "text";
    }

    private FunctionNode getMergingValueExpr(HtmlAttributeNode attr) {
        PrintNode printNode = (PrintNode)attr.getChild(0);
        FunctionNode func = (FunctionNode)printNode.getExpr().getRoot();
        FunctionNode newFunc = ElementAttributePass.getMergingKey(attr).equals("@class") ? FunctionNode.newPositional(Identifier.create("buildClassValue", SourceLocation.UNKNOWN), BasicFunctions.BUILD_CLASS_VALUE_FUNCTION, SourceLocation.UNKNOWN) : (ElementAttributePass.getMergingKey(attr).equals("@style") ? FunctionNode.newPositional(Identifier.create("buildStyleValue", SourceLocation.UNKNOWN), BasicFunctions.BUILD_STYLE_VALUE_FUNCTION, SourceLocation.UNKNOWN) : FunctionNode.newPositional(Identifier.create("buildAttrValue", SourceLocation.UNKNOWN), BasicFunctions.BUILD_ATTR_VALUE_FUNCTION, SourceLocation.UNKNOWN));
        ImmutableList.Builder allowedTypes = ImmutableList.builder();
        Iterator<ExprNode> i = func.getChildren().iterator();
        i.next();
        while (i.hasNext()) {
            newFunc.addChild(i.next().copy(new CopyState()));
            allowedTypes.add((Object)UnionType.of(StringType.getInstance(), SanitizedType.StyleType.getInstance(), BoolType.getInstance(), NullType.getInstance(), UndefinedType.getInstance()));
        }
        newFunc.setType(ElementAttributePass.getMergingKey(attr).equals("@style") ? SanitizedType.StyleType.getInstance() : StringType.getInstance());
        newFunc.setAllowedParamTypes((List<SoyType>)allowedTypes.build());
        return newFunc;
    }
}

