/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.ToggleImportType;

@RunAfter(value={ResolveNamesPass.class})
final class RewriteToggleImportsPass
implements CompilerFilePass {
    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).filter(v -> v.getDefnDecl().kind() == VarDefn.Kind.IMPORT_VAR).filter(v -> v.getDefnDecl().hasType()).filter(v -> v.getDefnDecl().type().getKind() == SoyType.Kind.TOGGLE_TYPE).forEach(v -> this.rewriteToggleNode((VarRefNode)v, v.getSourceLocation()));
    }

    private void rewriteToggleNode(VarRefNode refn, SourceLocation fullLocation) {
        ImportedVar defn = (ImportedVar)refn.getDefnDecl();
        ToggleImportType toggleType = (ToggleImportType)defn.type();
        FunctionNode funcNode = FunctionNode.newPositional(Identifier.create(BuiltinFunction.EVAL_TOGGLE.getName(), fullLocation), BuiltinFunction.EVAL_TOGGLE, fullLocation);
        funcNode.addChild(new StringNode(toggleType.getPath().path(), QuoteStyle.DOUBLE, refn.getSourceLocation()));
        funcNode.addChild(new StringNode(toggleType.getName(), QuoteStyle.DOUBLE, refn.getSourceLocation()));
        funcNode.setType(StringType.getInstance());
        refn.getParent().replaceChild(refn, funcNode);
    }
}

