/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.FinalizeTemplateRegistryPass;
import com.google.template.soy.passes.MoreCallValidationsPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@RunAfter(value={ResolveExpressionTypesPass.class, FinalizeTemplateRegistryPass.class})
@RunBefore(value={CheckTemplateCallsPass.class, MoreCallValidationsPass.class})
final class RewriteShortFormCallsPass
implements CompilerFileSetPass {
    private static final SoyErrorKind OVERFLOW = SoyErrorKind.of("Overflowed short form call rewriting.", new SoyErrorKind.StyleAllowance[0]);
    static final SoyErrorKind EXPECTED_NAMED_PARAMETERS = SoyErrorKind.of("Expected named parameters.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ExprEquivalence exprEquivalence;

    public RewriteShortFormCallsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.exprEquivalence = new ExprEquivalence();
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        ImmutableListMultimap vars = (ImmutableListMultimap)SoyTreeUtils.allNodesOfType(file, VarRefNode.class).collect(ImmutableListMultimap.toImmutableListMultimap(VarRefNode::getDefnDecl, v -> v));
        int maxDepth = 20;
        AtomicBoolean mutated = new AtomicBoolean(true);
        while (mutated.get() && --maxDepth > 0) {
            mutated.set(false);
            SoyTreeUtils.allNodes(file).forEach(n -> {
                boolean m = false;
                if (n instanceof PrintNode) {
                    m = this.visitPrintNode((PrintNode)n, nodeIdGen);
                } else if (n instanceof LetValueNode) {
                    m = this.visitLetValueNode((LetValueNode)n, nodeIdGen, (ImmutableListMultimap<VarDefn, VarRefNode>)vars);
                } else if (n instanceof CallParamValueNode) {
                    m = this.visitCallParamValueNode((CallParamValueNode)n, nodeIdGen);
                }
                mutated.set(mutated.get() || m);
            });
        }
        if (maxDepth == 0) {
            this.errorReporter.report(file.getSourceLocation(), OVERFLOW, new Object[0]);
        }
    }

    private boolean visitPrintNode(PrintNode node, IdGenerator nodeIdGen) {
        if (node.getParent() instanceof HtmlOpenTagNode) {
            return false;
        }
        CallBasicNode call = this.convert(node.getExpr(), nodeIdGen);
        if (call != null) {
            node.getParent().replaceChild(node, call);
            return true;
        }
        return false;
    }

    private boolean visitLetValueNode(LetValueNode node, IdGenerator nodeIdGen, ImmutableListMultimap<VarDefn, VarRefNode> vars) {
        CallBasicNode call = this.convert(node.getExpr(), nodeIdGen);
        if (call != null) {
            TemplateType templateType = (TemplateType)call.getCalleeExpr().getType();
            SourceLocation loc = node.getSourceLocation();
            SanitizedContentKind kind = templateType.getContentKind().getSanitizedContentKind();
            LetContentNode contentNode = new LetContentNode(nodeIdGen.genId(), loc, loc, node.getVarName(), loc, RewriteShortFormCallsPass.getKindAttr(loc, kind), ErrorReporter.exploding());
            contentNode.addChild(call);
            contentNode.getVar().setType(SanitizedType.getTypeForContentKind(kind));
            node.getParent().replaceChild(node, contentNode);
            for (VarRefNode varRefNode : vars.get((Object)node.getVar())) {
                varRefNode.setDefn(contentNode.getVar());
            }
            return true;
        }
        return false;
    }

    private boolean visitCallParamValueNode(CallParamValueNode node, IdGenerator nodeIdGen) {
        CallBasicNode call = this.convert(node.getExpr(), nodeIdGen);
        if (call != null) {
            TemplateType templateType = (TemplateType)call.getCalleeExpr().getType();
            SourceLocation loc = node.getSourceLocation();
            SanitizedContentKind kind = templateType.getContentKind().getSanitizedContentKind();
            CallParamContentNode contentNode = new CallParamContentNode(nodeIdGen.genId(), loc, loc, node.getKey(), RewriteShortFormCallsPass.getKindAttr(loc, kind), ErrorReporter.exploding());
            contentNode.addChild(call);
            node.getParent().replaceChild(node, (SoyNode)contentNode);
            return true;
        }
        return false;
    }

    private static CommandTagAttribute getKindAttr(SourceLocation loc, SanitizedContentKind kind) {
        return new CommandTagAttribute(Identifier.create("kind", loc), QuoteStyle.DOUBLE, kind.asAttributeValue(), loc, loc);
    }

    @Nullable
    private CallBasicNode convert(ExprRootNode expr, IdGenerator nodeIdGen) {
        ExprNode callee;
        SoyType type;
        if (!(expr.getRoot() instanceof FunctionNode)) {
            return null;
        }
        FunctionNode fnNode = (FunctionNode)expr.getRoot();
        if (fnNode.hasStaticName()) {
            return null;
        }
        ExprNode nameExpr = fnNode.getNameExpr();
        if (nameExpr instanceof VarRefNode && nameExpr.getType() instanceof TemplateImportType) {
            type = ((TemplateImportType)nameExpr.getType()).getBasicTemplateType();
            TemplateLiteralNode templateLiteralNode = TemplateLiteralNode.forVarRef((VarRefNode)nameExpr);
            templateLiteralNode.setStaticCall(true);
            templateLiteralNode.setType(type);
            callee = templateLiteralNode;
        } else if (nameExpr.getType() instanceof TemplateType) {
            callee = nameExpr.copy(new CopyState());
            type = callee.getType();
        } else {
            return null;
        }
        if (fnNode.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
            this.errorReporter.report(fnNode.getSourceLocation(), EXPECTED_NAMED_PARAMETERS, new Object[0]);
            expr.replaceChild(0, (ExprNode)new StringNode("$error", QuoteStyle.SINGLE, expr.getSourceLocation()));
            return null;
        }
        CallBasicNode call = new CallBasicNode(nodeIdGen.genId(), expr.getSourceLocation(), expr.getSourceLocation(), callee, (List<CommandTagAttribute>)ImmutableList.of(), false, ErrorReporter.exploding());
        call.setOriginalShortFormExprEquivalence(this.exprEquivalence.wrap(expr.copy(new CopyState())));
        call.getCalleeExpr().setType(type);
        for (int i = 0; i < fnNode.getParamNames().size(); ++i) {
            Identifier id = (Identifier)fnNode.getParamNames().get(i);
            CallParamValueNode valueNode = new CallParamValueNode(nodeIdGen.genId(), id.location(), id, fnNode.getParam(i).copy(new CopyState()));
            valueNode.getExpr().setType(fnNode.getParam(i).getType());
            call.addChild(valueNode);
        }
        call.setIsPcData(true);
        return call;
    }
}

