/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveTemplateNamesPass;
import com.google.template.soy.passes.RewriteShortFormCallsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.SoyType;
import java.util.List;
import java.util.stream.Collectors;

@RunAfter(value={ImportsPass.class, ResolveDottedImportsPass.class})
@RunBefore(value={ResolveTemplateNamesPass.class})
final class RewriteElementCompositionFunctionsPass
implements CompilerFilePass {
    private final ErrorReporter errorReporter;
    private final boolean rewriteElementComposition;

    RewriteElementCompositionFunctionsPass(ErrorReporter errorReporter, boolean rewriteElementComposition) {
        this.errorReporter = errorReporter;
        this.rewriteElementComposition = rewriteElementComposition;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, HtmlOpenTagNode.class).filter(tag -> !tag.getTagName().isStatic()).flatMap(tag -> SoyTreeUtils.allNodesOfType(tag.getTagName().getDynamicTagName(), FunctionNode.class, n -> n instanceof FunctionNode ? SoyTreeUtils.VisitDirective.SKIP_CHILDREN : SoyTreeUtils.VisitDirective.CONTINUE)).filter(fct -> !fct.hasStaticName()).filter(fct -> fct.getNameExpr().getKind() == ExprNode.Kind.VAR_REF_NODE || fct.getNameExpr().getKind() == ExprNode.Kind.TEMPLATE_LITERAL_NODE).collect(Collectors.toList()).forEach(this::convertToBind);
    }

    private void convertToBind(FunctionNode fct) {
        if (fct.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
            this.errorReporter.report(fct.getSourceLocation(), RewriteShortFormCallsPass.EXPECTED_NAMED_PARAMETERS, new Object[0]);
            return;
        }
        if (!this.rewriteElementComposition) {
            fct.setAllowedToInvokeAsFunction(true);
            return;
        }
        ExprNode replacementExpr = fct.getNameExpr();
        if (replacementExpr instanceof VarRefNode) {
            VarRefNode varRefNode = (VarRefNode)replacementExpr;
            if (varRefNode.hasType() && varRefNode.getType() instanceof ProtoImportType) {
                return;
            }
            replacementExpr = varRefNode.hasType() && varRefNode.getType().getKind() == SoyType.Kind.TEMPLATE_TYPE ? TemplateLiteralNode.forVarRef(varRefNode.copy(new CopyState())) : varRefNode;
        }
        if (fct.numParams() > 0) {
            RecordLiteralNode record = new RecordLiteralNode(Identifier.create("record", fct.getSourceLocation()), (Iterable<Identifier>)fct.getParamNames(), fct.getSourceLocation());
            record.addChildren((List<? extends ExprNode>)fct.getParams());
            replacementExpr = MethodCallNode.newWithPositionalArgs(replacementExpr, (List<ExprNode>)ImmutableList.of((Object)record), Identifier.create("bind", SourceLocation.UNKNOWN), SourceLocation.UNKNOWN, false);
        }
        fct.getParent().replaceChild(fct, replacementExpr);
    }
}

