/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;

@RunAfter(value={ImportsPass.class})
final class ResolveUseVariantTypePass
implements CompilerFilePass {
    private final ErrorReporter errorReporter;

    ResolveUseVariantTypePass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode templateNode : file.getTemplates()) {
            if (!(templateNode instanceof TemplateBasicNode)) continue;
            ((TemplateBasicNode)templateNode).resolveUseVariantType(file.getImportsContext().getTypeRegistry(), this.errorReporter);
        }
    }
}

