/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.passes.ResolveDottedImportsPass;
import com.google.template.soy.passes.ResolveNamesPass;
import com.google.template.soy.passes.ResolvePluginsPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyElementPass;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.types.SoyType;
import javax.annotation.Nullable;

@RunAfter(value={ImportsPass.class, ResolvePluginsPass.class, ResolveNamesPass.class, ResolveDottedImportsPass.class})
@RunBefore(value={SoyElementPass.class})
final class ResolveTemplateNamesPass
implements CompilerFileSetPass {
    private static final SoyErrorKind DATA_ATTRIBUTE_ONLY_ALLOWED_ON_STATIC_CALLS = SoyErrorKind.of("The `data` attribute is only allowed on static calls.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public ResolveTemplateNamesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.visitFile(file);
        }
        for (SoyFileNode file : sourceFiles) {
            ResolveTemplateNamesPass.updateTemplateLiteralsStaticCallProperty(file);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void visitFile(SoyFileNode file) {
        SoyTreeUtils.allNodesOfType(file, CallBasicNode.class).forEach(ResolveTemplateNamesPass::importedVarRefToTemplateLiteral);
        SoyTreeUtils.allNodesOfType(file, TemplateBasicNode.class).forEach(ResolveTemplateNamesPass::importedVarRefToTemplateLiteral);
        SoyTreeUtils.allNodesOfType(file, VarRefNode.class).filter(n -> n.getParent().getKind() != ExprNode.Kind.TEMPLATE_LITERAL_NODE).forEach(v -> {
            TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(v, v.getSourceLocation());
            if (converted != null) {
                v.getParent().replaceChild(v, converted);
            }
        });
        SoyTreeUtils.allNodesOfType(file, TemplateLiteralNode.class).filter(n -> !n.isResolved()).forEach(TemplateLiteralNode::resolveTemplateName);
        SoyTreeUtils.allNodesOfType(file, CallBasicNode.class).filter(callNode -> callNode.isPassingData() && !callNode.isStaticCall()).forEach(callNode -> this.errorReporter.report(callNode.getOpenTagLocation(), DATA_ATTRIBUTE_ONLY_ALLOWED_ON_STATIC_CALLS, new Object[0]));
    }

    private static void importedVarRefToTemplateLiteral(CallBasicNode callNode) {
        ExprNode templateExpr = callNode.getCalleeExpr().getRoot();
        TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(templateExpr, templateExpr.getSourceLocation());
        if (converted != null) {
            callNode.setCalleeExpr(new ExprRootNode(converted));
        }
    }

    private static void importedVarRefToTemplateLiteral(TemplateBasicNode templateNode) {
        if (templateNode.getModifiesExpr() == null) {
            return;
        }
        ExprNode templateExpr = templateNode.getModifiesExpr().getRoot();
        TemplateLiteralNode converted = ResolveTemplateNamesPass.varRefToLiteral(templateExpr, templateExpr.getSourceLocation());
        if (converted != null) {
            templateNode.getModifiesExpr().replaceChild(0, (ExprNode)converted);
        }
    }

    @Nullable
    private static TemplateLiteralNode varRefToLiteral(ExprNode expr, SourceLocation sourceLocation) {
        if (expr.getKind() != ExprNode.Kind.VAR_REF_NODE) {
            return null;
        }
        VarRefNode varRef = (VarRefNode)expr;
        if (varRef.hasType() && expr.getType().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
            return TemplateLiteralNode.forVarRef(varRef.copy(new CopyState()), sourceLocation);
        }
        return null;
    }

    static void updateTemplateLiteralsStaticCallProperty(SoyNode root) {
        SoyTreeUtils.visitExprNodesWithHolder(root, TemplateLiteralNode.class, (exprHolder, templateLiteralNode) -> {
            ExprNode.ParentExprNode parent;
            boolean staticCall = false;
            if (exprHolder instanceof CallNode && (parent = templateLiteralNode.getParent()).getKind() != ExprNode.Kind.METHOD_CALL_NODE) {
                staticCall = true;
            }
            templateLiteralNode.setStaticCall(staticCall);
        });
    }
}

