/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basicfunctions.ConcatListsFunction;
import com.google.template.soy.basicfunctions.ConcatMapsMethod;
import com.google.template.soy.basicfunctions.KeysFunction;
import com.google.template.soy.basicfunctions.LegacyObjectMapToMapFunction;
import com.google.template.soy.basicfunctions.ListFlatMethod;
import com.google.template.soy.basicfunctions.ListReverseMethod;
import com.google.template.soy.basicfunctions.ListSliceMethod;
import com.google.template.soy.basicfunctions.ListUniqMethod;
import com.google.template.soy.basicfunctions.MapEntriesMethod;
import com.google.template.soy.basicfunctions.MapKeysFunction;
import com.google.template.soy.basicfunctions.MapToLegacyObjectMapFunction;
import com.google.template.soy.basicfunctions.MapValuesMethod;
import com.google.template.soy.basicfunctions.MaxFunction;
import com.google.template.soy.basicfunctions.MinFunction;
import com.google.template.soy.basicfunctions.NumberListSortMethod;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.internal.util.TopoSort;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.RuntimeTypeCoercion;
import com.google.template.soy.passes.TypeNarrowingConditionVisitor;
import com.google.template.soy.passes.TypeSubstitutions;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.internal.ResolvedSignature;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFieldSignature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.FileMetadata;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.LegacyObjectMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.PrimitiveType;
import com.google.template.soy.types.ProtoImportType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.TemplateImportType;
import com.google.template.soy.types.TemplateModuleImportType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import com.google.template.soy.types.VeDataType;
import com.google.template.soy.types.VeType;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class ResolveExpressionTypesPass
implements CompilerFileSetPass.TopologicallyOrdered {
    private static final SoyErrorKind BAD_FOREACH_TYPE = SoyErrorKind.of("Cannot iterate over {0} of type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_INDEX_TYPE = SoyErrorKind.of("Bad index type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_KEY_TYPE = SoyErrorKind.of("Bad key type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_LIST_COMP_TYPE = SoyErrorKind.of("Bad list comprehension type. {0} has type: {1}, but should be a list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_MAP_LITERAL_FROM_LIST_TYPE = SoyErrorKind.of("Bad list to map constructor. {0} has type: {1}, but should be a list of records with 2 fields named key and value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support bracket access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NULLABLE_UNION = SoyErrorKind.of("Union type that is nullable cannot use bracket access. To access this value, first check for null or use null-safe (\"?[\") operations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CHECK_NOT_NULL_ON_COMPILE_TIME_NULL = SoyErrorKind.of("Cannot {0} on a value with a static type of ''null'' or ''undefined''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REDUNDANT_NON_NULL_ASSERTION_OPERATOR = SoyErrorKind.of("Found redundant non-null assertion operators (''!'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NULLISH_FIELD_ACCESS = SoyErrorKind.of("Field access not allowed on nullable type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_FIELD = SoyErrorKind.of("Field ''{0}'' does not exist on type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD = SoyErrorKind.of("Type {0} does not support dot access (consider record instead of map).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_EXTERN_OVERLOAD_1 = SoyErrorKind.of("Parameter types, {0}, do not satisfy the function signature, {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NO_SUCH_EXTERN_OVERLOAD_N = SoyErrorKind.of("Parameter types, {0}, do not uniquely satisfy one of the function signatures [{1}].", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNNECESSARY_NULL_SAFE_ACCESS = SoyErrorKind.of("This null safe access is unnecessary, it is on a value that is non-null.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_IN_MAP_LITERAL = SoyErrorKind.of("Map literals with duplicate keys are not allowed.  Duplicate key: ''{0}''", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind KEYS_PASSED_MAP = SoyErrorKind.of("Use the ''mapKeys'' function instead of ''keys'' for objects of type ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_MAP_RESOLVED_KEY_TYPE = SoyErrorKind.of("A map''s keys must all be the same type. This map has keys of multiple types (''{0}'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_ACCESS = SoyErrorKind.of("Accessing item in empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_FOREACH = SoyErrorKind.of("Cannot iterate over empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_COMPREHENSION = SoyErrorKind.of("Cannot use list comprehension over empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_MAP_ACCESS = SoyErrorKind.of("Accessing item in empty map.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TYPE_SUBSTITUTION = SoyErrorKind.of("Cannot narrow expression of type ''{0}'' to ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for node {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_PROTO_INIT = SoyErrorKind.of("Expected a protocol buffer for the second argument.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OR_OPERATOR_HAS_CONSTANT_OPERAND = SoyErrorKind.of("Constant operand ''{0}'' used with ''or'' operator. Consider simplifying or using the ?? operator, see go/soy/reference/expressions.md#logical-operators", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_RECORD_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for record type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_FIELD_DOES_NOT_EXIST = SoyErrorKind.of("Proto field ''{0}'' does not exist in {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DID_YOU_MEAN_GETTER_ONLY_FIELD_FOR_PROTO_TYPE = SoyErrorKind.of("Did you mean ''{0}''? Proto field ''{0}'' for proto type {1} can only be accessed via ''{2}''. See http://go/soy/dev/protos.md#accessing-proto-fields for more info.", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind GETTER_ONLY_FIELD_FOR_PROTO_TYPE = SoyErrorKind.of("Proto field ''{0}'' for proto type {1} can only be accessed via ''{2}''. See http://go/soy/dev/protos.md#accessing-proto-fields for more info.", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_MISSING_REQUIRED_FIELD = SoyErrorKind.of("Missing required proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_NULL_ARG_TYPE = SoyErrorKind.of("Cannot assign static type ''null'' or ''undefined'' to proto field ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_FIELD_NAME_IMPORT_CONFLICT = SoyErrorKind.of("Imported symbol ''{0}'' conflicts with a field of proto constructor ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TYPE_MISMATCH = SoyErrorKind.of("Soy types ''{0}'' and ''{1}'' are not comparable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DECLARED_DEFAULT_TYPE_MISMATCH = SoyErrorKind.of("The initializer for ''{0}'' has type ''{1}'' which is not assignable to type ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_DEPENDS_ON_PARAM = SoyErrorKind.of("Param initializers may not depend on other params.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAM_DEPENDS_ON_FUNCTION = SoyErrorKind.of("Only pure functions are allowed in param initializers.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_CYCLE = SoyErrorKind.of("Illegal cycle in state param initializers: {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP = SoyErrorKind.of("Using arithmetic operator ''{0}'' on Soy types ''{1}'' and ''{2}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_ARITHMETIC_OP_UNARY = SoyErrorKind.of("Using arithmetic operators on the Soy type ''{0}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_TYPE = SoyErrorKind.of("Function ''{0}'' called with incorrect arg type {1} (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_STYLE = SoyErrorKind.of("Function called with incorrect arg style (positional or named).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRING_LITERAL_REQUIRED = SoyErrorKind.of("Argument to function ''{0}'' must be a string literal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_METHOD_BASE = SoyErrorKind.of("Method ''{0}'' does not exist on type ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind MULTIPLE_METHODS_MATCH = SoyErrorKind.of("Method ''{0}'' with {1} arg(s) for type ''{2}'' matches multiple method implementations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_INVALID_PARAM_NUM = SoyErrorKind.of("Method ''{0}'' called with {1} parameter(s) but expected {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_INVALID_PARAM_TYPES = SoyErrorKind.of("Method ''{0}'' called with parameter types ({1}) but expected ({2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind METHOD_BASE_TYPE_NULL_SAFE_REQUIRED = SoyErrorKind.of("Method calls are not allowed on objects with nullable types (''{0}''). Either ensure the type is non-nullable or perform a null safe access (''?.'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPLICIT_NULL = SoyErrorKind.of("Use of the ''null'' or ''undefined'' literal is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind AMBIGUOUS_INFERRED_TYPE = SoyErrorKind.of("Using {0} in the initializer for a parameter with an inferred type is ambiguous. Add an explicit type declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TEMPLATE_TYPE_PARAMETERS_CANNOT_USE_INFERRED_TYPES = SoyErrorKind.of("Template type parameters cannot be inferred. Instead, explicitly declare the type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CANNOT_USE_INFERRED_TYPES = SoyErrorKind.of("Type cannot be inferred, the param definition requires an explicit type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_EXT_FQN = SoyErrorKind.of("Extensions fields in proto init functions must be imported symbols. Fully qualified names are not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_PROTO_MESSAGE = SoyErrorKind.of("Only proto messages may be instantiated.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MUST_USE_TEMPLATES_IMMEDIATELY = SoyErrorKind.of("Templates may only be called to initialize a '{'let'}', set a '{'param'}', or as the sole child of a print statement.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CONSTANTS_CANT_BE_NULLABLE = SoyErrorKind.of("Type calculated type, {0}, is nullable, which is not allowed for const.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_ALLOWED_IN_CONSTANT_VALUE = SoyErrorKind.of("This operation is not allowed inside a const value definition.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ILLEGAL_SWITCH_EXPRESSION_TYPE = SoyErrorKind.of("Type ''{0}'' is not allowed in a switch expression.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SWITCH_CASE_TYPE_MISMATCH = SoyErrorKind.of("Case type ''{0}'' not assignable to switch type ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_DELCALL_VARIANT_TYPE = SoyErrorKind.of("Delcall variant must be of type string, int, or proto enum. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VARIANT_EXPRESSION = SoyErrorKind.of("Invalid variant literal value ''{0}'' in ''delcall''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_EXPR_TYPE = SoyErrorKind.of("Plural expression must be a number type. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_EXPR_NULLABLE = SoyErrorKind.of("Plural expression should be a non-nullable number type. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_CLASS_STRING = SoyErrorKind.of("Spaces are not allowed in CSS class names. Either remove the space(s) or pass the individual class names to multiple separate calls of the css() function.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CAN_OMIT_KIND_ONLY_FOR_SINGLE_CALL = SoyErrorKind.of("The ''kind'' attribute can be omitted only if the let contains a single call command.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final SoyMethod.Registry methodRegistry;
    private final boolean rewriteShortFormCalls;
    private final Supplier<FileSetMetadata> templateRegistryFromDeps;
    private final Map<Signature, ResolvedSignature> signatureMap = new HashMap<Signature, ResolvedSignature>();
    private final ResolveTypesExprVisitor exprVisitor = new ResolveTypesExprVisitor(false);
    private final ResolveTypesExprVisitor paramInfExprVisitor = new ResolveTypesExprVisitor(true);
    private final ResolveTypesExprVisitor constExprVisitor = new ResolveTypesConstNodeVisitor();
    private final FieldRegistry fieldRegistry;
    private TypeSubstitutions substitutions;
    private final ExprEquivalence exprEquivalence;
    private SoyTypeRegistry typeRegistry;
    private TypeNodeConverter pluginTypeConverter;
    private final PluginResolver.Mode pluginResolutionMode;
    private ImmutableMap<String, TemplateType> allTemplateTypes;
    private ConstantsTypeIndex constantsTypeLookup;
    private ExternsTypeIndex externsTypeLookup;
    private SoyFileNode currentFile;

    ResolveExpressionTypesPass(ErrorReporter errorReporter, PluginResolver pluginResolver, boolean rewriteShortFormCalls, Supplier<FileSetMetadata> templateRegistryFromDeps) {
        this.errorReporter = errorReporter;
        this.pluginResolutionMode = pluginResolver == null ? PluginResolver.Mode.REQUIRE_DEFINITIONS : pluginResolver.getPluginResolutionMode();
        this.rewriteShortFormCalls = rewriteShortFormCalls;
        this.templateRegistryFromDeps = templateRegistryFromDeps;
        this.methodRegistry = new CompositeMethodRegistry((List<SoyMethod.Registry>)ImmutableList.of((Object)BuiltinMethod.REGISTRY, (Object)new PluginMethodRegistry(pluginResolver)));
        this.fieldRegistry = new FieldRegistry(pluginResolver);
        this.exprEquivalence = new ExprEquivalence();
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        CollectTemplateTypesVisitor templateTypesVisitor = new CollectTemplateTypesVisitor();
        HashMap<String, TemplateType> allTemplateTypesBuilder = new HashMap<String, TemplateType>();
        this.externsTypeLookup = new ExternsTypeIndex(this.templateRegistryFromDeps);
        for (SoyFileNode sourceFile : sourceFiles) {
            this.prepFile(sourceFile);
            this.setExternTypes(sourceFile);
            allTemplateTypesBuilder.putAll(templateTypesVisitor.exec(sourceFile));
        }
        this.allTemplateTypes = ImmutableMap.copyOf(allTemplateTypesBuilder);
        this.constantsTypeLookup = new ConstantsTypeIndex(this.templateRegistryFromDeps);
        for (SoyFileNode sourceFile : sourceFiles) {
            this.prepFile(sourceFile);
            new TypeAssignmentSoyVisitor().exec(sourceFile);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void setExternTypes(SoyFileNode sourceFile) {
        sourceFile.getExterns().forEach(extern -> {
            extern.getVar().setType(extern.getType());
            this.externsTypeLookup.put((ExternNode)extern);
        });
        sourceFile.getImports().forEach(importNode -> importNode.visitVars((var, parentType) -> {
            if (!var.hasType() && parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE) {
                TemplateModuleImportType moduleType = (TemplateModuleImportType)parentType;
                String symbol = var.getSymbol();
                if (moduleType.getExternNames().contains((Object)symbol)) {
                    List<FunctionType> types = this.externsTypeLookup.get(moduleType.getPath(), symbol);
                    var.setType(types.get(0));
                }
            }
        }));
    }

    private void prepFile(SoyFileNode file) {
        this.substitutions = new TypeSubstitutions(this.exprEquivalence);
        this.typeRegistry = file.getSoyTypeRegistry();
        this.currentFile = file;
        this.pluginTypeConverter = TypeNodeConverter.builder(this.errorReporter).setTypeRegistry(this.typeRegistry).setSystemExternal(true).build();
    }

    private TypeNarrowingConditionVisitor createTypeNarrowingConditionVisitor() {
        return new TypeNarrowingConditionVisitor(this.exprEquivalence, this.typeRegistry);
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        for (ExprRootNode expr : node.getExprList()) {
            this.exprVisitor.exec(expr);
        }
    }

    private SoyType getElementType(SoyType collectionType, ForNonemptyNode node) {
        Preconditions.checkNotNull((Object)collectionType);
        switch (collectionType.getKind()) {
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case LIST: {
                if (collectionType == ListType.EMPTY_LIST) {
                    this.errorReporter.report(node.getExpr().getSourceLocation(), EMPTY_LIST_FOREACH, new Object[0]);
                    return UnknownType.getInstance();
                }
                return ((ListType)collectionType).getElementType();
            }
            case UNION: {
                ErrorReporter.Checkpoint cp = this.errorReporter.checkpoint();
                UnionType unionType = (UnionType)collectionType;
                ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                for (SoyType unionMember : unionType.getMembers()) {
                    SoyType elementType = this.getElementType(unionMember, node);
                    if (this.errorReporter.errorsSince(cp)) {
                        return elementType;
                    }
                    fieldTypes.add(elementType);
                }
                return SoyTypes.computeLowestCommonType(this.typeRegistry, fieldTypes);
            }
        }
        this.errorReporter.report(node.getParent().getSourceLocation(), BAD_FOREACH_TYPE, node.getExpr().toSourceString(), node.getExpr().getType());
        return UnknownType.getInstance();
    }

    private SoyType parseType(String t, SourceFilePath path) {
        TypeNode typeNode = SoyFileParser.parseType(t, path, this.errorReporter);
        return typeNode != null ? this.pluginTypeConverter.getOrCreateType(typeNode) : UnknownType.getInstance();
    }

    private static class ExternsTypeIndex {
        private final Supplier<FileSetMetadata> deps;
        private final Table<SourceLogicalPath, String, List<ExternNode>> sources = HashBasedTable.create();

        public ExternsTypeIndex(Supplier<FileSetMetadata> deps) {
            this.deps = deps;
        }

        List<FunctionNode.ExternRef> getRefs(SourceLogicalPath path, String name) {
            return this.get(path, name).stream().map(type -> FunctionNode.ExternRef.of(path, name, type)).collect(Collectors.toList());
        }

        List<FunctionType> get(SourceLogicalPath path, String name) {
            List fromSources = (List)this.sources.get((Object)path, (Object)name);
            if (fromSources != null) {
                return fromSources.stream().map(ExternNode::getType).collect(Collectors.toList());
            }
            FileMetadata fromDeps = this.deps.get().getFile(path);
            if (fromDeps != null) {
                List<? extends FileMetadata.Extern> e = fromDeps.getExterns(name);
                return e.stream().map(FileMetadata.Extern::getSignature).collect(Collectors.toList());
            }
            return ImmutableList.of();
        }

        void put(ExternNode node) {
            String name;
            SourceLogicalPath path = node.getNearestAncestor(SoyFileNode.class).getFilePath().asLogicalPath();
            ArrayList<ExternNode> nodes = (ArrayList<ExternNode>)this.sources.get((Object)path, (Object)(name = node.getVar().name()));
            if (nodes != null) {
                nodes.add(node);
            } else {
                nodes = new ArrayList<ExternNode>();
                nodes.add(node);
                this.sources.put((Object)path, (Object)name, nodes);
            }
        }
    }

    private static class ConstantsTypeIndex {
        private final Supplier<FileSetMetadata> deps;
        private final Table<SourceLogicalPath, String, ConstNode> sources = HashBasedTable.create();

        public ConstantsTypeIndex(Supplier<FileSetMetadata> deps) {
            this.deps = deps;
        }

        @Nullable
        SoyType get(SourceLogicalPath path, String name) {
            FileMetadata.Constant c;
            ConstNode fromSources = (ConstNode)this.sources.get((Object)path, (Object)name);
            if (fromSources != null) {
                return fromSources.getVar().type();
            }
            FileMetadata fromDeps = this.deps.get().getFile(path);
            if (fromDeps != null && (c = fromDeps.getConstant(name)) != null) {
                return c.getType();
            }
            return null;
        }

        void put(ConstNode node) {
            SoyFileNode file = node.getNearestAncestor(SoyFileNode.class);
            this.sources.put((Object)file.getFilePath().asLogicalPath(), (Object)node.getVar().name(), (Object)node);
        }
    }

    private final class FieldRegistry {
        private final PluginResolver plugins;
        private final LoadingCache<String, ImmutableList<SoySourceFunctionMethod>> methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ImmutableList<SoySourceFunctionMethod>>(){

            public ImmutableList<SoySourceFunctionMethod> load(String methodName) {
                return (ImmutableList)FieldRegistry.this.plugins.lookupSoyFields(methodName).stream().map(f -> {
                    SoyFieldSignature fieldSig = f.getClass().getAnnotation(SoyFieldSignature.class);
                    SourceFilePath fakeFunctionPath = SourceFilePath.create(f.getClass().getName(), f.getClass().getName());
                    SoyType baseType = ResolveExpressionTypesPass.this.parseType(fieldSig.baseType(), fakeFunctionPath);
                    SoyType returnType = ResolveExpressionTypesPass.this.parseType(fieldSig.returnType(), fakeFunctionPath);
                    return new SoySourceFunctionMethod((SoySourceFunction)f, baseType, returnType, (ImmutableList<SoyType>)ImmutableList.of(), fieldSig.name());
                }).collect(ImmutableList.toImmutableList());
            }
        });

        FieldRegistry(PluginResolver plugins) {
            this.plugins = plugins;
        }

        @Nullable
        public SoySourceFunctionMethod findField(String fieldName, SoyType baseType) {
            Preconditions.checkArgument((baseType.isNullOrUndefined() || !SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return ((ImmutableList)this.methodCache.getUnchecked((Object)fieldName)).stream().filter(method -> method.appliesToBase(baseType)).findFirst().orElse(null);
        }

        public ImmutableSet<String> getAllFieldNames(SoyType baseType) {
            return (ImmutableSet)this.plugins.getAllFieldNames().stream().flatMap(methodName -> ((ImmutableList)this.methodCache.getUnchecked(methodName)).stream()).filter(method -> method.appliesToBase(baseType)).map(SoySourceFunctionMethod::getMethodName).collect(ImmutableSet.toImmutableSet());
        }
    }

    private final class PluginMethodRegistry
    implements SoyMethod.Registry {
        private final PluginResolver plugins;
        private final LoadingCache<String, ImmutableList<SoySourceFunctionMethod>> methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ImmutableList<SoySourceFunctionMethod>>(){

            public ImmutableList<SoySourceFunctionMethod> load(String methodName) {
                return (ImmutableList)PluginMethodRegistry.this.plugins.lookupSoyMethods(methodName).stream().flatMap(function -> {
                    SoyMethodSignature methodSig = function.getClass().getAnnotation(SoyMethodSignature.class);
                    SourceFilePath fakeFunctionPath = SourceFilePath.create(function.getClass().getName(), function.getClass().getName());
                    SoyType baseType = ResolveExpressionTypesPass.this.parseType(methodSig.baseType(), fakeFunctionPath);
                    return Arrays.stream(methodSig.value()).map(signature -> {
                        SoyType returnType = ResolveExpressionTypesPass.this.parseType(signature.returnType(), fakeFunctionPath);
                        ImmutableList argTypes = (ImmutableList)Arrays.stream(signature.parameterTypes()).map(s -> ResolveExpressionTypesPass.this.parseType((String)s, fakeFunctionPath)).collect(ImmutableList.toImmutableList());
                        return new SoySourceFunctionMethod((SoySourceFunction)function, baseType, returnType, (ImmutableList<SoyType>)argTypes, methodSig.name());
                    });
                }).collect(ImmutableList.toImmutableList());
            }
        });

        PluginMethodRegistry(PluginResolver plugins) {
            this.plugins = plugins;
        }

        public ImmutableList<SoySourceFunctionMethod> matchForNameAndBase(String methodName, SoyType baseType) {
            Preconditions.checkArgument((!SoyTypes.isNullish(baseType) ? 1 : 0) != 0);
            return (ImmutableList)((ImmutableList)this.methodCache.getUnchecked((Object)methodName)).stream().filter(m -> m.appliesToBase(baseType)).collect(ImmutableList.toImmutableList());
        }

        @Override
        public ImmutableMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            this.plugins.getAllMethodNames().forEach(methodName -> {
                for (SoySourceFunctionMethod m : (ImmutableList)this.methodCache.getUnchecked(methodName)) {
                    if (!m.appliesToBase(baseType) || m.getNumArgs() != argTypes.size()) continue;
                    builder.put((Object)m, methodName);
                }
            });
            return builder.build();
        }
    }

    private static final class CompositeMethodRegistry
    implements SoyMethod.Registry {
        private final List<SoyMethod.Registry> registries;

        public CompositeMethodRegistry(List<SoyMethod.Registry> registries) {
            this.registries = registries;
        }

        @Override
        public ImmutableList<? extends SoyMethod> matchForNameAndBase(String methodName, SoyType baseType) {
            return (ImmutableList)this.registries.stream().flatMap(r -> r.matchForNameAndBase(methodName, baseType).stream()).collect(ImmutableList.toImmutableList());
        }

        @Override
        public ImmutableMultimap<SoyMethod, String> matchForBaseAndArgs(SoyType baseType, List<SoyType> argTypes) {
            ImmutableListMultimap.Builder combined = ImmutableListMultimap.builder();
            this.registries.forEach(r -> combined.putAll(r.matchForBaseAndArgs(baseType, argTypes)));
            return combined.build();
        }
    }

    private static enum UnknownPolicy {
        ALLOWED,
        DISALLOWED;

    }

    private final class ResolveTypesConstNodeVisitor
    extends ResolveTypesExprVisitor {
        ResolveTypesConstNodeVisitor() {
            super(false);
        }

        private void notAllowed(ExprNode node) {
            ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), NOT_ALLOWED_IN_CONSTANT_VALUE, new Object[0]);
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            this.notAllowed(node);
            super.visitFieldAccessNode(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            this.notAllowed(node);
            super.visitItemAccessNode(node);
        }

        @Override
        protected void visitNullNode(NullNode node) {
            if (node.getParent() instanceof ExprRootNode) {
                this.notAllowed(node);
            }
            super.visitNullNode(node);
        }

        @Override
        protected void visitUndefinedNode(UndefinedNode node) {
            if (node.getParent() instanceof ExprRootNode) {
                this.notAllowed(node);
            }
            super.visitUndefinedNode(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.isResolved() && node.getSoyFunction() != BuiltinFunction.PROTO_INIT && node.getSoyFunction() != BuiltinFunction.CSS && node.getSoyFunction() != BuiltinFunction.XID && node.getSoyFunction() != BuiltinFunction.VE_DEF) {
                this.notAllowed(node);
            }
            super.visitFunctionNode(node);
        }

        @Override
        protected void visitMethodCallNode(MethodCallNode node) {
            super.visitMethodCallNode(node);
            if (!node.isMethodResolved() || node.getSoyMethod() != BuiltinMethod.BIND) {
                this.notAllowed(node);
            }
        }

        @Override
        protected void visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            this.notAllowed(node);
            super.visitAssertNonNullOpNode(node);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.notAllowed(node);
            super.visitNullCoalescingOpNode(node);
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
            this.notAllowed(node);
            super.visitNullSafeAccessNode(node);
        }
    }

    private class ResolveTypesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        final boolean inferringParam;
        private final AbstractExprNodeVisitor<Void> checkAllTypesAssignedVisitor = new AbstractExprNodeVisitor<Void>(){

            @Override
            protected void visitExprNode(ExprNode node) {
                if (node instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)node);
                }
                ResolveTypesExprVisitor.this.requireNodeType(node);
            }
        };

        ResolveTypesExprVisitor(boolean inferringParam) {
            this.inferringParam = inferringParam;
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            this.checkAllTypesAssignedVisitor.exec(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
            ExprNode expr = node.getRoot();
            node.setType(expr.getType());
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            this.visitChildren(node);
            this.finishAssertNonNullOpNode(node);
        }

        private void finishAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            ExprNode child = node.getChild(0);
            SoyType type = child.getType();
            if (type.isNullOrUndefined()) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, "use the non-null assertion operator ('!')");
                node.setType(UnknownType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), REDUNDANT_NON_NULL_ASSERTION_OPERATOR, new Object[0]);
                node.setType(UnknownType.getInstance());
            } else {
                node.setType(SoyTypes.tryRemoveNullish(type));
            }
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
            ArrayList<SoyType> elementTypes = new ArrayList<SoyType>(node.numChildren());
            for (ExprNode child : node.getChildren()) {
                this.requireNodeType(child);
                elementTypes.add(child.getType());
            }
            if (elementTypes.isEmpty()) {
                if (this.inferringParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "an empty list");
                }
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, elementTypes)));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            this.visit(node.getListExpr());
            SoyType listExprType = node.getListExpr().getType();
            if (!SoyTypes.isKindOrUnionOfKind(listExprType, SoyType.Kind.LIST) && listExprType.getKind() != SoyType.Kind.UNKNOWN) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getListExpr().getSourceLocation(), BAD_LIST_COMP_TYPE, node.getListExpr().toSourceString(), listExprType);
                node.getListIterVar().setType(UnknownType.getInstance());
            } else if (listExprType.getKind() == SoyType.Kind.UNKNOWN) {
                node.getListIterVar().setType(UnknownType.getInstance());
            } else {
                SoyType listElementType = SoyTypes.getListElementType(listExprType);
                if (listElementType == null) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getListExpr().getSourceLocation(), EMPTY_LIST_COMPREHENSION, new Object[0]);
                    node.getListIterVar().setType(UnknownType.getInstance());
                } else {
                    node.getListIterVar().setType(listElementType);
                }
            }
            if (node.getIndexVar() != null) {
                node.getIndexVar().setType(IntType.getInstance());
            }
            TypeSubstitutions.Checkpoint savedSubstitutions = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            if (node.getFilterExpr() != null) {
                this.visit(node.getFilterExpr());
                TypeNarrowingConditionVisitor typeNarrowing = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
                typeNarrowing.ifTruthy(node.getFilterExpr());
                ResolveExpressionTypesPass.this.substitutions.addAll(typeNarrowing.positiveTypeConstraints);
            }
            this.visit(node.getListItemTransformExpr());
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(node.getListItemTransformExpr().getType()));
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutions);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitRecordLiteralNode(RecordLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren == node.getKeys().size() ? 1 : 0) != 0);
            ArrayList<RecordType.Member> members = new ArrayList<RecordType.Member>();
            for (int i = 0; i < numChildren; ++i) {
                members.add(RecordType.memberOf(node.getKey(i).identifier(), false, node.getChild(i).getType()));
            }
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateRecordType(members));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren % 2 == 0 ? 1 : 0) != 0);
            if (numChildren == 0) {
                node.setType(MapType.EMPTY_MAP);
                if (this.inferringParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "an empty map");
                }
                return;
            }
            HashSet<String> duplicateKeyErrors = new HashSet<String>();
            LinkedHashMap<String, SoyType> recordFieldTypes = new LinkedHashMap<String, SoyType>();
            ArrayList<SoyType> keyTypes = new ArrayList<SoyType>(numChildren / 2);
            ArrayList<SoyType> valueTypes = new ArrayList<SoyType>(numChildren / 2);
            ErrorReporter.Checkpoint checkpoint = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
            for (int i = 0; i < numChildren; i += 2) {
                String fieldName;
                SoyType prev;
                ExprNode key = node.getChild(i);
                ExprNode value = node.getChild(i + 1);
                if (key.getKind() == ExprNode.Kind.STRING_NODE && (prev = recordFieldTypes.put(fieldName = ((StringNode)key).getValue(), value.getType())) != null && duplicateKeyErrors.add(fieldName)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), DUPLICATE_KEY_IN_MAP_LITERAL, fieldName);
                }
                keyTypes.add(key.getType());
                if (!MapType.isAllowedKeyType(key.getType())) {
                    ResolveExpressionTypesPass.this.errorReporter.report(key.getSourceLocation(), MapType.BAD_MAP_KEY_TYPE, key.getType());
                }
                valueTypes.add(value.getType());
            }
            SoyType commonKeyType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, keyTypes);
            if (!ResolveExpressionTypesPass.this.errorReporter.errorsSince(checkpoint) && !MapType.isAllowedKeyType(commonKeyType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), ILLEGAL_MAP_RESOLVED_KEY_TYPE, commonKeyType);
            }
            SoyType commonValueType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, valueTypes);
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(commonKeyType, commonValueType));
            this.tryApplySubstitution(node);
        }

        private boolean isListOfKeyValueRecords(SoyType type) {
            if (!(type instanceof ListType)) {
                return false;
            }
            ListType listType = (ListType)type;
            if (!(listType.getElementType() instanceof RecordType)) {
                return false;
            }
            RecordType recordType = (RecordType)listType.getElementType();
            return ImmutableSet.copyOf(recordType.getMemberNames()).equals(MapLiteralFromListNode.MAP_RECORD_FIELDS);
        }

        @Override
        protected void visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            this.visit(node.getListExpr());
            if (node.getListExpr().getType().equals(ListType.EMPTY_LIST)) {
                node.setType(MapType.EMPTY_MAP);
                if (this.inferringParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), AMBIGUOUS_INFERRED_TYPE, "an empty map");
                }
                return;
            }
            if (!this.isListOfKeyValueRecords(node.getListExpr().getType())) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getListExpr().getSourceLocation(), BAD_MAP_LITERAL_FROM_LIST_TYPE, node.getListExpr().toSourceString(), node.getListExpr().getType());
                node.setType(MapType.EMPTY_MAP);
                return;
            }
            SoyType keyType = ((RecordType)((ListType)node.getListExpr().getType()).getElementType()).getMemberType("key");
            SoyType valueType = ((RecordType)((ListType)node.getListExpr().getType()).getElementType()).getMemberType("value");
            if (!MapType.isAllowedKeyType(keyType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), MapType.BAD_MAP_KEY_TYPE, keyType);
            }
            node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(keyType, valueType));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            SoyType newType;
            TemplateImportType templateType;
            VarDefn defn;
            if (ResolveExpressionTypesPass.this.allTemplateTypes != null && (defn = varRef.getDefnDecl()) != null && defn.hasType() && defn.type().getKind() == SoyType.Kind.TEMPLATE_TYPE && (templateType = (TemplateImportType)defn.type()).getBasicTemplateType() == null) {
                String fqn = templateType.getName();
                TemplateMetadata metadataFromLib = ResolveExpressionTypesPass.this.templateRegistryFromDeps.get().getBasicTemplateOrElement(fqn);
                if (metadataFromLib != null) {
                    templateType.setBasicTemplateType(metadataFromLib.getTemplateType());
                } else {
                    templateType.setBasicTemplateType((TemplateType)ResolveExpressionTypesPass.this.allTemplateTypes.get((Object)fqn));
                }
            }
            if ((newType = ResolveExpressionTypesPass.this.substitutions.getTypeSubstitution(varRef)) != null) {
                varRef.setSubstituteType(newType);
            } else if (!varRef.hasType()) {
                if (this.inferringParam) {
                    ResolveExpressionTypesPass.this.errorReporter.report(varRef.getSourceLocation(), CANNOT_USE_INFERRED_TYPES, new Object[0]);
                    varRef.setSubstituteType(UnknownType.getInstance());
                } else {
                    throw new IllegalStateException("VarRefNode @" + String.valueOf(varRef.getSourceLocation()) + " doesn't have a type!");
                }
            }
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
            this.visit(nullSafeAccessNode.getBase());
            this.visitNullSafeAccessNodeRecurse(nullSafeAccessNode);
        }

        private void visitNullSafeAccessNodeRecurse(NullSafeAccessNode nullSafeAccessNode) {
            ExprNode.ParentExprNode dataAccess;
            ExprNode nsBaseExpr;
            SoyType maybeSubstitutedType;
            SoyType baseType;
            if (nullSafeAccessNode.getBase().getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                ResolveExpressionTypesPass.this.errorReporter.report(nullSafeAccessNode.getSourceLocation(), UNNECESSARY_NULL_SAFE_ACCESS, new Object[0]);
            }
            SoyType soyType = baseType = (maybeSubstitutedType = ResolveExpressionTypesPass.this.substitutions.getTypeSubstitution(nsBaseExpr = nullSafeAccessNode.asMergedBase())) != null ? maybeSubstitutedType : nullSafeAccessNode.getBase().getType();
            if (nullSafeAccessNode.getDataAccess().getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
                dataAccess = (NullSafeAccessNode)nullSafeAccessNode.getDataAccess();
                this.calculateAccessChainTypes(nsBaseExpr, baseType, (DataAccessNode)dataAccess.getBase());
                this.visitNullSafeAccessNodeRecurse((NullSafeAccessNode)dataAccess);
            } else if (nullSafeAccessNode.getDataAccess() instanceof ExprNode.AccessChainComponentNode) {
                dataAccess = (ExprNode.AccessChainComponentNode)nullSafeAccessNode.getDataAccess();
                DataAccessNode childDataAccess = this.getDataAccessChild((ExprNode.AccessChainComponentNode)dataAccess);
                this.calculateAccessChainTypes(nsBaseExpr, baseType, childDataAccess);
                this.finishAssertNonNullOpNodeChain((ExprNode.AccessChainComponentNode)dataAccess);
            }
            SoyType type = nullSafeAccessNode.getDataAccess().getType();
            if (SoyTypes.isNullish(nullSafeAccessNode.getBase().getType()) && !this.hasNonNullAssertion(nullSafeAccessNode.getDataAccess())) {
                type = SoyTypes.makeUndefinable(type);
            }
            nullSafeAccessNode.setType(type);
            this.tryApplySubstitution(nullSafeAccessNode);
        }

        private ExprNode getTail(ExprNode expr) {
            while (expr instanceof NullSafeAccessNode) {
                expr = ((NullSafeAccessNode)expr).getDataAccess();
            }
            return expr;
        }

        private boolean hasNonNullAssertion(ExprNode expr) {
            return this.hasNonNullAssertionRecurse(this.getTail(expr));
        }

        private boolean hasNonNullAssertionRecurse(ExprNode expr) {
            if (expr instanceof OperatorNodes.AssertNonNullOpNode) {
                return true;
            }
            if (!(expr instanceof DataAccessNode)) {
                return false;
            }
            return this.hasNonNullAssertionRecurse(((DataAccessNode)expr).getBaseExprChild());
        }

        private DataAccessNode getDataAccessChild(ExprNode.AccessChainComponentNode expr) {
            ExprNode.AccessChainComponentNode child = expr;
            while (child.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                child = (ExprNode.AccessChainComponentNode)child.getChild(0);
            }
            return (DataAccessNode)child;
        }

        private void finishAssertNonNullOpNodeChain(ExprNode.AccessChainComponentNode node) {
            if (node.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode nonNullNode = (OperatorNodes.AssertNonNullOpNode)node;
                this.finishAssertNonNullOpNodeChain((ExprNode.AccessChainComponentNode)nonNullNode.getChild(0));
                this.finishAssertNonNullOpNode(nonNullNode);
            }
        }

        private void calculateAccessChainTypes(ExprNode nsBaseExpr, SoyType baseType, DataAccessNode dataAccess) {
            boolean nullSafe = true;
            if (dataAccess.getBaseExprChild() instanceof DataAccessNode) {
                this.calculateAccessChainTypes(nsBaseExpr, baseType, (DataAccessNode)dataAccess.getBaseExprChild());
                nullSafe = false;
                SoyType maybeSubstitutedType = ResolveExpressionTypesPass.this.substitutions.getTypeSubstitution(NullSafeAccessNode.copyAndGraftPlaceholders((DataAccessNode)dataAccess.getBaseExprChild(), (ImmutableList<ExprNode>)ImmutableList.of((Object)nsBaseExpr)));
                baseType = maybeSubstitutedType != null ? maybeSubstitutedType : dataAccess.getBaseExprChild().getType();
                ((DataAccessNode)dataAccess.getBaseExprChild()).setType(baseType);
            } else if (dataAccess.getBaseExprChild().getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode baseExpr = (OperatorNodes.AssertNonNullOpNode)dataAccess.getBaseExprChild();
                DataAccessNode childDataAccess = this.getDataAccessChild(baseExpr);
                this.calculateAccessChainTypes(nsBaseExpr, baseType, childDataAccess);
                this.finishAssertNonNullOpNodeChain(baseExpr);
                nullSafe = false;
                baseType = dataAccess.getBaseExprChild().getType();
            }
            ExprNode base = dataAccess.getBaseExprChild();
            if (NullSafeAccessNode.isPlaceholder(base)) {
                GroupNode node = new GroupNode(new UndefinedNode(base.getSourceLocation()), base.getSourceLocation(), true);
                node.setType(baseType);
                base.getParent().replaceChild(base, node);
            }
            switch (dataAccess.getKind()) {
                case FIELD_ACCESS_NODE: {
                    this.finishFieldAccessNode((FieldAccessNode)dataAccess, nullSafe);
                    break;
                }
                case ITEM_ACCESS_NODE: {
                    this.finishItemAccessNode((ItemAccessNode)dataAccess, nullSafe);
                    break;
                }
                case METHOD_CALL_NODE: {
                    this.finishMethodCallNode((MethodCallNode)dataAccess, nullSafe);
                    break;
                }
                default: {
                    throw new AssertionError((Object)dataAccess.getKind());
                }
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishFieldAccessNode(node, false);
        }

        private void finishFieldAccessNode(FieldAccessNode node, boolean nullSafe) {
            SoyType baseType = node.getBaseExprChild().getType();
            if (nullSafe) {
                baseType = SoyTypes.tryRemoveNullish(baseType);
            }
            SoyType nonNullType = SoyTypes.tryRemoveNullish(baseType);
            SoySourceFunctionMethod fieldImpl = ResolveExpressionTypesPass.this.fieldRegistry.findField(node.getFieldName(), nonNullType);
            if (fieldImpl != null) {
                if (!nonNullType.equals(baseType)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getAccessSourceLocation(), NULLISH_FIELD_ACCESS, new Object[0]);
                }
                node.setType(fieldImpl.getReturnType());
                node.setSoyMethod(fieldImpl);
            } else {
                node.setType(this.getFieldType(baseType, node.getFieldName(), node.getAccessSourceLocation()));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishItemAccessNode(node, false);
        }

        private void finishItemAccessNode(ItemAccessNode node, boolean nullSafe) {
            this.visit(node.getKeyExprChild());
            SoyType itemType = this.getItemTypeForAccessNode(node.getBaseExprChild().getType(), node.getKeyExprChild().getType(), nullSafe, node.getAccessSourceLocation(), node.getKeyExprChild().getSourceLocation());
            node.setType(itemType);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMethodCallNode(MethodCallNode node) {
            Preconditions.checkState((!node.isNullSafe() ? 1 : 0) != 0);
            this.visit(node.getBaseExprChild());
            this.finishMethodCallNode(node, false);
            this.tryApplySubstitution(node);
        }

        private void finishMethodCallNode(MethodCallNode node, boolean nullSafe) {
            for (ExprNode child : node.getParams()) {
                this.visit(child);
            }
            SoyType baseType = node.getBaseType(nullSafe);
            SoyMethod method = this.resolveMethodFromBaseType(node, baseType);
            if (method == null) {
                node.setType(UnknownType.getInstance());
                return;
            }
            node.setSoyMethod(method);
            if (method instanceof BuiltinMethod) {
                node.setType(((BuiltinMethod)method).getReturnType(node, ResolveExpressionTypesPass.this.typeRegistry, ResolveExpressionTypesPass.this.errorReporter));
            } else if (method instanceof SoySourceFunctionMethod) {
                SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)method;
                SoySourceFunction sourceFunction = sourceMethod.getImpl();
                if (sourceFunction instanceof ConcatListsFunction) {
                    node.setType(this.getGenericListType(node.getChildren()));
                } else if (sourceFunction instanceof ConcatMapsMethod) {
                    node.setType(this.getGenericMapType(node.getChildren()));
                } else if (sourceFunction instanceof MapKeysFunction) {
                    if (baseType.equals(MapType.EMPTY_MAP)) {
                        node.setType(ListType.EMPTY_LIST);
                    } else {
                        node.setType(ListType.of(SoyTypes.getMapKeysType(baseType)));
                    }
                } else if (sourceFunction instanceof MapValuesMethod) {
                    if (baseType.equals(MapType.EMPTY_MAP)) {
                        node.setType(ListType.EMPTY_LIST);
                    } else {
                        node.setType(ListType.of(SoyTypes.getMapValuesType(baseType)));
                    }
                } else if (sourceFunction instanceof MapEntriesMethod) {
                    if (baseType.equals(MapType.EMPTY_MAP)) {
                        node.setType(ListType.EMPTY_LIST);
                    } else {
                        node.setType(ListType.of(RecordType.of((Iterable<RecordType.Member>)ImmutableList.of((Object)RecordType.memberOf("key", false, SoyTypes.getMapKeysType(baseType)), (Object)RecordType.memberOf("value", false, SoyTypes.getMapValuesType(baseType))))));
                    }
                } else if (sourceFunction instanceof ListSliceMethod || sourceFunction instanceof ListReverseMethod || sourceFunction instanceof ListUniqMethod) {
                    node.setType(baseType);
                } else if (sourceFunction instanceof NumberListSortMethod) {
                    node.setType(baseType);
                } else if (sourceFunction instanceof ListFlatMethod) {
                    int maxDepth = node.numParams() == 1 ? (node.getParam(0).getKind() == ExprNode.Kind.INTEGER_NODE ? (int)((IntegerNode)node.getParam(0)).getValue() : 0) : 1;
                    node.setType(sourceMethod.getReturnType());
                    ListType returnType = (ListType)baseType;
                    while (maxDepth-- > 0) {
                        UnionType unionType;
                        if (returnType.getElementType().getKind() == SoyType.Kind.LIST) {
                            returnType = (ListType)returnType.getElementType();
                            continue;
                        }
                        if (returnType.getElementType().getKind() != SoyType.Kind.UNION || !SoyTypes.containsKinds(unionType = (UnionType)returnType.getElementType(), (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)SoyType.Kind.LIST)))) break;
                        returnType = null;
                        break;
                    }
                    if (returnType != null) {
                        node.setType(returnType);
                    }
                } else {
                    node.setType(sourceMethod.getReturnType());
                }
            } else {
                throw new AssertionError();
            }
        }

        @Nullable
        private SoyMethod resolveMethodFromBaseType(MethodCallNode node, SoyType baseType) {
            if (SoyTypes.isNullish(baseType)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getBaseExprChild().getSourceLocation(), METHOD_BASE_TYPE_NULL_SAFE_REQUIRED, baseType);
                return null;
            }
            int numParams = node.numChildren() - 1;
            String methodName = node.getMethodName().identifier();
            SourceLocation srcLoc = node.getAccessSourceLocation();
            List<SoyType> argTypes = node.getParams().stream().map(ExprNode::getType).collect(Collectors.toList());
            ImmutableList<? extends SoyMethod> matchNameAndType = ResolveExpressionTypesPass.this.methodRegistry.matchForNameAndBase(methodName, baseType);
            List andMatchArgCount = matchNameAndType.stream().filter(m -> m.getNumArgs() == numParams).collect(Collectors.toList());
            if (!matchNameAndType.isEmpty() && andMatchArgCount.isEmpty()) {
                Set allNumArgs = (Set)matchNameAndType.stream().map(SoyMethod::getNumArgs).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
                String validSize = Joiner.on((String)" or ").join((Iterable)allNumArgs);
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, METHOD_INVALID_PARAM_NUM, methodName, numParams, validSize);
                return null;
            }
            List andMatchArgType = andMatchArgCount.stream().filter(m -> m.appliesToArgs(argTypes)).collect(Collectors.toList());
            if (andMatchArgType.size() == 1) {
                SoyMethod method = (SoyMethod)andMatchArgCount.get(0);
                PluginResolver.warnIfDeprecated(ResolveExpressionTypesPass.this.errorReporter, methodName, method, srcLoc);
                return method;
            }
            boolean replaceNode = true;
            if (!andMatchArgType.isEmpty()) {
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, MULTIPLE_METHODS_MATCH, methodName, numParams, baseType);
            } else if (!andMatchArgCount.isEmpty()) {
                String expected = Joiner.on((String)", ").join(((SoySourceFunctionMethod)andMatchArgCount.get(0)).getArgTypes());
                String actual = Joiner.on((String)", ").join(argTypes);
                ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, METHOD_INVALID_PARAM_TYPES, methodName, actual, expected);
            } else {
                String didYouMean = "";
                LinkedHashSet<String> matching = new LinkedHashSet<String>((Collection<String>)ResolveExpressionTypesPass.this.methodRegistry.matchForBaseAndArgs(baseType, argTypes).values());
                if (!matching.isEmpty()) {
                    didYouMean = SoyErrors.getDidYouMeanMessage(matching, methodName);
                }
                switch (ResolveExpressionTypesPass.this.pluginResolutionMode) {
                    case REQUIRE_DEFINITIONS: {
                        ResolveExpressionTypesPass.this.errorReporter.report(srcLoc, INVALID_METHOD_BASE, methodName, baseType, didYouMean);
                        break;
                    }
                    case ALLOW_UNDEFINED_AND_WARN: {
                        ResolveExpressionTypesPass.this.errorReporter.warn(srcLoc, INVALID_METHOD_BASE, methodName, baseType, didYouMean);
                        replaceNode = false;
                        break;
                    }
                    default: {
                        replaceNode = false;
                    }
                }
            }
            if (replaceNode) {
                GlobalNode.replaceExprWithError(node);
            }
            return null;
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            this.visitChildren(node);
            SoyType childType = node.getChild(0).getType();
            if (SoyTypes.isNumericOrUnknown(childType)) {
                node.setType(childType);
            } else {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP_UNARY, childType);
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitModOpNode(OperatorNodes.ModOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypePlusOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP, node.getOperator().getTokenString(), left, right);
                result = UnknownType.getInstance();
            }
            node.setType(result);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        private void visitLongOnlyOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            PrimitiveType result = IntType.getInstance();
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            if (left.getKind() != SoyType.Kind.INT || right.getKind() != SoyType.Kind.INT) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP, node.getOperator().getTokenString(), left, right);
                result = UnknownType.getInstance();
            }
            node.setType(result);
        }

        @Override
        protected void visitShiftLeftOpNode(OperatorNodes.ShiftLeftOpNode node) {
            this.visitLongOnlyOpNode(node);
        }

        @Override
        protected void visitShiftRightOpNode(OperatorNodes.ShiftRightOpNode node) {
            this.visitLongOnlyOpNode(node);
        }

        @Override
        protected void visitBitwiseOrOpNode(OperatorNodes.BitwiseOrOpNode node) {
            this.visitLongOnlyOpNode(node);
        }

        @Override
        protected void visitBitwiseXorOpNode(OperatorNodes.BitwiseXorOpNode node) {
            this.visitLongOnlyOpNode(node);
        }

        @Override
        protected void visitBitwiseAndOpNode(OperatorNodes.BitwiseAndOpNode node) {
            this.visitLongOnlyOpNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitTripleEqualOpNode(OperatorNodes.TripleEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitTripleNotEqualOpNode(OperatorNodes.TripleNotEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.processAnd(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitAmpAmpOpNode(OperatorNodes.AmpAmpOpNode node) {
            this.processAnd(node);
            node.setType(UnionType.of(node.getChild(0).getType(), node.getChild(1).getType()));
        }

        private void processAnd(AbstractOperatorNode node) {
            this.visit(node.getChild(0));
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            TypeNarrowingConditionVisitor visitor = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
            visitor.ifTruthy(node.getChild(0));
            ResolveExpressionTypesPass.this.substitutions.addAll(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.processOr(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitBarBarOpNode(OperatorNodes.BarBarOpNode node) {
            this.processOr(node);
            node.setType(UnionType.of(node.getChild(0).getType(), node.getChild(1).getType()));
        }

        private void processOr(AbstractOperatorNode node) {
            ExprNode lhs = node.getChild(0);
            if (SoyTreeUtils.isConstantExpr(lhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getOperatorLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, lhs.toSourceString());
            }
            this.visit(lhs);
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            TypeNarrowingConditionVisitor visitor = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
            visitor.ifTruthy(lhs);
            ResolveExpressionTypesPass.this.substitutions.addAll(visitor.negativeTypeConstraints);
            ExprNode rhs = node.getChild(1);
            this.visit(rhs);
            if (SoyTreeUtils.isConstantExpr(rhs)) {
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getOperatorLocation(), OR_OPERATOR_HAS_CONSTANT_OPERAND, rhs.toSourceString());
            }
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            TypeNarrowingConditionVisitor visitor = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
            visitor.ifNonNullish(node.getChild(0));
            ResolveExpressionTypesPass.this.substitutions.addAll(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
            if (node.getChild(1) instanceof StringNode && ((StringNode)node.getChild(1)).getValue().isEmpty() && SoyTypes.tryRemoveNullish(node.getChild(0).getType()).getKind() == SoyType.Kind.ATTRIBUTES) {
                node.setType(SoyTypes.tryRemoveNullish(node.getChild(0).getType()));
            } else {
                SoyType resultType = node.getChild(1).getType();
                if (!SoyTypes.isNullOrUndefined(node.getChild(0).getType())) {
                    resultType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, SoyTypes.tryRemoveNullish(node.getChild(0).getType()), resultType);
                }
                node.setType(resultType);
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            TypeNarrowingConditionVisitor visitor = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
            visitor.ifTruthy(node.getChild(0));
            ResolveExpressionTypesPass.this.substitutions.addAll(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
            ResolveExpressionTypesPass.this.substitutions.addAll(visitor.negativeTypeConstraints);
            this.visit(node.getChild(2));
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
            if (node.getChild(1) instanceof StringNode && ((StringNode)node.getChild(1)).getValue().isEmpty() && SoyTypes.tryRemoveNullish(node.getChild(2).getType()).getKind() == SoyType.Kind.ATTRIBUTES) {
                node.setType(node.getChild(2).getType());
            } else if (node.getChild(2) instanceof StringNode && ((StringNode)node.getChild(2)).getValue().isEmpty() && SoyTypes.tryRemoveNullish(node.getChild(1).getType()).getKind() == SoyType.Kind.ATTRIBUTES) {
                node.setType(node.getChild(1).getType());
            } else {
                node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getChild(1).getType(), node.getChild(2).getType()));
            }
            this.tryApplySubstitution(node);
        }

        @Nullable
        private ResolvedSignature getOrCreateFunctionSignature(Signature signature, String className, ErrorReporter errorReporter) {
            ResolvedSignature resolvedSignature = ResolveExpressionTypesPass.this.signatureMap.get(signature);
            if (resolvedSignature != null) {
                return resolvedSignature;
            }
            ImmutableList.Builder paramTypes = ImmutableList.builder();
            SourceFilePath classFilePath = SourceFilePath.create(className, className);
            for (String paramTypeString : signature.parameterTypes()) {
                TypeNode paramType = SoyFileParser.parseType(paramTypeString, classFilePath, errorReporter);
                if (paramType == null) {
                    return null;
                }
                paramTypes.add((Object)ResolveExpressionTypesPass.this.pluginTypeConverter.getOrCreateType(paramType));
            }
            TypeNode returnType = SoyFileParser.parseType(signature.returnType(), classFilePath, errorReporter);
            if (returnType == null) {
                return null;
            }
            resolvedSignature = ResolvedSignature.create((ImmutableList<SoyType>)paramTypes.build(), ResolveExpressionTypesPass.this.pluginTypeConverter.getOrCreateType(returnType));
            ResolveExpressionTypesPass.this.signatureMap.put(signature, resolvedSignature);
            return resolvedSignature;
        }

        private boolean maybeSetExtern(FunctionNode node, List<FunctionNode.ExternRef> externTypes) {
            List matching = externTypes.stream().filter(t -> this.paramsMatchFunctionType(node.getParams(), t.signature())).collect(Collectors.toList());
            if (matching.size() == 1) {
                FunctionNode.ExternRef ref = (FunctionNode.ExternRef)matching.get(0);
                node.setAllowedParamTypes(ref.signature().getParameters().stream().map(FunctionType.Parameter::getType).collect(Collectors.toList()));
                node.setType(ref.signature().getReturnType());
                node.setSoyFunction(ref);
                return true;
            }
            return false;
        }

        private boolean paramsMatchFunctionType(List<ExprNode> providedParams, FunctionType functionType) {
            ImmutableList<FunctionType.Parameter> functParams = functionType.getParameters();
            if (functParams.size() != providedParams.size()) {
                return false;
            }
            for (int i = 0; i < providedParams.size(); ++i) {
                SoyType providedType = providedParams.get(i).getType();
                SoyType paramType = ((FunctionType.Parameter)functParams.get(i)).getType();
                if (paramType.isAssignableFromLoose(providedType) || providedType == UnknownType.getInstance()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (!node.hasStaticName() && !node.allowedToInvokeAsFunction() && (node.getNameExpr().getType() instanceof TemplateImportType || node.getNameExpr().getType() instanceof TemplateType)) {
                if (node.getParent() instanceof FunctionNode && ((FunctionNode)node.getParent()).allowedToInvokeAsFunction()) {
                    node.setAllowedToInvokeAsFunction(true);
                } else {
                    node.setType(UnknownType.getInstance());
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), MUST_USE_TEMPLATES_IMMEDIATELY, new Object[0]);
                    node.setAllowedToInvokeAsFunction(true);
                    this.visitChildren(node);
                    return;
                }
            }
            this.visitChildren(node);
            if (!node.hasStaticName()) {
                this.visit(node.getNameExpr());
                if (node.getNameExpr().getType().getKind() == SoyType.Kind.TEMPLATE_TYPE) {
                    node.setType(SanitizedType.getTypeForContentKind(((TemplateImportType)node.getNameExpr().getType()).getBasicTemplateType().getContentKind().getSanitizedContentKind()));
                    return;
                }
                if (node.getNameExpr().getType().getKind() == SoyType.Kind.TEMPLATE) {
                    node.setType(SanitizedType.getTypeForContentKind(((TemplateType)node.getNameExpr().getType()).getContentKind().getSanitizedContentKind()));
                    return;
                }
                if (node.getNameExpr().getType().getKind() == SoyType.Kind.FUNCTION) {
                    if (node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED) {
                        ResolveExpressionTypesPass.this.errorReporter.report(node.getFunctionNameLocation(), INCORRECT_ARG_STYLE, new Object[0]);
                        node.setSoyFunction(FunctionNode.UNRESOLVED);
                    } else {
                        List<FunctionNode.ExternRef> externTypes;
                        String functionName = ((VarRefNode)node.getNameExpr()).getName();
                        SourceLogicalPath filePath = ResolveExpressionTypesPass.this.currentFile.getFilePath().asLogicalPath();
                        VarDefn defn = ((VarRefNode)node.getNameExpr()).getDefnDecl();
                        if (defn.kind() == VarDefn.Kind.IMPORT_VAR) {
                            filePath = ((ImportedVar)defn).getSourceFilePath();
                            functionName = ((ImportedVar)defn).getSymbol();
                        }
                        if (this.maybeSetExtern(node, externTypes = ResolveExpressionTypesPass.this.externsTypeLookup.getRefs(filePath, functionName))) {
                            this.visitInternalExtern(node);
                            this.tryApplySubstitution(node);
                            return;
                        }
                        if (!externTypes.isEmpty()) {
                            String providedParamTypes = "'" + node.getParams().stream().map(e -> e.getType().toString()).collect(Collectors.joining(", ")) + "'";
                            String allowedTypes = externTypes.stream().map(t -> t.signature().getParameters().stream().map(p -> p.getType().toString()).collect(Collectors.joining(", "))).collect(Collectors.joining("', '", "'", "'"));
                            ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), externTypes.size() == 1 ? NO_SUCH_EXTERN_OVERLOAD_1 : NO_SUCH_EXTERN_OVERLOAD_N, providedParamTypes, allowedTypes);
                            node.setSoyFunction(FunctionNode.UNRESOLVED);
                        }
                    }
                }
            }
            if (!node.isResolved() || node.getSoyFunction() == FunctionNode.UNRESOLVED) {
                node.setType(UnknownType.getInstance());
                return;
            }
            Object knownFunction = node.getSoyFunction();
            if (knownFunction.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                Preconditions.checkState((knownFunction instanceof TypedSoyFunction || knownFunction instanceof SoySourceFunction ? 1 : 0) != 0, (Object)"Classes annotated with @SoyFunctionSignature must either extend TypedSoyFunction or implement SoySourceFunction.");
                this.visitSoyFunctionWithSignature(knownFunction.getClass().getAnnotation(SoyFunctionSignature.class), knownFunction.getClass().getCanonicalName(), node);
            } else if (knownFunction instanceof BuiltinFunction) {
                this.visitBuiltinFunction((BuiltinFunction)knownFunction, node);
            }
            this.visitInternalSoyFunction(knownFunction, node);
            this.tryApplySubstitution(node);
            if (node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL && node.getAllowedParamTypes() == null) {
                node.setAllowedParamTypes(Collections.nCopies(node.numParams(), UnknownType.getInstance()));
            }
        }

        private void visitSoyFunctionWithSignature(SoyFunctionSignature fnSignature, String className, FunctionNode node) {
            ResolvedSignature matchedSignature = null;
            for (Signature signature : fnSignature.value()) {
                if (signature.parameterTypes().length != node.numParams()) continue;
                matchedSignature = this.getOrCreateFunctionSignature(signature, className, ResolveExpressionTypesPass.this.errorReporter);
                if (signature.deprecatedWarning().isEmpty()) break;
                ResolveExpressionTypesPass.this.errorReporter.warn(node.getFunctionNameLocation(), PluginResolver.DEPRECATED_PLUGIN, fnSignature.name(), signature.deprecatedWarning());
                break;
            }
            if (matchedSignature == null) {
                node.setType(UnknownType.getInstance());
                return;
            }
            if (node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getFunctionNameLocation(), INCORRECT_ARG_STYLE, new Object[0]);
                return;
            }
            for (int i = 0; i < node.numParams(); ++i) {
                this.checkArgType(node.getParam(i), (SoyType)matchedSignature.parameterTypes().get(i), node);
            }
            node.setAllowedParamTypes((List<SoyType>)matchedSignature.parameterTypes());
            node.setType(matchedSignature.returnType());
        }

        private void visitKeysFunction(FunctionNode node) {
            ListType listType;
            SoyType argType = node.getParam(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                listType = ListType.EMPTY_LIST;
            } else {
                SoyType listArg;
                if (argType.getKind() == SoyType.Kind.LEGACY_OBJECT_MAP) {
                    listArg = ((LegacyObjectMapType)argType).getKeyType();
                } else if (argType.getKind() == SoyType.Kind.LIST) {
                    listArg = IntType.getInstance();
                } else if (argType.getKind() == SoyType.Kind.MAP) {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), KEYS_PASSED_MAP, new Object[0]);
                    listArg = UnknownType.getInstance();
                } else {
                    listArg = UnknownType.getInstance();
                }
                listType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(listArg);
            }
            node.setType(listType);
        }

        private void visitLegacyObjectMapToMapFunction(FunctionNode node) {
            SoyType argType = node.getParam(0).getType();
            if (argType.equals(LegacyObjectMapType.EMPTY_MAP)) {
                node.setType(MapType.EMPTY_MAP);
            } else if (argType == UnknownType.getInstance()) {
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), UnknownType.getInstance()));
            } else {
                LegacyObjectMapType actualArgType = (LegacyObjectMapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitMapToLegacyObjectMapFunction(FunctionNode node) {
            SoyType argType = node.getParam(0).getType();
            if (argType.equals(MapType.EMPTY_MAP)) {
                node.setType(LegacyObjectMapType.EMPTY_MAP);
            } else {
                MapType actualArgType = (MapType)argType;
                node.setType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateLegacyObjectMapType(StringType.getInstance(), actualArgType.getValueType()));
            }
        }

        private void visitProtoInitFunction(FunctionNode node) {
            SoyType soyType = ((FunctionNode)node).getNameExpr().getType();
            if (soyType.getKind() != SoyType.Kind.PROTO_TYPE) {
                ResolveExpressionTypesPass.this.errorReporter.report(((FunctionNode)node).getNameExpr().getSourceLocation(), NOT_PROTO_MESSAGE, new Object[0]);
                ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                return;
            }
            ProtoImportType type = (ProtoImportType)((FunctionNode)node).getNameExpr().getType();
            String protoFqn = type.toString();
            if (SoyTypes.SAFE_PROTO_TO_SANITIZED_TYPE.containsKey((Object)protoFqn)) {
                ResolveExpressionTypesPass.this.errorReporter.report(((AbstractExprNode)node).getSourceLocation(), TypeNodeConverter.SAFE_PROTO_TYPE, SoyTypes.SAFE_PROTO_TO_SANITIZED_TYPE.get((Object)protoFqn), protoFqn);
                ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                return;
            }
            SoyProtoType protoType = (SoyProtoType)ResolveExpressionTypesPass.this.typeRegistry.getProtoRegistry().getProtoType(protoFqn);
            ((AbstractParentExprNode)node).setType(protoType);
            if (((FunctionNode)node).getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.POSITIONAL) {
                ResolveExpressionTypesPass.this.errorReporter.report(((AbstractExprNode)node).getSourceLocation(), INCORRECT_ARG_STYLE, new Object[0]);
                return;
            }
            HashSet<String> givenParams = new HashSet<String>();
            ImmutableSet<String> fields = protoType.getFieldNames();
            boolean hasAliasedParams = false;
            ArrayList<Identifier> resolvedIdentifiers = new ArrayList<Identifier>();
            ErrorReporter.Checkpoint checkpoint = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
            for (Identifier id : ((FunctionNode)node).getParamNames()) {
                String originalName = id.identifier();
                boolean hasOriginal = fields.contains((Object)originalName);
                boolean hasOriginalExt = hasOriginal && protoType.getFieldDescriptor(originalName).isExtension();
                Identifier resolvedName = ResolveExpressionTypesPass.this.typeRegistry.resolve(id);
                if (resolvedName == null) {
                    if (hasOriginalExt) {
                        ResolveExpressionTypesPass.this.errorReporter.report(id.location(), PROTO_EXT_FQN, new Object[0]);
                    }
                } else if (!resolvedName.identifier().equals(originalName)) {
                    if (hasOriginal && !hasOriginalExt) {
                        ResolveExpressionTypesPass.this.errorReporter.report(id.location(), PROTO_FIELD_NAME_IMPORT_CONFLICT, originalName, protoType.getDescriptor().getName());
                        ((AbstractParentExprNode)node).setType(UnknownType.getInstance());
                        continue;
                    }
                    hasAliasedParams = true;
                    id = resolvedName;
                }
                resolvedIdentifiers.add(id);
                givenParams.add(id.identifier());
            }
            if (hasAliasedParams && !ResolveExpressionTypesPass.this.errorReporter.errorsSince(checkpoint)) {
                FunctionNode resolvedNode = CallableExprBuilder.builder((FunctionNode)node).setParamNames(resolvedIdentifiers).buildFunction();
                resolvedNode.setSoyFunction(((FunctionNode)node).getSoyFunction());
                resolvedNode.setType(((AbstractParentExprNode)node).getType());
                ((AbstractExprNode)node).getParent().replaceChild(node, resolvedNode);
                node = resolvedNode;
            }
            for (String field : fields) {
                if (!protoType.getFieldDescriptor(field).isRequired() || givenParams.contains(field)) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(((AbstractExprNode)node).getSourceLocation(), PROTO_MISSING_REQUIRED_FIELD, field);
            }
            for (int i = 0; i < ((FunctionNode)node).numParams(); ++i) {
                SoyType argElementType;
                SoyType fieldType;
                Identifier fieldName = (Identifier)((FunctionNode)node).getParamNames().get(i);
                ExprNode expr = ((FunctionNode)node).getParam(i);
                if (!fields.contains((Object)fieldName.identifier())) {
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(fields, protoType.getDescriptor(), fieldName.identifier());
                    ResolveExpressionTypesPass.this.errorReporter.report(fieldName.location(), PROTO_FIELD_DOES_NOT_EXIST, fieldName.identifier(), protoType, extraErrorMessage);
                    continue;
                }
                SoyType argType = expr.getType();
                if (argType.isNullOrUndefined()) {
                    ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), PROTO_NULL_ARG_TYPE, fieldName.identifier());
                }
                if ((fieldType = protoType.getFieldType(fieldName.identifier())).getKind() == SoyType.Kind.LIST && argType.getKind() == SoyType.Kind.LIST && ((argElementType = ((ListType)argType).getElementType()) == null || argElementType.equals(UnknownType.getInstance()))) continue;
                SoyType expectedType = SoyTypes.makeNullish(fieldType);
                if (!expectedType.isAssignableFromLoose(argType)) {
                    argType = RuntimeTypeCoercion.maybeCoerceType(expr, expectedType instanceof UnionType ? ((UnionType)expectedType).getMembers() : ImmutableList.of((Object)expectedType));
                }
                if (expectedType.isAssignableFromLoose(argType)) continue;
                ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), CheckTemplateCallsPass.ARGUMENT_TYPE_MISMATCH, fieldName.identifier() + "-c", expectedType, argType);
            }
        }

        @Override
        protected void visitTemplateLiteralNode(TemplateLiteralNode node) {
            if (this.inferringParam) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), TEMPLATE_TYPE_PARAMETERS_CANNOT_USE_INFERRED_TYPES, new Object[0]);
                node.setType(UnknownType.getInstance());
                return;
            }
            this.visitChildren(node);
            SoyType existingType = node.getType();
            if (existingType.getKind() == SoyType.Kind.TEMPLATE_TYPE) {
                TemplateType basicType = ((TemplateImportType)existingType).getBasicTemplateType();
                node.setType((SoyType)Preconditions.checkNotNull((Object)basicType, (String)"No type for %s", (Object)node.getResolvedName()));
            }
        }

        private void visitComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitEqualComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeEqualComparisonOp());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitArithmeticOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            boolean isDivide = node instanceof OperatorNodes.DivideByOpNode;
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeArithmeticOperator());
            if (result == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getOperatorLocation(), INCOMPATIBLE_ARITHMETIC_OP, node.getOperator().getTokenString(), left, right);
                result = UnknownType.getInstance();
            }
            node.setType(isDivide ? FloatType.getInstance() : result);
            this.tryApplySubstitution(node);
        }

        private void requireNodeType(ExprNode node) {
            if (node.getType() == null) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), MISSING_SOY_TYPE, node.getClass().getName());
            }
        }

        private SoyType getFieldType(SoyType baseType, String fieldName, SourceLocation sourceLocation) {
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case RECORD: {
                    RecordType recordType = (RecordType)baseType;
                    SoyType fieldType = recordType.getMemberType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessage(recordType.getMemberNames(), fieldName);
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_RECORD_TYPE, fieldName, baseType, extraErrorMessage);
                    return UnknownType.getInstance();
                }
                case PROTO: {
                    SoyProtoType protoType = (SoyProtoType)baseType;
                    SoyType fieldType = protoType.getFieldType(fieldName);
                    if (fieldType != null) {
                        this.emitProtoFieldError(protoType, fieldName, sourceLocation, false);
                    } else {
                        String suggestedName = this.getSuggestedProtoFieldName(protoType, fieldName);
                        if (suggestedName != null) {
                            fieldType = protoType.getFieldType(suggestedName);
                            this.emitProtoFieldError(protoType, suggestedName, sourceLocation, true);
                        } else {
                            this.emitDefaultFieldNotFoundError(baseType, fieldName, sourceLocation);
                            fieldType = UnknownType.getInstance();
                        }
                    }
                    return SoyTypes.tryRemoveNullish(fieldType);
                }
                case LEGACY_OBJECT_MAP: {
                    ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD, baseType);
                    return UnknownType.getInstance();
                }
                case UNION: {
                    ErrorReporter.Checkpoint cp = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.isNullOrUndefined()) continue;
                        SoyType fieldType = this.getFieldType(unionMember, fieldName, sourceLocation);
                        if (ResolveExpressionTypesPass.this.errorReporter.errorsSince(cp)) {
                            return fieldType;
                        }
                        fieldTypes.add(fieldType);
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, fieldTypes);
                }
                case TEMPLATE_TYPE: 
                case TEMPLATE_MODULE: 
                case PROTO_TYPE: 
                case PROTO_EXTENSION: {
                    return UnknownType.getInstance();
                }
            }
            this.emitDefaultFieldNotFoundError(baseType, fieldName, sourceLocation);
            return UnknownType.getInstance();
        }

        private String getSuggestedProtoFieldName(SoyProtoType protoType, String fieldName) {
            if (protoType.getFieldNames().contains((Object)(fieldName + "List"))) {
                return fieldName + "List";
            }
            if (protoType.getFieldNames().contains((Object)(fieldName + "Map"))) {
                return fieldName + "Map";
            }
            return SoyErrors.getClosest(protoType.getFieldNames(), fieldName);
        }

        private void emitDefaultFieldNotFoundError(SoyType baseType, String fieldName, SourceLocation sourceLocation) {
            ImmutableSet<String> allFields = ResolveExpressionTypesPass.this.fieldRegistry.getAllFieldNames(SoyTypes.tryRemoveNullish(baseType));
            String didYouMean = allFields.isEmpty() ? "" : SoyErrors.getDidYouMeanMessage(allFields, fieldName);
            ResolveExpressionTypesPass.this.errorReporter.report(sourceLocation, NO_SUCH_FIELD, fieldName, baseType, didYouMean);
        }

        private void emitProtoFieldError(SoyProtoType baseType, String fieldName, SourceLocation sourceLocation, boolean isSuggestedFieldName) {
        }

        private SoyType getItemTypeForAccessNode(SoyType baseType, SoyType keyType, boolean isNullSafe, SourceLocation baseLocation, SourceLocation keyLocation) {
            Preconditions.checkNotNull((Object)baseType);
            Preconditions.checkNotNull((Object)keyType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case LIST: {
                    ListType listType = (ListType)baseType;
                    if (listType.equals(ListType.EMPTY_LIST)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_LIST_ACCESS, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    if (!IntType.getInstance().isAssignableFromLoose(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_INDEX_TYPE, keyType, baseType);
                    }
                    return listType.getElementType();
                }
                case LEGACY_OBJECT_MAP: {
                    AbstractMapType mapType = (AbstractMapType)baseType;
                    if (mapType.equals(LegacyObjectMapType.EMPTY_MAP) || mapType.equals(MapType.EMPTY_MAP)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, EMPTY_MAP_ACCESS, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    if (!mapType.getKeyType().isAssignableFromLoose(keyType)) {
                        ResolveExpressionTypesPass.this.errorReporter.report(keyLocation, BAD_KEY_TYPE, keyType, baseType);
                    }
                    return mapType.getValueType();
                }
                case UNION: {
                    ErrorReporter.Checkpoint cp = ResolveExpressionTypesPass.this.errorReporter.checkpoint();
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> itemTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.isNullOrUndefined()) continue;
                        SoyType itemType = this.getItemTypeForAccessNode(unionMember, keyType, isNullSafe, baseLocation, keyLocation);
                        if (ResolveExpressionTypesPass.this.errorReporter.errorsSince(cp)) {
                            return itemType;
                        }
                        itemTypes.add(itemType);
                    }
                    if (SoyTypes.isNullish(unionType) && !isNullSafe) {
                        ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NULLABLE_UNION, new Object[0]);
                        return UnknownType.getInstance();
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, itemTypes);
                }
                case RECORD: 
                case PROTO: 
                case TEMPLATE_TYPE: 
                case TEMPLATE_MODULE: 
                case PROTO_TYPE: 
                case PROTO_EXTENSION: 
                case ANY: 
                case NULL: 
                case UNDEFINED: 
                case BOOL: 
                case INT: 
                case FLOAT: 
                case STRING: 
                case MAP: 
                case ELEMENT: 
                case HTML: 
                case ATTRIBUTES: 
                case JS: 
                case CSS: 
                case URI: 
                case TRUSTED_RESOURCE_URI: 
                case PROTO_ENUM: 
                case TEMPLATE: 
                case VE: 
                case VE_DATA: 
                case MESSAGE: 
                case CSS_TYPE: 
                case CSS_MODULE: 
                case TOGGLE_TYPE: 
                case PROTO_ENUM_TYPE: 
                case PROTO_MODULE: 
                case FUNCTION: {
                    ResolveExpressionTypesPass.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NOT_SUPPORTED, baseType);
                    return UnknownType.getInstance();
                }
            }
            throw new AssertionError((Object)("unhandled kind: " + String.valueOf((Object)baseType.getKind())));
        }

        private void tryApplySubstitution(AbstractParentExprNode parentNode) {
            SoyType newType = ResolveExpressionTypesPass.this.substitutions.getTypeSubstitution(parentNode);
            if (newType != null) {
                if (!parentNode.getType().isAssignableFromStrict(newType)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(parentNode.getSourceLocation(), INVALID_TYPE_SUBSTITUTION, parentNode.getType(), newType);
                }
                parentNode.setType(newType);
            }
        }

        private void validateBuiltinArgTypes(BuiltinFunction builtinFunction, FunctionNode node) {
            builtinFunction.getValidArgTypes().ifPresent(typeList -> {
                node.setAllowedParamTypes((List<SoyType>)typeList);
                for (int i = 0; i < typeList.size(); ++i) {
                    if (((SoyType)typeList.get(i)).isAssignableFromStrict(node.getParam(i).getType())) continue;
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getParam(i).getSourceLocation(), INCORRECT_ARG_TYPE, builtinFunction.getName(), node.getParam(i).getType(), typeList.get(i));
                }
            });
        }

        private void visitBuiltinFunction(BuiltinFunction builtinFunction, FunctionNode node) {
            this.validateBuiltinArgTypes(builtinFunction, node);
            switch (builtinFunction) {
                case CHECK_NOT_NULL: {
                    SoyType type = node.getParam(0).getType();
                    if (type.isNullOrUndefined()) {
                        ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, "call checkNotNull");
                        break;
                    }
                    node.setType(SoyTypes.tryRemoveNullish(type));
                    break;
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case CSS: {
                    this.checkArgIsStringLiteralWithNoSpaces(node, node.numParams() - 1, builtinFunction);
                    node.setType(StringType.getInstance());
                    break;
                }
                case EVAL_TOGGLE: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case SOY_SERVER_KEY: 
                case XID: {
                    node.setType(StringType.getInstance());
                    break;
                }
                case UNKNOWN_JS_GLOBAL: {
                    this.checkArgIsStringLiteral(node, 0, builtinFunction);
                    node.setType(UnknownType.getInstance());
                    break;
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case VE_DATA: {
                    node.setType(VeDataType.getInstance());
                    break;
                }
                case VE_DEF: {
                    if (node.numParams() >= 3) {
                        node.setType(VeType.of(node.getParam(2).getType().toString()));
                        break;
                    }
                    node.setType(VeType.NO_DATA);
                    break;
                }
                case TO_FLOAT: 
                case REMAINDER: {
                    node.setType(IntType.getInstance());
                    break;
                }
                case MSG_WITH_ID: {
                    node.setType(RecordType.of((Iterable<RecordType.Member>)ImmutableList.of((Object)RecordType.memberOf("id", false, StringType.getInstance()), (Object)RecordType.memberOf("msg", false, node.numParams() > 0 ? node.getParam(0).getType() : UnknownType.getInstance()))));
                    break;
                }
                case LEGACY_DYNAMIC_TAG: {
                    node.setType(StringType.getInstance());
                    break;
                }
                case PROTO_INIT: {
                    this.visitProtoInitFunction(node);
                    break;
                }
                case UNDEFINED_TO_NULL: 
                case UNDEFINED_TO_NULL_SSR: {
                    this.visit(node.getParam(0));
                    node.setType(SoyTypes.undefinedToNull(node.getParam(0).getType()));
                    break;
                }
                case BOOLEAN: 
                case HAS_CONTENT: 
                case IS_TRUTHY_NON_EMPTY: {
                    node.setType(BoolType.getInstance());
                    break;
                }
                case EMPTY_TO_NULL: {
                    throw new AssertionError((Object)("impossible, this is only used by desuraging passes: " + String.valueOf(node)));
                }
            }
        }

        private void checkArgIsStringLiteralWithNoSpaces(FunctionNode node, int childIndex, BuiltinFunction funcName) {
            StringNode stringNode = this.checkArgIsStringLiteral(node, childIndex, funcName);
            if (stringNode != null && Pattern.compile("\\s+").matcher(stringNode.getValue()).find()) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), BAD_CLASS_STRING, new Object[0]);
            }
        }

        @Nullable
        @CanIgnoreReturnValue
        private StringNode checkArgIsStringLiteral(FunctionNode node, int childIndex, BuiltinFunction funcName) {
            if (childIndex < 0 || childIndex >= node.numParams()) {
                return null;
            }
            ExprNode arg = node.getParam(childIndex);
            if (!(arg instanceof StringNode)) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), STRING_LITERAL_REQUIRED, funcName.getName());
                return null;
            }
            return (StringNode)arg;
        }

        private void visitInternalExtern(FunctionNode node) {
            FunctionNode.ExternRef externRef = (FunctionNode.ExternRef)node.getSoyFunction();
            if (externRef.path().path().endsWith("java/soy/plugins/functions.soy") && externRef.name().equals("unpackAny")) {
                ExprNode secondParam = node.getParam(1);
                node.setType(secondParam.getType());
            }
        }

        private void visitInternalSoyFunction(Object fn, FunctionNode node) {
            if (fn instanceof LegacyObjectMapToMapFunction) {
                if (this.checkArgType(node.getParam(0), LegacyObjectMapType.ANY_MAP, node)) {
                    this.visitLegacyObjectMapToMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof MapToLegacyObjectMapFunction) {
                if (this.checkArgType(node.getParam(0), MapType.ANY_MAP, node, UnknownPolicy.DISALLOWED)) {
                    this.visitMapToLegacyObjectMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof KeysFunction) {
                this.visitKeysFunction(node);
            } else if (fn instanceof ConcatListsFunction) {
                node.setType(this.getGenericListType(node.getParams()));
            } else if (fn instanceof LoggingFunction) {
                node.setType(StringType.getInstance());
            } else if (fn instanceof MaxFunction || fn instanceof MinFunction) {
                if (node.numParams() > 1) {
                    node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesPass.this.typeRegistry, node.getParam(0).getType(), node.getParam(1).getType()));
                }
            } else if (node.getType() == null) {
                node.setType(UnknownType.getInstance());
            }
        }

        private SoyType getGenericListType(Iterable<ExprNode> intersectionOf) {
            ImmutableSet.Builder elementTypesBuilder = ImmutableSet.builder();
            for (ExprNode childNode : intersectionOf) {
                if (!(childNode.getType() instanceof ListType)) {
                    return UnknownType.getInstance();
                }
                SoyType elementType = ((ListType)childNode.getType()).getElementType();
                if (elementType == null) continue;
                elementTypesBuilder.add((Object)elementType);
            }
            ImmutableSet elementTypes = elementTypesBuilder.build();
            return elementTypes.isEmpty() ? ListType.EMPTY_LIST : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateListType(ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)elementTypes));
        }

        private SoyType getGenericMapType(Iterable<ExprNode> intersectionOf) {
            ImmutableSet.Builder keyTypesBuilder = ImmutableSet.builder();
            ImmutableSet.Builder valueTypesBuilder = ImmutableSet.builder();
            for (ExprNode childNode : intersectionOf) {
                if (!(childNode.getType() instanceof MapType)) {
                    return UnknownType.getInstance();
                }
                MapType mapType = (MapType)childNode.getType();
                if (mapType.getKeyType() != null) {
                    keyTypesBuilder.add((Object)mapType.getKeyType());
                }
                if (mapType.getValueType() == null) continue;
                valueTypesBuilder.add((Object)mapType.getValueType());
            }
            ImmutableSet keys = keyTypesBuilder.build();
            ImmutableSet values = valueTypesBuilder.build();
            return MapType.of(keys.isEmpty() ? UnknownType.getInstance() : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)keys), values.isEmpty() ? UnknownType.getInstance() : ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType((Collection<SoyType>)values));
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node) {
            return this.checkArgType(arg, expectedType, node, UnknownPolicy.ALLOWED);
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node, UnknownPolicy policy) {
            if (!expectedType.isAssignableFromLoose(arg.getType()) || policy == UnknownPolicy.DISALLOWED && arg.getType() == UnknownType.getInstance()) {
                ResolveExpressionTypesPass.this.errorReporter.report(arg.getSourceLocation(), INCORRECT_ARG_TYPE, node.getStaticFunctionName(), arg.getType(), expectedType);
                return false;
            }
            return true;
        }
    }

    private final class TypeAssignmentSoyVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final ImmutableSet<SoyType.Kind> allowedSwitchTypes = ImmutableSet.of((Object)((Object)SoyType.Kind.BOOL), (Object)((Object)SoyType.Kind.INT), (Object)((Object)SoyType.Kind.FLOAT), (Object)((Object)SoyType.Kind.STRING), (Object)((Object)SoyType.Kind.PROTO_ENUM), (Object)((Object)SoyType.Kind.UNKNOWN), (Object[])new SoyType.Kind[]{SoyType.Kind.ANY});
        private final ImmutableSet<SoyType.Kind> allowedVariantTypes = ImmutableSet.of((Object)((Object)SoyType.Kind.STRING), (Object)((Object)SoyType.Kind.INT), (Object)((Object)SoyType.Kind.PROTO_ENUM), (Object)((Object)SoyType.Kind.UNKNOWN));

        private TypeAssignmentSoyVisitor() {
        }

        @Override
        protected void visitImportNode(ImportNode node) {
            node.visitVars((var, parentType) -> {
                if (!var.hasType()) {
                    SoyType newType = UnknownType.getInstance();
                    if (parentType != null && parentType.getKind() == SoyType.Kind.TEMPLATE_MODULE) {
                        SoyType constantType;
                        TemplateModuleImportType moduleType = (TemplateModuleImportType)parentType;
                        String symbol = var.getSymbol();
                        if (moduleType.getConstantNames().contains((Object)symbol) && (constantType = ResolveExpressionTypesPass.this.constantsTypeLookup.get(moduleType.getPath(), symbol)) != null) {
                            newType = constantType;
                        }
                    }
                    var.setType(newType);
                }
            });
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ArrayList<TemplateStateVar> allStateVars = new ArrayList<TemplateStateVar>();
            HashMultimap stateToStateDeps = HashMultimap.create();
            ImmutableList<TemplateHeaderVarDefn> headerVars = node.getHeaderParams();
            for (TemplateHeaderVarDefn headerVar2 : headerVars) {
                if (headerVar2 instanceof TemplateStateVar) {
                    allStateVars.add((TemplateStateVar)headerVar2);
                }
                if (headerVar2.getTypeNode() != null && headerVar2.type().isNullOrUndefined()) {
                    ResolveExpressionTypesPass.this.errorReporter.report(headerVar2.getTypeNode().sourceLocation(), EXPLICIT_NULL, new Object[0]);
                }
                if (headerVar2.defaultValue() == null) continue;
                block7: for (ExprNode nonConstantChild : SoyTreeUtils.getNonConstantChildren(headerVar2.defaultValue())) {
                    ExprNode.Kind kind = nonConstantChild.getKind();
                    switch (kind) {
                        case VAR_REF_NODE: {
                            VarRefNode refNode = (VarRefNode)nonConstantChild;
                            if (headerVar2 instanceof TemplateStateVar) {
                                if (!(refNode.getDefnDecl() instanceof TemplateStateVar)) continue block7;
                                stateToStateDeps.put((Object)((TemplateStateVar)headerVar2), (Object)((TemplateStateVar)refNode.getDefnDecl()));
                                continue block7;
                            }
                            ResolveExpressionTypesPass.this.errorReporter.report(nonConstantChild.getSourceLocation(), PARAM_DEPENDS_ON_PARAM, new Object[0]);
                            refNode.setSubstituteType(UnknownType.getInstance());
                            continue block7;
                        }
                        case FUNCTION_NODE: {
                            if (headerVar2 instanceof TemplateStateVar) continue block7;
                            ResolveExpressionTypesPass.this.errorReporter.report(nonConstantChild.getSourceLocation(), PARAM_DEPENDS_ON_FUNCTION, new Object[0]);
                            continue block7;
                        }
                    }
                    throw new AssertionError((Object)("Unexpected non-constant expression: " + String.valueOf(nonConstantChild)));
                }
            }
            TopoSort<TemplateStateVar> topoSort = new TopoSort<TemplateStateVar>();
            try {
                topoSort.sort(allStateVars, arg_0 -> ((SetMultimap)stateToStateDeps).get(arg_0));
            }
            catch (NoSuchElementException e) {
                ImmutableList cycle = topoSort.getCyclicKeys();
                String cycleText = cycle.stream().map(AbstractVarDefn::name).collect(Collectors.joining(" --> "));
                ResolveExpressionTypesPass.this.errorReporter.report(((TemplateStateVar)cycle.get(0)).getSourceLocation(), STATE_CYCLE, cycleText);
            }
            node.getHeaderParams().stream().filter(headerVar -> headerVar.defaultValue() != null && headerVar.getTypeNode() != null).forEach(headerVar -> {
                ResolveExpressionTypesPass.this.exprVisitor.exec(headerVar.defaultValue());
                SoyType actualType = headerVar.defaultValue().getRoot().getType();
                SoyType declaredType = headerVar.type();
                if (!declaredType.isAssignableFromStrict(actualType)) {
                    actualType = RuntimeTypeCoercion.maybeCoerceType(headerVar.defaultValue().getRoot(), SoyTypes.expandUnions(declaredType));
                }
                if (!declaredType.isAssignableFromLoose(actualType)) {
                    SourceLocation loc = headerVar.defaultValue().getSourceLocation();
                    if (!loc.isKnown()) {
                        loc = headerVar.getSourceLocation();
                    }
                    ResolveExpressionTypesPass.this.errorReporter.report(loc, DECLARED_DEFAULT_TYPE_MISMATCH, headerVar.name(), actualType, declaredType);
                }
            });
            for (ExprRootNode expr : node.getExprList()) {
                if (expr.getType() != null) continue;
                ResolveExpressionTypesPass.this.exprVisitor.exec(expr);
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.allowShortFormCall(node.getExpr());
            this.visitSoyNode(node);
        }

        @Override
        protected void visitConstNode(ConstNode node) {
            ResolveExpressionTypesPass.this.constExprVisitor.exec(node.getExpr());
            SoyType type = node.getExpr().getType();
            if (SoyTypes.isNullish(type)) {
                ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CONSTANTS_CANT_BE_NULLABLE, type);
            }
            node.getVar().setType(type);
            ResolveExpressionTypesPass.this.constantsTypeLookup.put(node);
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            this.allowShortFormCall(node.getExpr());
            this.visitSoyNode(node);
            node.getVar().setType(node.getExpr().getType());
        }

        @Override
        protected void visitCallParamValueNode(CallParamValueNode node) {
            this.allowShortFormCall(node.getExpr());
            this.visitSoyNode(node);
        }

        private void allowShortFormCall(ExprRootNode rootNode) {
            FunctionNode fnNode;
            if (rootNode.getRoot() instanceof FunctionNode && !(fnNode = (FunctionNode)rootNode.getRoot()).hasStaticName() && (fnNode.getNameExpr().getType() instanceof TemplateImportType || fnNode.getNameExpr().getType() instanceof TemplateType)) {
                fnNode.setAllowedToInvokeAsFunction(true);
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitSoyNode(node);
            if (node.isImplicitContentKind()) {
                if (node.numChildren() != 1 || !(node.getChild(0) instanceof CallBasicNode)) {
                    if (ResolveExpressionTypesPass.this.rewriteShortFormCalls) {
                        ResolveExpressionTypesPass.this.errorReporter.report(node.getSourceLocation(), CAN_OMIT_KIND_ONLY_FOR_SINGLE_CALL, new Object[0]);
                    }
                    node.setContentKind(SanitizedContentKind.HTML);
                } else {
                    CallBasicNode callNode = (CallBasicNode)node.getChild(0);
                    SoyType templateType = callNode.getCalleeExpr().getType();
                    if (templateType instanceof TemplateType) {
                        node.setContentKind(((TemplateType)templateType).getContentKind().getSanitizedContentKind());
                    } else {
                        node.setContentKind(SanitizedContentKind.HTML);
                    }
                }
            }
            node.getVar().setType(node.getContentKind() != null ? SanitizedType.getTypeForContentKind(node.getContentKind()) : StringType.getInstance());
        }

        @Override
        protected void visitIfNode(IfNode node) {
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(icn);
                    TypeNarrowingConditionVisitor visitor = ResolveExpressionTypesPass.this.createTypeNarrowingConditionVisitor();
                    visitor.ifTruthy(icn.getExpr());
                    TypeSubstitutions.Checkpoint previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
                    ResolveExpressionTypesPass.this.substitutions.addAll(visitor.positiveTypeConstraints);
                    this.visitChildren(icn);
                    ResolveExpressionTypesPass.this.substitutions.restore(previousSubstitutionState);
                    ResolveExpressionTypesPass.this.substitutions.addAll(visitor.negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof IfElseNode)) continue;
                IfElseNode ien = (IfElseNode)child;
                this.visitChildren(ien);
            }
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            ResolveExpressionTypesPass.this.visitExpressions(node);
            TypeSubstitutions.Checkpoint savedSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
            ExprNode switchExpr = node.getExpr().getRoot();
            SoyType switchExprType = switchExpr.getType();
            boolean exprTypeError = false;
            if (SoyTypes.isNullOrUndefined(switchExprType) || !SoyTypes.isKindOrUnionOfKinds(SoyTypes.tryRemoveNullish(switchExprType), this.allowedSwitchTypes)) {
                ResolveExpressionTypesPass.this.errorReporter.report(switchExpr.getSourceLocation(), ILLEGAL_SWITCH_EXPRESSION_TYPE, switchExprType);
                exprTypeError = true;
            } else if (SoyTypes.tryRemoveNullish(switchExprType).getKind() == SoyType.Kind.PROTO_ENUM) {
                switchExprType = UnionType.of(switchExprType, IntType.getInstance());
            }
            SoyType switchExprNarrowedType = switchExpr.getType();
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    ResolveExpressionTypesPass.this.visitExpressions(scn);
                    ArrayList<SoyType> caseTypes = new ArrayList<SoyType>();
                    for (ExprRootNode expr : scn.getExprList()) {
                        SoyType type = expr.getType();
                        caseTypes.add(type);
                        if (expr.getRoot().getKind() == ExprNode.Kind.NULL_NODE) {
                            switchExprNarrowedType = SoyTypes.tryRemoveNull(switchExprNarrowedType);
                        } else if (expr.getRoot().getKind() == ExprNode.Kind.UNDEFINED_NODE) {
                            switchExprNarrowedType = SoyTypes.tryRemoveUndefined(switchExprNarrowedType);
                        }
                        if (exprTypeError || type.getKind() == SoyType.Kind.UNKNOWN || type.isNullOrUndefined() || switchExprType.isAssignableFromLoose(type)) continue;
                        ResolveExpressionTypesPass.this.errorReporter.report(expr.getSourceLocation(), SWITCH_CASE_TYPE_MISMATCH, type, switchExprType);
                    }
                    SoyType caseType = ResolveExpressionTypesPass.this.typeRegistry.getOrCreateUnionType(caseTypes);
                    TypeSubstitutions.Checkpoint previousSubstitutionState = ResolveExpressionTypesPass.this.substitutions.checkpoint();
                    HashMap<ExprEquivalence.Wrapper, SoyType> positiveTypeConstraints = new HashMap<ExprEquivalence.Wrapper, SoyType>();
                    positiveTypeConstraints.put(ResolveExpressionTypesPass.this.exprEquivalence.wrap(switchExpr), caseType);
                    ResolveExpressionTypesPass.this.substitutions.addAll(positiveTypeConstraints);
                    this.visitChildren(scn);
                    ResolveExpressionTypesPass.this.substitutions.restore(previousSubstitutionState);
                    if (switchExpr.getType().equals(switchExprNarrowedType)) continue;
                    HashMap<ExprEquivalence.Wrapper, SoyType> negativeTypeConstraints = new HashMap<ExprEquivalence.Wrapper, SoyType>();
                    negativeTypeConstraints.put(ResolveExpressionTypesPass.this.exprEquivalence.wrap(switchExpr), switchExprNarrowedType);
                    ResolveExpressionTypesPass.this.substitutions.addAll(negativeTypeConstraints);
                    continue;
                }
                if (!(child instanceof SwitchDefaultNode)) continue;
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.visitChildren(sdn);
            }
            ResolveExpressionTypesPass.this.substitutions.restore(savedSubstitutionState);
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            node.getVar().setType(ResolveExpressionTypesPass.this.getElementType(node.getExpr().getType(), node));
            if (node.getIndexVar() != null) {
                node.getIndexVar().setType(IntType.getInstance());
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            super.visitMsgPluralNode(node);
            SoyType exprType = node.getExpr().getType();
            if (exprType != UnknownType.getInstance() && !SoyTypes.isIntFloatOrNumber(exprType)) {
                SoyType notNullable = SoyTypes.tryRemoveNullish(exprType);
                if (!notNullable.equals(exprType) && SoyTypes.isIntFloatOrNumber(notNullable)) {
                    ResolveExpressionTypesPass.this.errorReporter.warn(node.getExpr().getSourceLocation(), PLURAL_EXPR_NULLABLE, exprType);
                } else {
                    ResolveExpressionTypesPass.this.errorReporter.report(node.getExpr().getSourceLocation(), PLURAL_EXPR_TYPE, exprType);
                }
            }
        }

        @Override
        protected void visitCallDelegateNode(CallDelegateNode node) {
            long variantInt;
            super.visitCallDelegateNode(node);
            ExprRootNode variant = node.getDelCalleeVariantExpr();
            if (variant == null) {
                return;
            }
            SourceLocation location = variant.getSourceLocation();
            SoyType variantType = variant.getType();
            if (SoyTypes.isNullOrUndefined(variantType) || !SoyTypes.isKindOrUnionOfKinds(SoyTypes.tryRemoveNullish(variantType), this.allowedVariantTypes)) {
                ResolveExpressionTypesPass.this.errorReporter.report(location, BAD_DELCALL_VARIANT_TYPE, variantType);
            }
            if (variant.getRoot().getKind() == ExprNode.Kind.STRING_NODE) {
                String variantStr = ((StringNode)variant.getRoot()).getValue();
                if (!BaseUtils.isIdentifier(variantStr)) {
                    ResolveExpressionTypesPass.this.errorReporter.report(location, INVALID_VARIANT_EXPRESSION, variantStr);
                }
            } else if (variant.getRoot().getKind() == ExprNode.Kind.INTEGER_NODE && (variantInt = ((IntegerNode)variant.getRoot()).getValue()) < 0L) {
                ResolveExpressionTypesPass.this.errorReporter.report(location, INVALID_VARIANT_EXPRESSION, variant.toSourceString());
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ExprHolderNode) {
                ResolveExpressionTypesPass.this.visitExpressions((SoyNode.ExprHolderNode)node);
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private final class CollectTemplateTypesVisitor
    extends AbstractSoyNodeVisitor<Map<String, TemplateType>> {
        private Map<String, TemplateType> types;

        private CollectTemplateTypesVisitor() {
        }

        @Override
        public Map<String, TemplateType> exec(SoyNode node) {
            this.types = new HashMap<String, TemplateType>();
            this.visit(node);
            return this.types;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            node.getHeaderParams().stream().filter(headerVar -> headerVar.defaultValue() != null && headerVar.getTypeNode() == null).forEach(headerVar -> {
                ResolveExpressionTypesPass.this.paramInfExprVisitor.exec(headerVar.defaultValue());
                headerVar.setType(headerVar.defaultValue().getRoot().getType());
            });
            this.types.put(node.getTemplateName(), TemplateMetadata.buildTemplateType(node));
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            node.getTemplates().forEach(this::visit);
        }
    }
}

