/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;

final class EnforceExperimentalFeaturesPass
implements CompilerFilePass {
    private static final ImmutableSet<String> ALL_EXPERIMENTAL_FEATURES = ImmutableSet.of((Object)"testonly_throw_on_warnings");
    private static final SoyErrorKind INVALID_EXPERIMENTAL_FEATURE = SoyErrorKind.of("Invalid Soy experimental feature(s): {0}.", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableSet<String> features;
    private final ErrorReporter reporter;

    EnforceExperimentalFeaturesPass(ImmutableSet<String> features, ErrorReporter reporter) {
        this.features = (ImmutableSet)Preconditions.checkNotNull(features);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (!ALL_EXPERIMENTAL_FEATURES.containsAll(this.features)) {
            this.reporter.report(SourceLocation.UNKNOWN, INVALID_EXPERIMENTAL_FEATURE, Sets.difference(this.features, ALL_EXPERIMENTAL_FEATURES));
        }
    }
}

