/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basicdirectives.BasicDirectives;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.StringType;
import java.util.Optional;

final class DesugarStateNodesPass
implements CompilerFileSetPass {
    DesugarStateNodesPass() {
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            SoyTreeUtils.allNodesOfType(template, HtmlOpenTagNode.class).filter(tag -> !tag.getTagName().isTemplateCall()).forEach(tag -> DesugarStateNodesPass.desugarSkipAndKeyNodes(tag, nodeIdGen));
            if (!(template instanceof TemplateElementNode)) continue;
            TemplateElementNode soyElement = (TemplateElementNode)template;
            ArrayListMultimap map = ArrayListMultimap.create();
            for (VarRefNode ref : SoyTreeUtils.getAllNodesOfType(template, VarRefNode.class)) {
                if (ref.getDefnDecl().kind() != VarDefn.Kind.STATE) continue;
                map.put((Object)ref.getDefnDecl(), (Object)ref);
            }
            int stateVarIndex = 0;
            for (TemplateStateVar stateVar : soyElement.getStateVars()) {
                LetValueNode node = new LetValueNode(nodeIdGen.genId(), stateVar.nameLocation(), "$" + stateVar.name(), stateVar.nameLocation(), stateVar.defaultValue().getRoot());
                node.getVar().setType(stateVar.type());
                soyElement.addChild(stateVarIndex, node);
                ++stateVarIndex;
                for (VarRefNode ref : map.get((Object)stateVar)) {
                    ref.setDefn(node.getVar());
                }
            }
            soyElement.clearStateVars();
        }
    }

    static FunctionNode extractKeyFunctionFromHtmlTag(HtmlOpenTagNode openTag) {
        FunctionNode wrappedFn = FunctionNode.newPositional(Identifier.create(BuiltinFunction.SOY_SERVER_KEY.getName(), openTag.getSourceLocation()), BuiltinFunction.SOY_SERVER_KEY, openTag.getSourceLocation());
        wrappedFn.setType(StringType.getInstance());
        if (openTag.getKeyNode() != null) {
            wrappedFn.addChild(openTag.getKeyNode().getExpr().getRoot().copy(new CopyState()));
        } else {
            FunctionNode funcNode = FunctionNode.newPositional(Identifier.create(BuiltinFunction.XID.getName(), SourceLocation.UNKNOWN), BuiltinFunction.XID, openTag.getSourceLocation());
            funcNode.addChild(new StringNode(openTag.getKeyId(), QuoteStyle.SINGLE, SourceLocation.UNKNOWN));
            funcNode.setType(StringType.getInstance());
            wrappedFn.addChild(funcNode);
        }
        return wrappedFn;
    }

    static void desugarSkipAndKeyNodes(HtmlOpenTagNode openTag, IdGenerator idGenerator) {
        block7: {
            Optional<SkipNode> skipNode;
            block6: {
                if (openTag.isSkipRoot()) break block6;
                if (openTag.getKeyNode() == null) break block7;
            }
            if ((skipNode = openTag.getChildren().stream().filter(c -> c instanceof SkipNode).map(SkipNode.class::cast).findFirst()).isPresent()) {
                HtmlAttributeNode skip = new HtmlAttributeNode(idGenerator.genId(), SourceLocation.UNKNOWN, null, false);
                skip.addChild(new RawTextNode(idGenerator.genId(), "soy-skip", SourceLocation.UNKNOWN));
                openTag.addChild(skip);
                if (!openTag.getTagName().isTemplateCall()) {
                    openTag.removeChild((SoyNode.StandaloneNode)skipNode.get());
                }
            }
            SourceLocation attributeSourceLocation = openTag.getKeyNode() != null ? openTag.getKeyNode().getSourceLocation() : skipNode.get().getSourceLocation();
            HtmlAttributeNode htmlAttributeNode = new HtmlAttributeNode(idGenerator.genId(), attributeSourceLocation, SourceLocation.Point.UNKNOWN_POINT, false);
            htmlAttributeNode.addChild(new RawTextNode(idGenerator.genId(), "ssk", SourceLocation.UNKNOWN));
            HtmlAttributeValueNode value = new HtmlAttributeValueNode(idGenerator.genId(), SourceLocation.UNKNOWN, HtmlAttributeValueNode.Quotes.SINGLE);
            FunctionNode wrappedFn = DesugarStateNodesPass.extractKeyFunctionFromHtmlTag(openTag);
            PrintNode printNode = new PrintNode(idGenerator.genId(), openTag.getSourceLocation(), true, wrappedFn, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            if (openTag.getKeyNode() != null) {
                PrintDirectiveNode newPrintDirective = PrintDirectiveNode.createSyntheticNode(idGenerator.genId(), Identifier.create(BasicDirectives.ESCAPE_HTML_ATTRIBUTE.getName(), printNode.getSourceLocation()), printNode.getSourceLocation(), BasicDirectives.ESCAPE_HTML_ATTRIBUTE);
                printNode.addChild(newPrintDirective);
            }
            printNode.getExpr().setType(wrappedFn.getType());
            printNode.setHtmlContext(HtmlContext.HTML_NORMAL_ATTR_VALUE);
            value.addChild(printNode);
            htmlAttributeNode.addChild(value);
            openTag.addChild(htmlAttributeNode);
        }
    }
}

