/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basicdirectives.BasicEscapeDirective;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;
import java.util.Optional;

public final class DesugarHtmlNodesPass
implements CompilerFileSetPass {
    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        for (SoyFileNode fileNode : sourceFiles) {
            this.run(fileNode, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    @VisibleForTesting
    public void run(SoyNode node, IdGenerator idGenerator) {
        new RewritingVisitor(idGenerator).exec(node);
    }

    private static final class RewritingVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final IdGenerator idGenerator;
        boolean needsSpaceForAttribute;
        boolean needsSpaceSelfClosingTag;
        private Optional<ImmutableList<SoyNode.StandaloneNode>> replacements = Optional.empty();

        RewritingVisitor(IdGenerator idGenerator) {
            this.idGenerator = idGenerator;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.needsSpaceForAttribute = false;
            this.visitChildren(node);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            this.needsSpaceForAttribute = true;
            this.visitChildren(tag);
            this.replacements = tag.isSynthetic() ? Optional.of(ImmutableList.of()) : Optional.of(ImmutableList.builder().add((Object)this.createPrefix(tag instanceof HtmlOpenTagNode ? "<" : "</", tag)).addAll(tag.getChildren()).add((Object)this.createSuffix(tag instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)tag).isSelfClosing() ? (this.needsSpaceSelfClosingTag ? " />" : "/>") : ">", tag)).build());
            this.needsSpaceForAttribute = false;
            this.needsSpaceSelfClosingTag = false;
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode openTag) {
            this.visitHtmlTagNode(openTag);
        }

        @Override
        protected void visitHtmlCommentNode(HtmlCommentNode node) {
            this.visitChildren(node);
            this.replacements = Optional.of(ImmutableList.builder().add((Object)this.createPrefix("<!--", node)).addAll(node.getChildren()).add((Object)this.createSuffix("-->", node)).build());
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            this.visitChildren(node);
            HtmlAttributeValueNode.Quotes quotes = node.getQuotes();
            if (quotes == HtmlAttributeValueNode.Quotes.NONE) {
                this.replacements = Optional.of(ImmutableList.copyOf(node.getChildren()));
                this.needsSpaceSelfClosingTag = true;
            } else {
                this.replacements = Optional.of(ImmutableList.builder().add((Object)this.createPrefix(quotes.getQuotationCharacter(), node)).addAll(node.getChildren()).add((Object)this.createSuffix(quotes.getQuotationCharacter(), node)).build());
                this.needsSpaceSelfClosingTag = false;
            }
        }

        private RawTextNode createPrefix(String prefix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getBeginLocation();
            if (prefix.length() > 1) {
                location = location.offsetEndCol(prefix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), prefix, location);
        }

        private RawTextNode createSuffix(String suffix, SoyNode context) {
            SourceLocation location = context.getSourceLocation().getEndLocation();
            if (suffix.length() > 1) {
                location = location.offsetEndCol(suffix.length() - 1);
            }
            return new RawTextNode(this.idGenerator.genId(), suffix, location);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            boolean needsDynamicSpace;
            this.visitChildren(node);
            ImmutableList.Builder builder = ImmutableList.builder();
            boolean bl = needsDynamicSpace = node.getStaticKey() == null && !node.hasValue();
            if (this.needsSpaceForAttribute && !needsDynamicSpace) {
                builder.add((Object)new RawTextNode(this.idGenerator.genId(), " ", node.getSourceLocation().getBeginLocation()));
            } else if (this.needsSpaceForAttribute && node.getStaticKey() == null) {
                BasicEscapeDirective.WhitespaceHtmlAttributesDirective whitespaceDirective = new BasicEscapeDirective.WhitespaceHtmlAttributesDirective();
                if (node.getChild(0) instanceof PrintNode) {
                    PrintDirectiveNode whitespaceDirectiveNode = PrintDirectiveNode.createSyntheticNode(this.idGenerator.genId(), Identifier.create("|whitespaceHtmlAttributes", node.getSourceLocation()), node.getSourceLocation());
                    whitespaceDirectiveNode.setPrintDirective(whitespaceDirective);
                    ((PrintNode)node.getChild(0)).addChild(whitespaceDirectiveNode);
                } else {
                    if (!(node.getChild(0) instanceof CallNode)) throw new AssertionError((Object)"Found node that is not PrintNode or CallNode inside HtmlAttributeNode");
                    CallNode typed = (CallNode)node.getChild(0);
                    typed.setEscapingDirectives((ImmutableList<SoyPrintDirective>)ImmutableList.builder().addAll(typed.getEscapingDirectives()).add((Object)whitespaceDirective).build());
                }
            } else {
                this.needsSpaceForAttribute = true;
            }
            builder.add((Object)((SoyNode.StandaloneNode)node.getChild(0)));
            if (node.hasValue()) {
                builder.add((Object)new RawTextNode(this.idGenerator.genId(), "=", node.getEqualsLocation()));
                builder.addAll(node.getChildren().subList(1, node.numChildren()));
            }
            if (!node.hasValue() && node.getStaticKey() == null) {
                this.needsSpaceSelfClosingTag = true;
            }
            this.replacements = Optional.of(builder.build());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            boolean prevNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            this.needsSpaceForAttribute = false;
            boolean prevNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            this.needsSpaceSelfClosingTag = false;
            this.visitChildren(node);
            this.needsSpaceForAttribute = prevNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = prevNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgPluralNode(MsgPluralNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        @Override
        protected void visitMsgSelectNode(MsgSelectNode node) {
            this.visitControlFlowBranches(node.getChildren());
        }

        private void visitControlFlowBranches(List<? extends SoyNode.ParentSoyNode<?>> branches) {
            boolean startNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean endNeedsSpaceForAttribute = this.needsSpaceForAttribute;
            boolean startNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            boolean endNeedsSpaceForSelfClosingTag = this.needsSpaceSelfClosingTag;
            for (SoyNode.ParentSoyNode<?> branch : branches) {
                this.visitChildren(branch);
                endNeedsSpaceForAttribute |= this.needsSpaceForAttribute;
                this.needsSpaceForAttribute = startNeedsSpaceForAttribute;
                endNeedsSpaceForSelfClosingTag |= this.needsSpaceSelfClosingTag;
                this.needsSpaceSelfClosingTag = startNeedsSpaceForSelfClosingTag;
            }
            this.needsSpaceForAttribute = endNeedsSpaceForAttribute;
            this.needsSpaceSelfClosingTag = endNeedsSpaceForSelfClosingTag;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            this.doVisitChildren(node);
        }

        private <C extends SoyNode> void doVisitChildren(SoyNode.ParentSoyNode<C> parent) {
            for (int i = 0; i < parent.numChildren(); ++i) {
                SoyNode child = (SoyNode)parent.getChild(i);
                this.visit(child);
                if (!this.replacements.isPresent()) continue;
                parent.removeChild(i);
                List typedReplacements = (List)this.replacements.get();
                parent.addChildren(i, typedReplacements);
                i += this.replacements.get().size() - 1;
                this.replacements = Optional.empty();
            }
            Preconditions.checkState((!this.replacements.isPresent() ? 1 : 0) != 0);
        }
    }
}

