/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.ImportsPass;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.types.CssImportType;
import com.google.template.soy.types.CssModuleImportType;

final class CssImportProcessor
implements ImportsPass.ImportProcessor {
    private final CssRegistry cssRegistry;
    private final ErrorReporter errorReporter;
    private static final SoyErrorKind CSS_MODULE_IMPORT = SoyErrorKind.of("Module-level css imports are forbidden. Import the classes object explicitly.", new SoyErrorKind.StyleAllowance[0]);

    CssImportProcessor(CssRegistry cssRegistry, ErrorReporter errorReporter) {
        this.cssRegistry = cssRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    public void init(ImmutableList<SoyFileNode> sourceFiles) {
    }

    @Override
    public boolean handlesPath(SourceLogicalPath path) {
        return this.cssRegistry.containsLogicalPath(path);
    }

    public ImmutableSet<SourceLogicalPath> getAllPaths() {
        return this.cssRegistry.getAllLogicalPaths();
    }

    @Override
    public void handle(SoyFileNode file, ImmutableCollection<ImportNode> imports) {
        for (ImportNode importNode : imports) {
            importNode.setImportType(ImportNode.ImportType.CSS);
            if (importNode.isModuleImport()) {
                this.errorReporter.report(importNode.getSourceLocation(), CSS_MODULE_IMPORT, new Object[0]);
                continue;
            }
            this.processImportedSymbols(importNode);
        }
    }

    private void processImportedSymbols(ImportNode node) {
        CssModuleImportType moduleType = CssModuleImportType.create(node.getSourceFilePath());
        node.setModuleType(moduleType);
        for (ImportedVar symbol : node.getIdentifiers()) {
            String name = symbol.getSymbol();
            if (!moduleType.getNestedSymbolNames().contains((Object)name)) {
                ImportsPass.reportUnknownSymbolError(this.errorReporter, symbol.nameLocation(), name, node.getPath(), moduleType.getNestedSymbolNames());
            }
            ImmutableMap<String, String> shortClassMap = this.cssRegistry.getShortClassNameMapForLogicalPath(node.getSourceFilePath());
            symbol.setType(CssImportType.create(node.getSourceFilePath(), shortClassMap));
        }
    }
}

