/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

final class BasicHtmlValidationPass
implements CompilerFilePass {
    private static final SoyErrorKind MULTIPLE_ATTRIBUTES = SoyErrorKind.of("Found multiple ''{0}'' attributes with the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_CONTENT = SoyErrorKind.of("Unexpected close tag content, only whitespace is allowed in close tags.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_ID_VALUE = SoyErrorKind.of("Html id attributes should not be valid JavaScript identifiers, consider hyphenating the id.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private static final Pattern JS_IDENTIFIER_PATTERN = Pattern.compile("^[$_\\p{IsLetter}][$_\\p{IsLetter}\\p{IsDigit}]*$");

    BasicHtmlValidationPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        SoyTreeUtils.allNodesOfType(file, HtmlTagNode.class).forEach(node -> {
            this.checkForDuplicateAttributes((SoyNode.ParentSoyNode<SoyNode.StandaloneNode>)node);
            if (node instanceof HtmlCloseTagNode) {
                this.checkCloseTagChildren((HtmlCloseTagNode)node);
            }
        });
        SoyTreeUtils.allNodesOfType(file, SoyNode.RenderUnitNode.class).filter(unit -> !unit.isImplicitContentKind() && unit.getContentKind() == SanitizedContentKind.ATTRIBUTES).forEach(this::checkForDuplicateAttributes);
        SoyTreeUtils.allNodesOfType(file, HtmlAttributeNode.class).forEach(this::warnOnIdAttributesMatchingJsIdentifiers);
    }

    private void checkForDuplicateAttributes(SoyNode.ParentSoyNode<SoyNode.StandaloneNode> parentNode) {
        DuplicateAttributesVisitor visitor = new DuplicateAttributesVisitor();
        List children = parentNode.getChildren();
        if (parentNode instanceof HtmlTagNode) {
            children = children.subList(1, children.size());
        }
        for (SoyNode child : children) {
            visitor.exec(child);
        }
    }

    private static boolean isIdShapedValue(HtmlAttributeValueNode node) {
        if (node.numChildren() != 1) {
            return false;
        }
        SoyNode.StandaloneNode attrValueNode = (SoyNode.StandaloneNode)node.getChild(0);
        if (attrValueNode instanceof RawTextNode) {
            return JS_IDENTIFIER_PATTERN.matcher(((RawTextNode)attrValueNode).getRawText()).matches();
        }
        if (attrValueNode instanceof PrintNode) {
            ExprNode exprRoot = ((PrintNode)attrValueNode).getExpr().getRoot();
            return exprRoot instanceof FunctionNode && ((FunctionNode)exprRoot).getFunctionName().equals("xid");
        }
        return false;
    }

    private void warnOnIdAttributesMatchingJsIdentifiers(HtmlAttributeNode attributeNode) {
        Node child;
        if (attributeNode.definitelyMatchesAttributeName("id") && attributeNode.hasValue() && (child = attributeNode.getChild(1)) instanceof HtmlAttributeValueNode && BasicHtmlValidationPass.isIdShapedValue((HtmlAttributeValueNode)child)) {
            this.errorReporter.warn(((SoyNode.StandaloneNode)attributeNode.getChild(1)).getSourceLocation(), BAD_ID_VALUE, new Object[0]);
        }
    }

    private void checkCloseTagChildren(HtmlCloseTagNode closeTag) {
        HtmlAttributeNode phNameAttribute = closeTag.getDirectAttributeNamed("phname");
        HtmlAttributeNode phExAttribute = closeTag.getDirectAttributeNamed("phex");
        for (int i = 1; i < closeTag.numChildren(); ++i) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)closeTag.getChild(i);
            if (child == phNameAttribute || child == phExAttribute) continue;
            this.errorReporter.report(child.getSourceLocation(), UNEXPECTED_CLOSE_TAG_CONTENT, new Object[0]);
        }
    }

    private final class DuplicateAttributesVisitor
    extends AbstractSoyNodeVisitor<Set<String>> {
        private final Set<String> foundSoFar;

        DuplicateAttributesVisitor() {
            this((Set<String>)ImmutableSet.of());
        }

        DuplicateAttributesVisitor(Set<String> foundSoFar) {
            this.foundSoFar = new HashSet<String>(foundSoFar);
        }

        @Override
        public Set<String> exec(SoyNode n) {
            this.visit(n);
            return this.foundSoFar;
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            String attributeKey = node.getStaticKey();
            if (attributeKey != null && !this.foundSoFar.add(attributeKey = Ascii.toLowerCase((String)attributeKey))) {
                BasicHtmlValidationPass.this.errorReporter.report(node.getSourceLocation(), MULTIPLE_ATTRIBUTES, attributeKey);
            }
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.visitControlFlowNode(node, node.hasElse());
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.visitControlFlowNode(node, node.hasDefaultCase());
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.visitControlFlowNode(node, false);
        }

        private void visitControlFlowNode(SoyNode.SplitLevelTopNode<? extends SoyNode.BlockNode> parent, boolean exhaustive) {
            if (exhaustive) {
                HashSet definiteBlockAttrs = null;
                for (SoyNode.BlockNode block : parent.getChildren()) {
                    Set<String> blockAttrs = new DuplicateAttributesVisitor(this.foundSoFar).exec(block);
                    if (definiteBlockAttrs == null) {
                        definiteBlockAttrs = new HashSet(Sets.difference(blockAttrs, this.foundSoFar));
                        continue;
                    }
                    definiteBlockAttrs.retainAll(blockAttrs);
                }
                this.foundSoFar.addAll(definiteBlockAttrs);
            } else {
                for (SoyNode.BlockNode block : parent.getChildren()) {
                    new DuplicateAttributesVisitor(this.foundSoFar).exec(block);
                }
            }
        }

        @Override
        protected void visitCallNode(CallNode node) {
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

