/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.MsgPartUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@Immutable
public final class RenderOnlySoyMsgBundleImpl
extends SoyMsgBundle {
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;
    private final long[] ids;
    private final ImmutableList<SoyMsgPart> values;
    private final int[] partRanges;
    private static final int BUCKET_SHIFT = 6;
    private final int bucketMask;
    private final int[] bucketBoundaries;

    private int bucketOf(long msgId) {
        return (int)msgId & this.bucketMask;
    }

    public RenderOnlySoyMsgBundleImpl(@Nullable String localeString, Iterable<SoyMsg> msgs) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        int maskHigh = Integer.highestOneBit(Iterables.size(msgs));
        this.bucketMask = maskHigh == 0 ? 0 : (maskHigh | maskHigh - 1) >>> 6;
        int numBuckets = this.bucketMask + 1;
        Comparator<SoyMsg> bucketComparator = Comparator.comparingInt(m -> this.bucketOf(m.getId())).thenComparingLong(SoyMsg::getId);
        ImmutableList sortedMsgs = ImmutableList.sortedCopyOf(bucketComparator, msgs);
        this.bucketBoundaries = new int[numBuckets + 1];
        int idx = 0;
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            this.bucketBoundaries[bucket] = idx;
            while (idx < sortedMsgs.size() && this.bucketOf(((SoyMsg)sortedMsgs.get(idx)).getId()) == bucket) {
                ++idx;
            }
        }
        this.bucketBoundaries[numBuckets] = sortedMsgs.size();
        this.ids = new long[sortedMsgs.size()];
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        this.partRanges = new int[sortedMsgs.size() + 1];
        this.partRanges[0] = 0;
        long priorId = sortedMsgs.isEmpty() ? -1L : ((SoyMsg)sortedMsgs.get(0)).getId() - 1L;
        int runningPartCount = 0;
        int c = sortedMsgs.size();
        for (int i = 0; i < c; ++i) {
            SoyMsg msg = (SoyMsg)sortedMsgs.get(i);
            ImmutableList<SoyMsgPart> parts = msg.getParts();
            Preconditions.checkArgument((msg.getId() != priorId ? 1 : 0) != 0, (Object)"Duplicate messages are not permitted in the render-only impl.");
            Preconditions.checkArgument((MsgPartUtils.hasPlrselPart(parts) == msg.isPlrselMsg() ? 1 : 0) != 0, (Object)"Message's plural/select status is inconsistent -- internal compiler bug.");
            priorId = msg.getId();
            this.ids[i] = msg.getId();
            partsBuilder.addAll(parts);
            this.partRanges[i + 1] = runningPartCount += parts.size();
        }
        this.values = partsBuilder.build();
    }

    public RenderOnlySoyMsgBundleImpl(@Nullable String localeString, RenderOnlySoyMsgBundleImpl exemplar) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        this.bucketMask = exemplar.bucketMask;
        this.bucketBoundaries = exemplar.bucketBoundaries;
        this.ids = exemplar.ids;
        this.values = exemplar.values;
        this.partRanges = exemplar.partRanges;
    }

    private SoyMsg resurrectMsg(long id, ImmutableList<SoyMsgPart> parts) {
        return SoyMsg.builder().setId(id).setLocaleString(this.localeString).setIsPlrselMsg(MsgPartUtils.hasPlrselPart(parts)).setParts((Iterable<? extends SoyMsgPart>)parts).build();
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    @Nullable
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    private ImmutableList<SoyMsgPart> partsForIndex(int index) {
        int startInclusive = this.partRanges[index];
        int endExclusive = this.partRanges[index + 1];
        return this.values.subList(startInclusive, endExclusive);
    }

    @Override
    @Nullable
    public SoyMsg getMsg(long msgId) {
        int index = this.binarySearch(msgId);
        return index >= 0 ? this.resurrectMsg(msgId, this.partsForIndex(index)) : null;
    }

    @Override
    public boolean hasMsg(long msgId) {
        return this.binarySearch(msgId) >= 0;
    }

    @Override
    public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
        int index = this.binarySearch(msgId);
        return index >= 0 ? this.partsForIndex(index) : ImmutableList.of();
    }

    @Override
    @Nullable
    public String getBasicTranslation(long msgId) {
        int index = this.binarySearch(msgId);
        if (index < 0) {
            return null;
        }
        int startInclusive = this.partRanges[index];
        Preconditions.checkArgument((startInclusive + 1 == this.partRanges[index + 1] ? 1 : 0) != 0);
        return ((SoyMsgRawTextPart)this.values.get(startInclusive)).getRawText();
    }

    private int binarySearch(long key) {
        int bucket = this.bucketOf(key);
        int low = this.bucketBoundaries[bucket];
        int high = this.bucketBoundaries[bucket + 1];
        return Arrays.binarySearch(this.ids, low, high, key);
    }

    @Override
    public int getNumMsgs() {
        return this.ids.length;
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return new Iterator<SoyMsg>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RenderOnlySoyMsgBundleImpl.this.ids.length;
            }

            @Override
            public SoyMsg next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                SoyMsg result = RenderOnlySoyMsgBundleImpl.this.resurrectMsg(RenderOnlySoyMsgBundleImpl.this.ids[this.index], RenderOnlySoyMsgBundleImpl.this.partsForIndex(this.index));
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        };
    }
}

