/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Longs;

public final class SoyMsgIdConverter {
    public static ImmutableList<Long> convertSoyMessageIdStrings(Iterable<String> encodedIds) {
        ImmutableList.Builder messageIds = ImmutableList.builder();
        for (String encodedId : encodedIds) {
            byte[] decodedBytes = BaseEncoding.base64Url().decode((CharSequence)encodedId);
            if (decodedBytes.length != 8) {
                throw new IllegalArgumentException(String.format("The message ID to decode ('%s') was of invalid size (%d != %d)", encodedId, decodedBytes.length, 8));
            }
            messageIds.add((Object)Longs.fromByteArray((byte[])decodedBytes));
        }
        return messageIds.build();
    }

    private SoyMsgIdConverter() {
    }
}

