/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.auto.value.AutoValue;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.logging.AutoValue_LoggingConfigValidator_VisualElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public final class LoggingConfigValidator {
    private static final SoyErrorKind INVALID_VE_NAME = SoyErrorKind.of("''{0}'' is not a valid identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_VE_ID = SoyErrorKind.of("ID {0,number,#} for ''{1}'' must be between {2,number,#} and {3,number,#} (inclusive).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CONFLICTING_VE = SoyErrorKind.of("Found VE definition that conflicts with {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNDEFINED_VE_WITH_DATA_TYPE = SoyErrorKind.of("The special VE ''UndefinedVe'' cannot be defined with a proto type.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNDEFINED_VE_WITH_METADATA = SoyErrorKind.of("The special VE ''UndefinedVe'' cannot be defined with metadata.", new SoyErrorKind.StyleAllowance[0]);

    public static void validate(List<VisualElement> ves, ErrorReporter errorReporter) {
        LinkedHashMap<String, VisualElement> elementsByName = new LinkedHashMap<String, VisualElement>();
        LinkedHashMap<Long, VisualElement> elementsById = new LinkedHashMap<Long, VisualElement>();
        for (VisualElement ve : ves) {
            String name;
            if (ve.getId() == -1L || ve.getName().equals("UndefinedVe")) {
                if (ve.getProtoName().isPresent()) {
                    errorReporter.report(ve.getSourceLocation(), UNDEFINED_VE_WITH_DATA_TYPE, new Object[0]);
                }
                if (ve.hasMetadata()) {
                    errorReporter.report(ve.getSourceLocation(), UNDEFINED_VE_WITH_METADATA, new Object[0]);
                }
            }
            if (!BaseUtils.isDottedIdentifier(name = ve.getName())) {
                errorReporter.report(ve.getSourceLocation(), INVALID_VE_NAME, name);
            }
            VisualElement oldWithSameId = elementsById.put(ve.getId(), ve);
            VisualElement oldWithSameName = elementsByName.put(ve.getName(), ve);
            if (oldWithSameId != null && !LoggingConfigValidator.elementsEquivalent(ve, oldWithSameId)) {
                errorReporter.report(ve.getSourceLocation(), CONFLICTING_VE, oldWithSameId);
                continue;
            }
            if (oldWithSameName == null || LoggingConfigValidator.elementsEquivalent(ve, oldWithSameName)) continue;
            errorReporter.report(ve.getSourceLocation(), CONFLICTING_VE, oldWithSameName);
        }
    }

    private static boolean elementsEquivalent(VisualElement a1, VisualElement a2) {
        return a1.getName().equals(a2.getName()) && a1.getId() == a2.getId() && a1.getProtoName().equals(a2.getProtoName()) && a1.getMetadata().equals(a2.getMetadata());
    }

    @AutoValue
    public static abstract class VisualElement {
        public static VisualElement create(String name, long id, Optional<String> protoName, Optional<Object> metadata, SourceLocation sourceLocation) {
            return new AutoValue_LoggingConfigValidator_VisualElement(name, id, protoName, metadata, sourceLocation);
        }

        VisualElement() {
        }

        public abstract String getName();

        public abstract long getId();

        public abstract Optional<String> getProtoName();

        public abstract Optional<Object> getMetadata();

        public abstract SourceLocation getSourceLocation();

        public boolean hasMetadata() {
            return this.getMetadata().isPresent();
        }

        public final String toString() {
            return String.format("Ve{name=%s, id=%s%s%s} declared at %s", this.getName(), this.getId(), this.getProtoName().isPresent() ? ", data=" + this.getProtoName().get() : "", this.getMetadata().isPresent() ? ", metadata=" + this.getMetadata().get().toString().trim() : "", this.getSourceLocation());
        }
    }
}

