/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jssrc.internal.AutoValue_VeLogInstrumentationVisitor_LoggingFunctionInfo;
import com.google.template.soy.jssrc.internal.VeLogFunction;
import com.google.template.soy.jssrc.internal.VeLogJsSrcLoggingFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;
import javax.annotation.Nullable;

final class VeLogInstrumentationVisitor
extends AbstractSoyNodeVisitor<Void> {
    private IdGenerator nodeIdGen;

    VeLogInstrumentationVisitor() {
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.nodeIdGen = node.getNodeIdGenerator();
        ImmutableList sourceFiles = ImmutableList.copyOf(node.getChildren());
        for (SoyFileNode fileNode : sourceFiles) {
            this.visitSoyFileNode(fileNode);
        }
        new DesugarHtmlNodesPass().run((ImmutableList<SoyFileNode>)sourceFiles, this.nodeIdGen);
    }

    @Nullable
    private static LoggingFunctionInfo getLoggingFunctionInfo(CallParamNode paramNode) {
        if (!(paramNode instanceof CallParamContentNode)) {
            return null;
        }
        CallParamContentNode callParamNode = (CallParamContentNode)paramNode;
        if (callParamNode.numChildren() != 1) {
            return null;
        }
        PrintNode printNode = null;
        ExprNode condition = null;
        if (callParamNode.getChild(0) instanceof PrintNode) {
            printNode = (PrintNode)callParamNode.getChild(0);
        } else if (callParamNode.getChild(0) instanceof IfNode) {
            IfNode ifNode = (IfNode)callParamNode.getChild(0);
            IfCondNode ifCondNode = (IfCondNode)ifNode.getChild(0);
            condition = ifCondNode.getExpr().getRoot();
            if (ifCondNode.numChildren() == 1 && ifCondNode.getChild(0) instanceof PrintNode) {
                printNode = (PrintNode)ifCondNode.getChild(0);
            }
        }
        if (printNode == null || !(printNode.getExpr().getRoot() instanceof FunctionNode)) {
            return null;
        }
        FunctionNode fnNode = (FunctionNode)printNode.getExpr().getRoot();
        if (fnNode.getSoyFunction() instanceof LoggingFunction) {
            CopyState copyState = new CopyState();
            return new AutoValue_VeLogInstrumentationVisitor_LoggingFunctionInfo(fnNode, condition == null ? null : condition);
        }
        return null;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        ImmutableList paramsContainingVelogFunctions = (ImmutableList)node.getChildren().stream().filter(c -> VeLogInstrumentationVisitor.getLoggingFunctionInfo(c) != null).map(c -> (CallParamContentNode)c).collect(ImmutableList.toImmutableList());
        if (paramsContainingVelogFunctions.isEmpty()) {
            this.visitChildrenAllowingConcurrentModification(node);
            return;
        }
        HtmlOpenTagNode openTagNode = VeLogInstrumentationVisitor.soyHtmlOpenTagNode(this.nodeIdGen);
        for (CallParamContentNode callParamContentNode : paramsContainingVelogFunctions) {
            FunctionNode funcNode = FunctionNode.newPositional(Identifier.create("$$loggingFunction", SourceLocation.UNKNOWN), VeLogJsSrcLoggingFunction.INSTANCE, SourceLocation.UNKNOWN);
            LoggingFunctionInfo info = VeLogInstrumentationVisitor.getLoggingFunctionInfo(callParamContentNode);
            funcNode.addChild(new StringNode(info.loggingFunction().getStaticFunctionName(), QuoteStyle.SINGLE, SourceLocation.UNKNOWN));
            funcNode.addChild(new ListLiteralNode(info.loggingFunction().copy(new CopyState()).getParams(), SourceLocation.UNKNOWN));
            funcNode.addChild(new StringNode(callParamContentNode.getOriginalName(), QuoteStyle.SINGLE, SourceLocation.UNKNOWN));
            AbstractSoyNode loggingFunctionAttribute = new PrintNode(this.nodeIdGen.genId(), SourceLocation.UNKNOWN, true, funcNode, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            if (info.condition() != null) {
                IfNode ifNode = new IfNode(0, callParamContentNode.getSourceLocation());
                IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), callParamContentNode.getSourceLocation(), callParamContentNode.getSourceLocation(), "if", info.condition().copy(new CopyState()));
                ifCondNode.getExpr().setType(info.condition().getType());
                ifCondNode.addChild(loggingFunctionAttribute);
                ifNode.addChild(ifCondNode);
                loggingFunctionAttribute = ifNode;
            }
            openTagNode.addChild(loggingFunctionAttribute);
        }
        node.getParent().addChild(node.getParent().getChildIndex(node), openTagNode);
        node.getParent().addChild(node.getParent().getChildIndex(node) + 1, VeLogInstrumentationVisitor.soyHtmlCloseTagNode(this.nodeIdGen));
    }

    private static HtmlOpenTagNode soyHtmlOpenTagNode(IdGenerator idGenerator) {
        return new HtmlOpenTagNode(idGenerator.genId(), (SoyNode.StandaloneNode)new RawTextNode(idGenerator.genId(), "veAttr", SourceLocation.UNKNOWN), SourceLocation.UNKNOWN, false, HtmlTagNode.TagExistence.IN_TEMPLATE);
    }

    private static HtmlCloseTagNode soyHtmlCloseTagNode(IdGenerator idGenerator) {
        return new HtmlCloseTagNode(idGenerator.genId(), new RawTextNode(idGenerator.genId(), "veAttr", SourceLocation.UNKNOWN), SourceLocation.UNKNOWN, HtmlTagNode.TagExistence.IN_TEMPLATE);
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        if (!node.needsSyntheticVelogNode()) {
            HtmlOpenTagNode tag = node.getOpenTagNode();
            SourceLocation insertionLocation = tag.getSourceLocation().getEndPoint().asLocation(tag.getSourceLocation().getFilePath());
            FunctionNode funcNode = FunctionNode.newPositional(Identifier.create("$$velog", insertionLocation), VeLogFunction.INSTANCE, insertionLocation);
            funcNode.addChild(node.getVeDataExpression().copy(new CopyState()));
            if (node.getLogonlyExpression() != null) {
                funcNode.addChild(node.getLogonlyExpression().copy(new CopyState()));
            }
            PrintNode attributeNode = new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, funcNode, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            tag.addChild(attributeNode);
        }
        this.visitChildrenAllowingConcurrentModification(node);
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return;
        }
        SourceLocation insertionLocation = node.getSourceLocation();
        for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(node, FunctionNode.class)) {
            if (!(function.getSoyFunction() instanceof LoggingFunction)) continue;
            FunctionNode funcNode = FunctionNode.newPositional(Identifier.create("$$loggingFunction", insertionLocation), VeLogJsSrcLoggingFunction.INSTANCE, insertionLocation);
            funcNode.addChild(new StringNode(function.getStaticFunctionName(), QuoteStyle.SINGLE, insertionLocation));
            funcNode.addChild(new ListLiteralNode(function.getParams(), insertionLocation));
            SoyNode.StandaloneNode attributeName = (SoyNode.StandaloneNode)node.getChild(0);
            if (attributeName instanceof RawTextNode) {
                funcNode.addChild(new StringNode(((RawTextNode)attributeName).getRawText(), QuoteStyle.SINGLE, insertionLocation));
            } else {
                String varName = "$soy_logging_function_attribute_" + node.getId();
                LetContentNode letNode = LetContentNode.forVariable(this.nodeIdGen.genId(), attributeName.getSourceLocation(), varName, attributeName.getSourceLocation(), SanitizedContentKind.TEXT);
                node.replaceChild(attributeName, new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, new VarRefNode("$" + letNode.getVar().name(), insertionLocation, letNode.getVar()), (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding()));
                letNode.addChild(attributeName);
                node.getParent().addChild(node.getParent().getChildIndex(node), letNode);
                funcNode.addChild(new VarRefNode("$" + letNode.getVar().name(), insertionLocation, letNode.getVar()));
            }
            PrintNode loggingFunctionAttribute = new PrintNode(this.nodeIdGen.genId(), insertionLocation, true, funcNode, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
            int appendIndex = node.getParent().getChildIndex(node) + 1;
            node.getParent().addChild(appendIndex, loggingFunctionAttribute);
            HtmlAttributeValueNode placeHolder = new HtmlAttributeValueNode(this.nodeIdGen.genId(), insertionLocation, HtmlAttributeValueNode.Quotes.DOUBLE);
            placeHolder.addChild(new RawTextNode(this.nodeIdGen.genId(), ((LoggingFunction)function.getSoyFunction()).getPlaceholder(), insertionLocation));
            node.replaceChild((SoyNode.StandaloneNode)node.getChild(1), placeHolder);
            break;
        }
        this.visitChildrenAllowingConcurrentModification(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }

    @AutoValue
    static abstract class LoggingFunctionInfo {
        LoggingFunctionInfo() {
        }

        @Nullable
        abstract FunctionNode loggingFunction();

        @Nullable
        abstract ExprNode condition();
    }
}

