/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;

public final class TranslationContext {
    private SoyToJsVariableMappings soyToJsVariableMappings;
    private UniqueNameGenerator nameGenerator;

    public static TranslationContext of(SoyToJsVariableMappings soyToJsVariableMappings, UniqueNameGenerator nameGenerator) {
        return new TranslationContext(soyToJsVariableMappings, nameGenerator);
    }

    private TranslationContext(SoyToJsVariableMappings soyToJsVariableMappings, UniqueNameGenerator nameGenerator) {
        this.soyToJsVariableMappings = soyToJsVariableMappings;
        this.nameGenerator = nameGenerator;
    }

    public SoyToJsVariableMappings soyToJsVariableMappings() {
        return this.soyToJsVariableMappings;
    }

    public CodeChunk.Generator codeGenerator() {
        return CodeChunk.Generator.create(this.nameGenerator);
    }

    UniqueNameGenerator nameGenerator() {
        return this.nameGenerator;
    }

    public ExitScope enterSoyScope() {
        SoyToJsVariableMappings prevMappings = this.soyToJsVariableMappings;
        this.soyToJsVariableMappings = SoyToJsVariableMappings.startingWith(prevMappings);
        return () -> {
            this.soyToJsVariableMappings = prevMappings;
        };
    }

    public ExitScope enterSoyAndJsScope() {
        SoyToJsVariableMappings prevMappings = this.soyToJsVariableMappings;
        this.soyToJsVariableMappings = SoyToJsVariableMappings.startingWith(prevMappings);
        UniqueNameGenerator prevGenerator = this.nameGenerator;
        this.nameGenerator = this.nameGenerator.branch();
        return () -> {
            this.soyToJsVariableMappings = prevMappings;
            this.nameGenerator = prevGenerator;
        };
    }

    public static interface ExitScope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

