/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.types.SoyProtoType;

public final class JsRuntime {
    private static final GoogRequire GOOG_ARRAY = GoogRequire.create("goog.array");
    private static final GoogRequire GOOG_ASSERTS = GoogRequire.create("goog.asserts");
    private static final GoogRequire GOOG_STRING = GoogRequire.create("goog.string");
    static final GoogRequire SOY = GoogRequire.create("soy");
    private static final GoogRequire SOY_MAP = GoogRequire.create("soy.map");
    private static final GoogRequire SOY_NEWMAPS = GoogRequire.create("soy.newmaps");
    public static final GoogRequire SOY_VELOG = GoogRequire.create("soy.velog");
    public static final GoogRequire GOOG_SOY_ALIAS = GoogRequire.createWithAlias("goog.soy", "$googSoy");
    private static final GoogRequire SOY_TEMPLATES = GoogRequire.create("soy.templates");
    public static final GoogRequire GOOG_SOY = GoogRequire.create("goog.soy");
    public static final Expression SOY_EMPTY_OBJECT = SOY.dotAccess("$$EMPTY_OBJECT");
    public static final Expression SOY_INTERCEPT_SOY_TEMPLATES = SOY.dotAccess("INTERCEPT_SOY_TEMPLATES");
    public static final Expression SOY_STUBS_MAP = SOY.dotAccess("$$stubsMap");
    private static final GoogRequire XID_REQUIRE = GoogRequire.create("xid");
    public static final Expression GOOG_ARRAY_MAP = GOOG_ARRAY.reference().dotAccess("map");
    public static final Expression GOOG_ASSERTS_ASSERT = GOOG_ASSERTS.reference().dotAccess("assert");
    public static final Expression GOOG_DEBUG = Expressions.dottedIdNoRequire("goog.DEBUG");
    public static final Expression GOOG_GET_CSS_NAME = Expressions.dottedIdNoRequire("goog.getCssName");
    public static final Expression GOOG_GET_MSG = Expressions.dottedIdNoRequire("goog.getMsg");
    public static final Expression ARRAY_IS_ARRAY = Expressions.dottedIdNoRequire("Array.isArray");
    public static final Expression GOOG_IS_FUNCTION = SOY.dotAccess("$$isFunction");
    public static final Expression SOY_EQUALS = SOY.dotAccess("$$equals");
    public static final Expression SHOULD_STUB = GOOG_SOY.dotAccess("shouldStub").and(GOOG_SOY.dotAccess("shouldStubAtRuntime").call(new Expression[0]), null);
    public static final Expression SOY_MAKE_ARRAY = SOY.dotAccess("$$makeArray");
    public static final Expression SOY_AS_READONLY = SOY.dotAccess("$$asReadonlyArray");
    public static final Expression SOY_FILTER_AND_MAP = SOY.dotAccess("$$filterAndMap");
    public static final Expression GOOG_IS_OBJECT = Expressions.dottedIdNoRequire("goog.isObject");
    public static final Expression GOOG_REQUIRE = Expressions.dottedIdNoRequire("goog.require");
    public static final Expression GOOG_MODULE_GET = Expressions.dottedIdNoRequire("goog.module.get");
    public static final Expression GOOG_SOY_DATA_SANITIZED_CONTENT = GoogRequire.create("goog.soy.data.SanitizedContent").reference();
    public static final Expression SAFEVALUES_SAFEHTML = GoogRequire.create("safevalues").dotAccess("SafeHtml");
    public static final Expression GOOG_HTML_SAFE_ATTRIBUTE = GoogRequire.create("goog.soy.data.SanitizedHtmlAttribute").reference();
    public static final Expression GOOG_STRING_UNESCAPE_ENTITIES = GOOG_STRING.dotAccess("unescapeEntities");
    public static final Expression GOOG_I18N_MESSAGE_FORMAT = GoogRequire.create("goog.i18n.MessageFormat").reference();
    public static final Expression SOY_ASSERT_PARAM_TYPE = SOY.dotAccess("assertParamType");
    public static final Expression SOY_ASSIGN_DEFAULTS = SOY.dotAccess("$$assignDefaults");
    public static final Expression SOY_CHECK_NOT_NULL = SOY.dotAccess("$$checkNotNull");
    public static final Expression SERIALIZE_KEY = SOY.dotAccess("$$serializeKey");
    public static final Expression SOY_COERCE_TO_BOOLEAN = SOY.dotAccess("$$coerceToBoolean");
    public static final Expression SOY_IS_TRUTHY_NON_EMPTY = SOY.dotAccess("$$isTruthyNonEmpty");
    public static final Expression SOY_HAS_CONTENT = SOY.dotAccess("$$hasContent");
    public static final Expression SOY_EMPTY_TO_NULL = SOY.dotAccess("$$emptyToNull");
    public static final Expression SOY_ESCAPE_HTML = SOY.dotAccess("$$escapeHtml");
    public static final Expression SOY_GET_DELEGATE_FN = SOY.dotAccess("$$getDelegateFn");
    public static final Expression SOY_MAKE_EMPTY_TEMPLATE_FN = SOY.dotAccess("$$makeEmptyTemplateFn");
    public static final Expression SOY_REGISTER_DELEGATE_FN = SOY.dotAccess("$$registerDelegateFn");
    public static final Expression SOY_ALIAS_DELEGATE_ID = SOY.dotAccess("$$aliasDelegateId");
    public static final Expression SOY_GET_DELTEMPLATE_ID = SOY.dotAccess("$$getDelTemplateId");
    public static final Expression SOY_IS_LOCALE_RTL = SOY.dotAccess("$$IS_LOCALE_RTL");
    public static final Expression SOY_CREATE_CONST = SOY.dotAccess("$$createConst");
    public static final Expression SOY_GET_CONST = SOY.dotAccess("$$getConst");
    public static final Expression SOY_DEBUG_SOY_TEMPLATE_INFO = SOY.dotAccess("$$getDebugSoyTemplateInfo");
    public static final Expression SOY_ARE_YOU_AN_INTERNAL_CALLER = SOY.dotAccess("$$areYouAnInternalCaller");
    public static final Expression SOY_INTERNAL_CALL_MARKER = SOY.dotAccess("$$internalCallMarkerDoNotUse");
    public static final Expression SOY_MAP_IS_SOY_MAP = SOY_MAP.dotAccess("$$isSoyMap");
    public static final Expression SOY_NEWMAPS_TRANSFORM_VALUES = SOY_NEWMAPS.googModuleGet().dotAccess("$$transformValues");
    public static final Expression SOY_NEWMAPS_NULL_SAFE_TRANSFORM_VALUES = SOY_NEWMAPS.googModuleGet().dotAccess("$$nullSafeTransformValues");
    public static final Expression SOY_NEWMAPS_NULL_SAFE_ARRAY_MAP = SOY_NEWMAPS.googModuleGet().dotAccess("$$nullSafeArrayMap");
    public static final Expression SOY_VISUAL_ELEMENT = Expressions.group(SOY_VELOG.googModuleGet().dotAccess("$$VisualElement"));
    public static final Expression SOY_VISUAL_ELEMENT_DATA = Expressions.group(SOY_VELOG.googModuleGet().dotAccess("$$VisualElementData"));
    public static final Expression WINDOW_CONSOLE_LOG = Expressions.dottedIdNoRequire("window.console.log");
    public static final Expression XID = XID_REQUIRE.reference();
    public static final GoogRequire ELEMENT_LIB_IDOM = GoogRequire.createWithAlias("google3.javascript.template.soy.element_lib_idom", "element_lib_idom");
    public static final Expression OPT_DATA = Expressions.id("opt_data");
    public static final Expression OPT_VARIANT = Expressions.id("opt_variant");
    public static final Expression IJ_DATA = Expressions.id("$ijData");
    public static final Expression EXPORTS = Expressions.id("exports");
    public static final Expression MARK_TEMPLATE = SOY_TEMPLATES.googModuleGet().dotAccess("$$markTemplate");
    public static final Expression BIND_TEMPLATE_PARAMS = SOY_TEMPLATES.googModuleGet().dotAccess("$$bindTemplateParams");
    public static final Expression BIND_TEMPLATE_PARAMS_FOR_IDOM = SOY_TEMPLATES.googModuleGet().dotAccess("$$bindTemplateParamsForIdom");
    private static final Expression SOY_CONVERTERS = GoogRequire.create("soy.converters").googModuleGet();
    public static final ImmutableMap<String, Expression> JS_TO_PROTO_PACK_FN_BASE = ImmutableMap.builder().put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedJsToProtoSoyRuntimeOnly")).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedUriToProtoSoyRuntimeOnly")).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedCssToSafeStyleProtoSoyRuntimeOnly")).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedCssToSafeStyleSheetProtoSoyRuntimeOnly")).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedTrustedResourceUriToProtoSoyRuntimeOnly")).buildOrThrow();
    public static final ImmutableMap<String, Expression> JS_TO_PROTO_PACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SOY_CONVERTERS.dotAccess("packSanitizedHtmlToProtoSoyRuntimeOnly")).putAll(JS_TO_PROTO_PACK_FN_BASE).buildOrThrow();

    private JsRuntime() {
    }

    public static Expression getToggleRef(String path, String name, boolean googModuleSyntax) {
        int extensionIndex = path.lastIndexOf(".toggles");
        if (extensionIndex != -1) {
            path = path.substring(0, extensionIndex);
        }
        String togglePathSymbol = "google3." + path.replace('/', '.') + "$2etoggles";
        if (googModuleSyntax) {
            String uniqueTogglePathSymbol = togglePathSymbol.replace('.', '_');
            GoogRequire ref = GoogRequire.createWithAlias(togglePathSymbol, uniqueTogglePathSymbol);
            return ref.reference().dotAccess("TOGGLE_" + name);
        }
        GoogRequire ref = GoogRequire.create(togglePathSymbol);
        return ref.googModuleGet().dotAccess("TOGGLE_" + name);
    }

    public static Expression extensionField(Descriptors.FieldDescriptor desc) {
        String jsExtensionImport = ProtoUtils.getJsExtensionImport(desc);
        String jsExtensionName = ProtoUtils.getJsExtensionName(desc);
        return JsRuntime.symbolWithNamespace(jsExtensionImport, jsExtensionName);
    }

    public static Expression protoToSanitizedContentConverterFunction(Descriptors.Descriptor messageType) {
        return SOY_CONVERTERS.dotAccess(NodeContentKinds.toJsUnpackFunction(messageType));
    }

    public static Expression protoByteStringToBase64ConverterFunction() {
        return SOY_CONVERTERS.dotAccess("unpackByteStringToBase64String");
    }

    public static Expression protoBytesPackToByteStringFunction() {
        return SOY_CONVERTERS.dotAccess("packBase64StringToByteString");
    }

    public static Expression sanitizedContentOrdainerFunction(SanitizedContentKind kind) {
        return JsRuntime.symbolWithNamespace(NodeContentKinds.getJsImportForOrdainersFunctions(kind), NodeContentKinds.toJsSanitizedContentOrdainer(kind));
    }

    public static Expression protoConstructor(SoyProtoType type) {
        return GoogRequire.create(type.getJsName(ProtoUtils.MutabilityMode.MUTABLE)).reference();
    }

    public static Expression emptyProto(SoyProtoType type) {
        return JsRuntime.castAsReadonlyProto(SOY.dotAccess("$$emptyProto").call(GoogRequire.create(type.getJsName(ProtoUtils.MutabilityMode.MUTABLE)).reference()), type);
    }

    static Expression castAsReadonlyProto(Expression expr, SoyProtoType type) {
        String readonlyName = type.getJsName(ProtoUtils.MutabilityMode.READONLY);
        return expr.castAs("!" + readonlyName, (ImmutableSet<GoogRequire>)ImmutableSet.of((Object)GoogRequire.createTypeRequire(readonlyName)));
    }

    public static Expression sanitizedContentType(SanitizedContentKind kind) {
        return GoogRequire.create(NodeContentKinds.toJsSanitizedContentCtorName(kind)).reference();
    }

    private static Expression symbolWithNamespace(String requireSymbol, String fullyQualifiedSymbol) {
        GoogRequire require = GoogRequire.create(requireSymbol);
        if (fullyQualifiedSymbol.equals(require.symbol())) {
            return require.reference();
        }
        String suffix = fullyQualifiedSymbol.substring(require.symbol().length() + 1);
        Expression e = require.reference();
        for (String ident : Splitter.on((char)'.').splitToList((CharSequence)suffix)) {
            e = e.dotAccess(ident);
        }
        return e;
    }
}

