/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.Statements;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.TryCatch;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.OutputVarHandler;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.internal.VeLogFunction;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class GenJsTemplateBodyVisitor
extends AbstractReturningSoyNodeVisitor<Statement> {
    protected final OutputVarHandler outputVars;
    protected final SoyJsSrcOptions jsSrcOptions;
    protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    protected final GenJsExprsVisitor genJsExprsVisitor;
    private GenJsCodeVisitorAssistantForMsgs assistantForMsgs;
    protected final ErrorReporter errorReporter;
    protected final TranslationContext templateTranslationContext;
    protected final TemplateAliases templateAliases;

    protected GenJsTemplateBodyVisitor(OutputVarHandler outputVars, SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor genJsExprsVisitor, ErrorReporter errorReporter, TranslationContext templateTranslationContext, TemplateAliases templateAliases) {
        this.outputVars = outputVars;
        this.jsSrcOptions = jsSrcOptions;
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitor = genJsExprsVisitor;
        this.errorReporter = errorReporter;
        this.templateTranslationContext = templateTranslationContext;
        this.templateAliases = templateAliases;
    }

    @Override
    public Statement visit(SoyNode node) {
        return (Statement)super.visit(node);
    }

    @Override
    protected List<Statement> visitChildren(SoyNode.ParentSoyNode<?> node) {
        ArrayList<Statement> statements;
        block8: {
            block7: {
                statements = new ArrayList<Statement>();
                if (node.numChildren() == 0) break block7;
                if (((Boolean)this.canInitOutputVarVisitor.exec((SoyNode)node.getChild(0))).booleanValue()) break block8;
            }
            this.outputVars.initOutputVarIfNecessary().ifPresent(statements::add);
        }
        ArrayList<Expression> consecChunks = new ArrayList<Expression>();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChunks.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (!consecChunks.isEmpty()) {
                statements.add(this.outputVars.addChunksToOutputVar(consecChunks));
                consecChunks.clear();
            }
            statements.add(this.visit(child));
        }
        if (!consecChunks.isEmpty()) {
            statements.add(this.outputVars.addChunksToOutputVar(consecChunks));
            consecChunks.clear();
        }
        return statements;
    }

    protected final List<Statement> visitChildrenInNewSoyScope(SoyNode.ParentSoyNode<?> node) {
        try (TranslationContext.ExitScope scope = this.templateTranslationContext.enterSoyScope();){
            List<Statement> list = this.visitChildren(node);
            return list;
        }
    }

    protected final List<Statement> visitChildrenInNewSoyAndJsScope(SoyNode.ParentSoyNode<?> node) {
        try (TranslationContext.ExitScope scope = this.templateTranslationContext.enterSoyAndJsScope();){
            List<Statement> list = this.visitChildren(node);
            return list;
        }
    }

    protected GenJsCodeVisitorAssistantForMsgs getAssistantForMsgs() {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter, this.outputVars);
        }
        return this.assistantForMsgs;
    }

    @Override
    protected Statement visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        return this.outputVars.addChunkToOutputVar(this.getAssistantForMsgs().generateMsgGroupVariable(node));
    }

    @Override
    protected Statement visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected Statement visitPrintNode(PrintNode node) {
        return this.outputVars.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected Statement visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        Expression value = this.translateExpr(node.getExpr());
        if (value.equals(Expressions.LITERAL_NULL)) {
            JsType type = JsType.forJsSrc(node.getVar().type());
            value = value.castAs(type.typeExpr(), (ImmutableSet<GoogRequire>)((ImmutableSet)type.getGoogRequires().stream().map(GoogRequire::toRequireType).collect(ImmutableSet.toImmutableSet())));
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), Expressions.id(generatedVarName));
        return VariableDeclaration.builder(generatedVarName).setRhs(value).build();
    }

    @Override
    protected Statement visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        Expression generatedVar = Expressions.id(generatedVarName);
        this.outputVars.pushOutputVar(generatedVarName);
        List<Statement> statements = this.visitChildrenInNewSoyScope(node);
        this.outputVars.popOutputVar();
        if (node.getContentKind() != SanitizedContentKind.TEXT) {
            String wrappedVarName = node.getVarName() + "__wrapped" + node.getId();
            statements.add(VariableDeclaration.builder(wrappedVarName).setRhs(JsRuntime.sanitizedContentOrdainerFunction(node.getContentKind()).call(generatedVar)).build());
            generatedVar = Expressions.id(wrappedVarName);
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), generatedVar);
        return Statements.of(statements);
    }

    @Override
    protected Statement visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            return this.outputVars.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
        }
        return this.generateNonExpressionIfNode(node);
    }

    protected Statement generateNonExpressionIfNode(IfNode node) {
        ConditionalBuilder conditional = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode condNode = (IfCondNode)child;
                Expression predicate = this.getExprTranslator().maybeCoerceToBoolean(condNode.getExpr().getType(), this.translateExpr(condNode.getExpr()), false);
                Statement consequent = Statements.of(this.visitChildrenInNewSoyAndJsScope(condNode));
                if (conditional == null) {
                    conditional = Statements.ifStatement(predicate, consequent);
                    continue;
                }
                conditional.addElseIf(predicate, consequent);
                continue;
            }
            if (child instanceof IfElseNode) {
                Statement trailingElse = Statements.of(this.visitChildrenInNewSoyAndJsScope((IfElseNode)child));
                conditional.setElse(trailingElse);
                continue;
            }
            throw new AssertionError();
        }
        return conditional.build();
    }

    @Override
    protected Statement visitSwitchNode(SwitchNode node) {
        Expression switchOn = this.coerceTypeForSwitchComparison(node.getExpr());
        SwitchBuilder switchBuilder = Statements.switchValue(switchOn);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                ImmutableList.Builder caseChunks = ImmutableList.builder();
                for (ExprNode caseExpr : scn.getExprList()) {
                    Expression caseChunk = this.translateExpr(caseExpr);
                    caseChunks.add((Object)caseChunk);
                }
                Statement body = Statements.of(this.visitChildrenInNewSoyScope(scn));
                switchBuilder.addCase((ImmutableList<Expression>)caseChunks.build(), body);
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                Statement body = this.visitSwitchDefaultNode((SwitchDefaultNode)child);
                switchBuilder.setDefault(body);
                continue;
            }
            throw new AssertionError();
        }
        return switchBuilder.build();
    }

    @Override
    protected Statement visitSwitchDefaultNode(SwitchDefaultNode node) {
        return Statements.of(this.visitChildrenInNewSoyScope(node));
    }

    private Expression coerceTypeForSwitchComparison(ExprRootNode expr) {
        Expression switchOn = this.translateExpr(expr);
        SoyType type = expr.getType();
        if (SoyTypes.makeNullish(StringType.getInstance()).isAssignableFromStrict(type) || type.equals(AnyType.getInstance()) || type.equals(UnknownType.getInstance())) {
            CodeChunk.Generator codeGenerator = this.templateTranslationContext.codeGenerator();
            Expression tmp = codeGenerator.declarationBuilder().setRhs(switchOn).build().ref();
            return Expressions.ifExpression(JsRuntime.GOOG_IS_OBJECT.call(tmp), tmp.dotAccess("toString").call(new Expression[0])).setElse(tmp).build(codeGenerator);
        }
        return switchOn;
    }

    protected TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, JsRuntime.OPT_DATA);
    }

    protected Expression translateExpr(ExprNode expr) {
        return (Expression)this.getExprTranslator().exec(expr);
    }

    @Override
    protected Statement visitForNode(ForNode node) {
        Function<Expression, Expression> getDataItemFunction;
        Expression limitInitializer;
        ForNonemptyNode nonEmptyNode = (ForNonemptyNode)node.getChild(0);
        String varPrefix = nonEmptyNode.getVarName() + node.getId();
        Optional<RangeArgs> args = RangeArgs.createFromNode(node);
        if (args.isPresent()) {
            RangeArgs range = args.get();
            Expression start = this.maybeStashInLocal(range.start().isPresent() ? this.translateExpr(range.start().get()) : Expressions.number(0L), varPrefix + "_RangeStart");
            Expression end = this.maybeStashInLocal(this.translateExpr(range.limit()), varPrefix + "_RangeEnd");
            Expression step = this.maybeStashInLocal(range.increment().isPresent() ? this.translateExpr(range.increment().get()) : Expressions.number(1L), varPrefix + "_RangeStep");
            limitInitializer = Expressions.dottedIdNoRequire("Math.max").call(Expressions.number(0L), Expressions.dottedIdNoRequire("Math.ceil").call(end.minus(start).divideBy(step)));
            getDataItemFunction = index -> start.plus(index.times(step));
        } else {
            Expression dataRef = this.translateExpr(node.getExpr());
            String listVarName = varPrefix + "List";
            Expression listVar = VariableDeclaration.builder(listVarName).setRhs(JsRuntime.SOY_AS_READONLY.call(dataRef)).build().ref();
            limitInitializer = listVar.dotAccess("length");
            getDataItemFunction = listVar::bracketAccess;
        }
        Expression limit = VariableDeclaration.builder(varPrefix + "ListLen").setRhs(limitInitializer).build().ref();
        Statement foreachBody = this.handleForeachLoop(nonEmptyNode, limit, getDataItemFunction);
        return foreachBody;
    }

    private Expression maybeStashInLocal(Expression expr, String varName) {
        if (expr.isCheap()) {
            return expr;
        }
        return VariableDeclaration.builder(varName).setRhs(expr).build().ref();
    }

    private Statement handleForeachLoop(ForNonemptyNode node, Expression limit, Function<Expression, Expression> getDataItemFunction) {
        String refPrefix = node.getVarRefName();
        String jsLetPrefix = node.getVarName() + node.getForNodeId();
        String loopIndexName = jsLetPrefix + "Index";
        String dataName = jsLetPrefix + "Data";
        VariableDeclaration data = VariableDeclaration.builder(dataName).setRhs(getDataItemFunction.apply(Expressions.id(loopIndexName))).build();
        try (TranslationContext.ExitScope scope = this.templateTranslationContext.enterSoyAndJsScope();){
            this.templateTranslationContext.soyToJsVariableMappings().put(refPrefix, Expressions.id(dataName));
            if (node.getIndexVar() != null) {
                this.templateTranslationContext.soyToJsVariableMappings().put(node.getIndexVar(), Expressions.id(loopIndexName));
            }
            Statement foreachBody = Statements.of(data, Statements.of(this.visitChildren(node)));
            Statement statement = Statements.forLoop(loopIndexName, limit, foreachBody);
            return statement;
        }
    }

    @Override
    protected Statement visitForNonemptyNode(ForNonemptyNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Statement visitCallNode(CallNode node) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            statements.add(this.visit(child));
        }
        Expression call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator());
        if (node.isErrorFallbackSkip()) {
            VariableDeclaration callResult = VariableDeclaration.builder("call_" + node.getId()).setRhs(call).build();
            return Statements.of(this.outputVars.initOutputVarIfNecessary().orElse(Statements.EMPTY), TryCatch.create(Statements.of(callResult, this.outputVars.addChunkToOutputVar(callResult.ref()))));
        }
        return this.outputVars.addChunkToOutputVar(call.withInitialStatements(statements));
    }

    @Override
    protected Statement visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.outputVars.pushOutputVar("param" + node.getId());
        List<Statement> content = this.visitChildrenInNewSoyScope(node);
        this.outputVars.popOutputVar();
        return Statements.of(content);
    }

    @Override
    protected Statement visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<Expression> logMsgChunks = this.genJsExprsVisitor.execOnChildren(node);
            return JsRuntime.WINDOW_CONSOLE_LOG.call(Expressions.concat(logMsgChunks)).asStatement();
        }
        this.outputVars.pushOutputVar("logMsg_s" + node.getId());
        List<Statement> statements = this.visitChildren(node);
        Expression outputVar = this.outputVars.popOutputVar();
        statements.add(JsRuntime.WINDOW_CONSOLE_LOG.call(outputVar).asStatement());
        return Statements.of(statements);
    }

    @Override
    protected Statement visitKeyNode(KeyNode node) {
        return Statements.of((Iterable<Statement>)ImmutableList.of());
    }

    @Override
    protected Statement visitDebuggerNode(DebuggerNode node) {
        return Statements.debugger();
    }

    @Override
    protected Statement visitVeLogNode(VeLogNode node) {
        if (!node.needsSyntheticVelogNode()) {
            return Statements.of(this.visitChildren(node));
        }
        FunctionNode funcNode = FunctionNode.newPositional(Identifier.create("$$velog", node.getSourceLocation()), VeLogFunction.INSTANCE, node.getSourceLocation());
        funcNode.addChild(node.getVeDataExpression().copy(new CopyState()));
        if (node.getLogonlyExpression() != null) {
            funcNode.addChild(node.getLogonlyExpression().copy(new CopyState()));
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(this.outputVars.addChunksToOutputVar((List<? extends Expression>)ImmutableList.of((Object)Expressions.stringLiteral("<velog"), (Object)((Expression)this.getExprTranslator().exec(funcNode)), (Object)Expressions.stringLiteral(">"))));
        statements.addAll(this.visitChildren(node));
        statements.add(this.outputVars.addChunkToOutputVar(Expressions.stringLiteral("</velog>")));
        return Statements.of(statements);
    }

    @Override
    protected Statement visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        return Statements.of(this.visitChildren(node));
    }

    @Override
    protected Statement visitSoyNode(SoyNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            return this.outputVars.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
        }
        throw new UnsupportedOperationException("implement visit*Node for " + String.valueOf((Object)node.getKind()) + " at " + String.valueOf(node.getSourceLocation()));
    }
}

