/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Expressions;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class GenJsExprsVisitor
extends AbstractSoyNodeVisitor<List<Expression>> {
    private static final SoyErrorKind UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyJsSrcPrintDirective ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
    private final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    protected final TranslationContext translationContext;
    protected final ErrorReporter errorReporter;
    protected List<Expression> chunks;
    protected final Expression dataSource;
    protected final TemplateAliases templateAliases;

    protected GenJsExprsVisitor(JavaScriptValueFactoryImpl javaScriptValueFactory, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitorFactory genJsExprsVisitorFactory, TranslationContext translationContext, ErrorReporter errorReporter, TemplateAliases templateAliases, Expression dataSource) {
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
        this.templateAliases = templateAliases;
        this.dataSource = dataSource;
    }

    @Override
    public List<Expression> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node)));
        this.chunks = new ArrayList<Expression>();
        this.visit(node);
        return this.chunks;
    }

    public List<Expression> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(node));
        this.chunks = new ArrayList<Expression>();
        this.visitChildren(node);
        return this.chunks;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.chunks.add(Expressions.stringLiteral(node.getRawText()));
    }

    @Override
    protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        Expression expr = this.translateExpr(node.getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPrintDirective directive = directiveNode.getPrintDirective();
            if (!(directive instanceof SoyJsSrcPrintDirective)) {
                this.errorReporter.report(node.getSourceLocation(), UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                return;
            }
            ImmutableList<ExprRootNode> argNodes = directiveNode.getArgs();
            ArrayList<Expression> argChunks = new ArrayList<Expression>(argNodes.size());
            for (ExprRootNode argNode : argNodes) {
                argChunks.add(this.translateExpr(argNode));
            }
            expr = SoyJsPluginUtils.applyDirective(expr, (SoyJsSrcPrintDirective)directive, argChunks, node.getSourceLocation(), this.errorReporter);
        }
        this.chunks.add(expr);
    }

    protected TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, this.translationContext, this.templateAliases, this.errorReporter, this.dataSource);
    }

    private Expression translateExpr(ExprRootNode argNode) {
        return (Expression)this.getExprTranslator().exec(argNode);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenJsExprsVisitor genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.translationContext, this.templateAliases, this.errorReporter, this.dataSource);
        CodeChunk.Generator generator = this.translationContext.codeGenerator();
        ArrayList<Expression> ifs = new ArrayList<Expression>();
        ArrayList<Expression> thens = new ArrayList<Expression>();
        Expression trailingElse = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode ifCond = (IfCondNode)child;
                ifs.add(this.getExprTranslator().maybeCoerceToBoolean(ifCond.getExpr().getType(), this.translateExpr(ifCond.getExpr()), false));
                thens.add(Expressions.concat(genJsExprsVisitor.exec(ifCond)));
                continue;
            }
            if (child instanceof IfElseNode) {
                trailingElse = Expressions.concat(genJsExprsVisitor.exec(child));
                continue;
            }
            throw new AssertionError();
        }
        Preconditions.checkState((ifs.size() == thens.size() ? 1 : 0) != 0);
        ConditionalExpressionBuilder builder = Expressions.ifExpression((Expression)ifs.get(0), (Expression)thens.get(0));
        for (int i = 1; i < ifs.size(); ++i) {
            builder.addElseIf((Expression)ifs.get(i), (Expression)thens.get(i));
        }
        Expression ifChunk = trailingElse != null ? builder.setElse(trailingElse).build(generator) : builder.setElse(Expressions.LITERAL_EMPTY_STRING).build(generator);
        this.chunks.add(ifChunk);
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        Expression call = this.genCallCodeUtils.gen(node, this.templateAliases, this.translationContext, this.errorReporter, this.getExprTranslator());
        this.chunks.add(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static class GenJsExprsVisitorFactory {
        protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
        protected final Supplier<GenCallCodeUtils> genCallCodeUtils;
        protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;

        protected GenJsExprsVisitorFactory(JavaScriptValueFactoryImpl javaScriptValueFactory, Supplier<GenCallCodeUtils> genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor) {
            this.javaScriptValueFactory = javaScriptValueFactory;
            this.genCallCodeUtils = genCallCodeUtils;
            this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        }

        public GenJsExprsVisitor create(TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter, Expression dataSource) {
            return new GenJsExprsVisitor(this.javaScriptValueFactory, this.genCallCodeUtils.get(), this.isComputableAsJsExprsVisitor, this, translationContext, errorReporter, templateAliases, dataSource);
        }
    }
}

